/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.loadbalance;

import com.baidu.brpc.client.CommunicationClient;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.loadbalance.LoadBalanceStrategy;
import com.baidu.brpc.loadbalance.RandomStrategy;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.utils.CollectionUtils;
import com.baidu.brpc.utils.CustomThreadFactory;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FairStrategy
implements LoadBalanceStrategy {
    private static final Logger log = LoggerFactory.getLogger(FairStrategy.class);
    private static final int TIMER_DELAY = 60;
    protected CopyOnWriteArrayList<Node> treeContainer = new CopyOnWriteArrayList();
    private volatile Timer timer;
    private RpcClient rpcClient;
    private int latencyWindowSize;
    private float activeInstancesRatio;
    private int minInstancesNum = 3;
    private CopyOnWriteArrayList<CommunicationClient> invalidInstances = new CopyOnWriteArrayList();
    private Random random = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(RpcClient rpcClient) {
        if (this.timer == null) {
            FairStrategy fairStrategy = this;
            synchronized (fairStrategy) {
                if (this.timer == null) {
                    this.timer = new HashedWheelTimer((ThreadFactory)new CustomThreadFactory("fairStrategy-timer-thread"));
                    this.timer.newTimeout(new TimerTask(){

                        public void run(Timeout timeout) {
                            FairStrategy.this.updateWeightTree();
                            FairStrategy.this.timer.newTimeout((TimerTask)this, 60L, TimeUnit.SECONDS);
                        }
                    }, 60L, TimeUnit.SECONDS);
                    this.rpcClient = rpcClient;
                    this.treeContainer = new CopyOnWriteArrayList();
                    this.invalidInstances = new CopyOnWriteArrayList();
                    this.latencyWindowSize = rpcClient.getRpcClientOptions().getLatencyWindowSizeOfFairLoadBalance();
                    this.activeInstancesRatio = rpcClient.getRpcClientOptions().getActiveInstancesRatioOfFairLoadBalance();
                    if (this.latencyWindowSize <= 1) {
                        throw new IllegalArgumentException("latencyWindowSize must be greater than 1");
                    }
                }
            }
        }
    }

    @Override
    public CommunicationClient selectInstance(Request request, List<CommunicationClient> instances, Set<CommunicationClient> selectedInstances) {
        if (this.treeContainer.size() == 0) {
            return new RandomStrategy().selectInstance(request, instances, selectedInstances);
        }
        try {
            Node root = this.treeContainer.get(0);
            CommunicationClient instance = null;
            for (int i = 0; i < 3; ++i) {
                instance = this.fairSelect(root);
                if ((!CollectionUtils.isNotEmpty(selectedInstances) || !selectedInstances.contains(instance)) && !this.invalidInstances.contains(instance)) break;
            }
            if (CollectionUtils.isNotEmpty(selectedInstances) && selectedInstances.contains(instance) || this.invalidInstances.contains(instance)) {
                log.debug("the selected one is invalid, begin to random reselect a new one...");
                return new RandomStrategy().selectInstance(request, instances, selectedInstances);
            }
            return instance;
        }
        catch (Exception e) {
            log.warn("FairStrategy select channel failed.", (Throwable)e);
            return new RandomStrategy().selectInstance(request, instances, selectedInstances);
        }
    }

    @Override
    public void destroy() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void markInvalidInstance(List<CommunicationClient> instances) {
        this.invalidInstances.addAll(instances);
    }

    protected long getRandomLong() {
        long randomIndex = this.random.nextLong();
        if (randomIndex < 0L) {
            randomIndex = 0L - randomIndex;
        }
        return randomIndex;
    }

    protected CommunicationClient fairSelect(Node root) {
        int max = root.weight;
        int randomWeight = this.random.nextInt(max);
        Node selectNode = this.searchNode(root, randomWeight);
        return selectNode.instance;
    }

    protected Node searchNode(Node parent, int weight) {
        if (parent.left == null) {
            return parent;
        }
        if (parent.right == null) {
            return parent.left;
        }
        if (parent.left.weight >= weight) {
            return this.searchNode(parent.left, weight);
        }
        return this.searchNode(parent.right, weight - parent.left.weight);
    }

    protected void updateWeightTree() {
        log.debug("begin to updateWeightTree...");
        int timeout = this.rpcClient.getRpcClientOptions().getReadTimeoutMillis();
        LinkedList<Node> leafNodes = new LinkedList<Node>();
        List<CommunicationClient> instances = this.rpcClient.getNamingServiceProcessor().getInstances();
        if (CollectionUtils.isEmpty(instances)) {
            return;
        }
        LinkedList<CommunicationClient> fullWindowInstances = new LinkedList<CommunicationClient>();
        for (CommunicationClient instance : instances) {
            Queue window = instance.getBrpcChannel().getLatencyWindow();
            if (window.size() != this.latencyWindowSize) continue;
            fullWindowInstances.add(instance);
        }
        if (fullWindowInstances.size() < this.minInstancesNum || (double)fullWindowInstances.size() * 1.0 / (double)instances.size() < (double)this.activeInstancesRatio) {
            this.treeContainer = new CopyOnWriteArrayList();
            this.invalidInstances = new CopyOnWriteArrayList();
            return;
        }
        for (CommunicationClient instance : fullWindowInstances) {
            int weight = this.calculateWeight(instance, timeout);
            leafNodes.add(new Node(instance.hashCode(), weight, true, instance));
        }
        Node root = this.generateWeightTreeByLeafNodes(leafNodes);
        this.treeContainer.add(0, root);
        while (this.treeContainer.size() > 1) {
            this.treeContainer.remove(1);
        }
        this.invalidInstances = new CopyOnWriteArrayList();
    }

    protected int calculateWeight(CommunicationClient instance, int timeout) {
        Queue window = instance.getBrpcChannel().getLatencyWindow();
        int avgLatency = 0;
        Iterator iterator = window.iterator();
        while (iterator.hasNext()) {
            int latency = (Integer)iterator.next();
            avgLatency += latency;
        }
        avgLatency /= window.size();
        int weight = 100 - (avgLatency = avgLatency * 100 / (timeout + 10));
        return weight > 0 ? weight : 1;
    }

    protected Node generateWeightTreeByLeafNodes(Queue<Node> leafNodes) {
        LinkedList<Node> nodes = new LinkedList<Node>(leafNodes);
        if (leafNodes.size() % 2 == 1) {
            nodes.add(Node.none);
        }
        Node root = new Node();
        while (nodes.size() > 0) {
            Node left = (Node)nodes.poll();
            Node right = (Node)nodes.poll();
            if (!left.isLeaf && right == null) {
                root = left;
                break;
            }
            Node parent = new Node(0, 0, false);
            parent.left = left;
            left.parent = parent;
            if (right != null && right != Node.none) {
                parent.right = right;
                parent.weight = left.weight + right.weight;
                right.parent = parent;
            } else {
                parent.weight = left.weight;
            }
            nodes.add(parent);
        }
        return root;
    }

    public static class Node {
        static Node none = new Node();
        int nodeId;
        int weight;
        boolean isLeaf;
        Node parent;
        Node left;
        Node right;
        CommunicationClient instance;

        public Node() {
        }

        public Node(int nodeId, int weight, boolean isLeaf) {
            this.nodeId = nodeId;
            this.weight = weight;
            this.isLeaf = isLeaf;
        }

        public Node(int nodeId, int weight, boolean isLeaf, CommunicationClient instance) {
            this.nodeId = nodeId;
            this.weight = weight;
            this.isLeaf = isLeaf;
            this.instance = instance;
        }
    }
}

