/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.loadbalance;

import com.baidu.brpc.loadbalance.LoadBalanceFactory;
import com.baidu.brpc.loadbalance.LoadBalanceStrategy;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalanceManager {
    private static final Logger log = LoggerFactory.getLogger(LoadBalanceManager.class);
    private static volatile LoadBalanceManager instance;
    private Map<Integer, LoadBalanceFactory> loadBalanceFactoryMap = new HashMap<Integer, LoadBalanceFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoadBalanceManager getInstance() {
        if (instance != null) return instance;
        Class<LoadBalanceManager> clazz = LoadBalanceManager.class;
        synchronized (LoadBalanceManager.class) {
            if (instance != null) return instance;
            instance = new LoadBalanceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LoadBalanceManager() {
    }

    public void registerLoadBalanceFactory(LoadBalanceFactory factory) {
        Integer loadBalanceType = factory.getLoadBalanceType();
        if (this.loadBalanceFactoryMap.get(loadBalanceType) != null) {
            throw new RuntimeException("load balance factory already exist:" + loadBalanceType);
        }
        this.loadBalanceFactoryMap.put(loadBalanceType, factory);
        log.info("register load balance factory:{} success", (Object)factory.getClass().getSimpleName());
    }

    public LoadBalanceFactory getLoadBalanceFactory(Integer loadBalanceType) {
        return this.loadBalanceFactoryMap.get(loadBalanceType);
    }

    public LoadBalanceStrategy createLoadBalance(Integer loadBalanceType) {
        LoadBalanceFactory factory = this.loadBalanceFactoryMap.get(loadBalanceType);
        if (factory == null) {
            throw new IllegalArgumentException("load balance not exist:" + loadBalanceType);
        }
        return factory.createLoadBalance();
    }
}

