/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.loadbalance;

import com.baidu.brpc.client.CommunicationClient;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.loadbalance.LoadBalanceStrategy;
import com.baidu.brpc.protocol.Request;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class RandomStrategy
implements LoadBalanceStrategy {
    private final Random random = new Random();

    @Override
    public void init(RpcClient rpcClient) {
    }

    @Override
    public CommunicationClient selectInstance(Request request, List<CommunicationClient> instances, Set<CommunicationClient> selectedInstances) {
        if (CollectionUtils.isEmpty(instances)) {
            return null;
        }
        Collection<Object> toBeSelectedInstances = null;
        toBeSelectedInstances = selectedInstances == null ? instances : CollectionUtils.subtract(instances, selectedInstances);
        int instanceNum = toBeSelectedInstances.size();
        if (instanceNum == 0) {
            toBeSelectedInstances = instances;
            instanceNum = toBeSelectedInstances.size();
        }
        if (instanceNum == 0) {
            return null;
        }
        int index = this.getRandomInt(instanceNum);
        CommunicationClient serviceInstance = toBeSelectedInstances.toArray(new CommunicationClient[0])[index];
        return serviceInstance;
    }

    @Override
    public void destroy() {
    }

    private int getRandomInt(int bound) {
        int randomIndex = this.random.nextInt(bound);
        return randomIndex;
    }
}

