/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.GovernanceSpiManager;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.naming.BrpcURL;
import com.baidu.brpc.naming.NamingService;
import com.baidu.brpc.naming.NamingServiceFactory;
import com.baidu.brpc.naming.NamingServiceFactoryManager;
import com.baidu.brpc.naming.RegisterInfo;
import com.baidu.brpc.protocol.NamingOptions;
import com.baidu.brpc.server.InterceptCommunicationServer;
import com.baidu.brpc.server.RpcServerOptions;
import com.baidu.brpc.utils.NetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServer
extends InterceptCommunicationServer {
    private static final Logger log = LoggerFactory.getLogger(RpcServer.class);
    private NamingService namingService;
    private List<RegisterInfo> registerInfoList = new ArrayList<RegisterInfo>();
    private AtomicBoolean stop = new AtomicBoolean(false);

    public RpcServer(int port) {
        this(null, port, new RpcServerOptions(), null);
    }

    public RpcServer(String host, int port) {
        this(host, port, new RpcServerOptions(), null);
    }

    public RpcServer(int port, RpcServerOptions options) {
        this(null, port, options, null);
    }

    public RpcServer(String host, int port, RpcServerOptions options) {
        this(host, port, options, null);
    }

    public RpcServer(int port, RpcServerOptions options, List<Interceptor> interceptors) {
        this(null, port, options, interceptors);
    }

    public RpcServer(String host, int port, RpcServerOptions options, List<Interceptor> interceptors) {
        super(host, port, options, interceptors);
        GovernanceSpiManager.getInstance().loadAllExtensions();
        if (StringUtils.isNotBlank((CharSequence)this.rpcServerOptions.getNamingServiceUrl())) {
            BrpcURL url = new BrpcURL(this.rpcServerOptions.getNamingServiceUrl());
            NamingServiceFactory namingServiceFactory = NamingServiceFactoryManager.getInstance().getNamingServiceFactory(url.getSchema());
            this.namingService = namingServiceFactory.createNamingService(url);
        }
    }

    public void registerService(Object service, Class targetClass, NamingOptions namingOptions, RpcServerOptions serverOptions) {
        super.registerService(service, targetClass, namingOptions, serverOptions);
        RegisterInfo registerInfo = null;
        registerInfo = namingOptions != null ? new RegisterInfo(namingOptions) : new RegisterInfo();
        if (targetClass != null) {
            registerInfo.setInterfaceName(targetClass.getInterfaces()[0].getName());
        } else {
            registerInfo.setInterfaceName(service.getClass().getInterfaces()[0].getName());
        }
        registerInfo.setHost(NetUtils.getLocalAddress().getHostAddress());
        registerInfo.setPort(this.port);
        this.registerInfoList.add(registerInfo);
    }

    public void start() {
        super.start();
        if (this.namingService != null) {
            for (RegisterInfo registerInfo : this.registerInfoList) {
                registerInfo.setPort(this.port);
                this.namingService.register(registerInfo);
            }
            log.info("server register on success");
        }
    }

    public boolean shutdown() {
        if (super.shutdown()) {
            if (this.namingService != null) {
                for (RegisterInfo registerInfo : this.registerInfoList) {
                    this.namingService.unregister(registerInfo);
                }
                this.namingService.destroy();
            }
            return true;
        }
        return false;
    }

    public boolean isShutdown() {
        return this.stop.get();
    }

    public NamingService getNamingService() {
        return this.namingService;
    }

    public List<RegisterInfo> getRegisterInfoList() {
        return this.registerInfoList;
    }

    public AtomicBoolean getStop() {
        return this.stop;
    }
}

