/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.doc;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.PutObjectResponse;
import com.baidubce.services.doc.model.CreateDocumentFromBosRequest;
import com.baidubce.services.doc.model.CreateDocumentFromBosResponse;
import com.baidubce.services.doc.model.CreateDocumentRequest;
import com.baidubce.services.doc.model.CreateDocumentResponse;
import com.baidubce.services.doc.model.CreateNotificationRequest;
import com.baidubce.services.doc.model.CreateNotificationResponse;
import com.baidubce.services.doc.model.DeleteDocumentRequest;
import com.baidubce.services.doc.model.DeleteDocumentResponse;
import com.baidubce.services.doc.model.DeleteNotificationRequest;
import com.baidubce.services.doc.model.DeleteNotificationResponse;
import com.baidubce.services.doc.model.DisableReadTokenRequest;
import com.baidubce.services.doc.model.DisableReadTokenResponse;
import com.baidubce.services.doc.model.GetDocumentDownloadRequest;
import com.baidubce.services.doc.model.GetDocumentDownloadResponse;
import com.baidubce.services.doc.model.GetDocumentImagesRequest;
import com.baidubce.services.doc.model.GetDocumentImagesResponse;
import com.baidubce.services.doc.model.GetDocumentRequest;
import com.baidubce.services.doc.model.GetDocumentResponse;
import com.baidubce.services.doc.model.GetNotificationRequest;
import com.baidubce.services.doc.model.GetNotificationResponse;
import com.baidubce.services.doc.model.ListDocumentsRequest;
import com.baidubce.services.doc.model.ListDocumentsResponse;
import com.baidubce.services.doc.model.ListNotificationsRequest;
import com.baidubce.services.doc.model.ListNotificationsResponse;
import com.baidubce.services.doc.model.PublishDocumentRequest;
import com.baidubce.services.doc.model.PublishDocumentResponse;
import com.baidubce.services.doc.model.ReadDocumentRequest;
import com.baidubce.services.doc.model.ReadDocumentResponse;
import com.baidubce.services.doc.model.RegisterDocumentRequest;
import com.baidubce.services.doc.model.RegisterDocumentResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;

public class DocClient
extends AbstractBceClient {
    private static final String VERSION = "v2";
    private static final String DOC = "document";
    private static final String NOTIFICATION = "notification";
    private static final HttpResponseHandler[] docHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    @Override
    public boolean isRegionSupported() {
        return false;
    }

    public DocClient() {
        this(new BceClientConfiguration());
    }

    public DocClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, docHandlers);
    }

    public CreateDocumentResponse createDocument(File file, String title, String format) {
        CreateDocumentRequest request = new CreateDocumentRequest();
        request.setFile(file);
        request.setTitle(title);
        request.setFormat(format);
        return this.createDocument(request);
    }

    public CreateDocumentResponse createDocument(File file, String title) {
        CreateDocumentRequest request = new CreateDocumentRequest();
        String filename = file.getName();
        if (filename.lastIndexOf(".") == -1) {
            throw new BceClientException("Cannot get file format from file name:" + filename);
        }
        String format = filename.substring(filename.lastIndexOf(".") + 1);
        request.setFile(file);
        request.setTitle(title);
        request.setFormat(format);
        return this.createDocument(request);
    }

    public CreateDocumentResponse createDocument(File file, String title, String format, String notification) {
        CreateDocumentRequest request = new CreateDocumentRequest();
        request.setFile(file);
        request.setTitle(title);
        request.setFormat(format);
        request.setNotification(notification);
        return this.createDocument(request);
    }

    public CreateDocumentResponse createDocument(File file, String title, String format, String notification, String access) {
        CreateDocumentRequest request = new CreateDocumentRequest();
        request.setFile(file);
        request.setTitle(title);
        request.setFormat(format);
        request.setNotification(notification);
        request.setAccess(access);
        return this.createDocument(request);
    }

    public CreateDocumentResponse createDocument(File file, String title, String format, String notification, String access, String targetType) {
        CreateDocumentRequest request = new CreateDocumentRequest();
        request.setFile(file);
        request.setTitle(title);
        request.setFormat(format);
        request.setNotification(notification);
        request.setAccess(access);
        request.setTargetType(targetType);
        return this.createDocument(request);
    }

    public CreateDocumentResponse createDocument(CreateDocumentRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkNotNull(request.getFile(), "file should not be null.");
        Validate.checkNotNull(request.getTitle(), "title should not be null.");
        Validate.checkNotNull(request.getFormat(), "format should not be null.");
        RegisterDocumentRequest regRequest = new RegisterDocumentRequest();
        regRequest.setFormat(request.getFormat());
        regRequest.setTitle(request.getTitle());
        regRequest.setNotification(request.getNotification());
        regRequest.setAccess(request.getAccess());
        regRequest.setTargetType(request.getTargetType());
        RegisterDocumentResponse regResponse = this.registerDocument(regRequest);
        this.bosUploadDocument(regResponse.getBucket(), regResponse.getObject(), request.getFile(), regResponse.getBosEndpoint());
        PublishDocumentRequest pubRequest = new PublishDocumentRequest();
        pubRequest.setDocumentId(regResponse.getDocumentId());
        this.publishDocument(pubRequest);
        CreateDocumentResponse response = new CreateDocumentResponse();
        response.setDocumentId(regResponse.getDocumentId());
        return response;
    }

    public CreateDocumentFromBosResponse createDocumentFromBos(String bucket, String object, String title, String format, String notification) {
        CreateDocumentFromBosRequest request = new CreateDocumentFromBosRequest();
        request.setBucket(bucket);
        request.setObject(object);
        request.setTitle(title);
        request.setFormat(format);
        request.setNotification(notification);
        return this.createDocumentFromBos(request);
    }

    public CreateDocumentFromBosResponse createDocumentFromBos(String bucket, String object, String title, String format, String notification, String access) {
        CreateDocumentFromBosRequest request = new CreateDocumentFromBosRequest();
        request.setBucket(bucket);
        request.setObject(object);
        request.setTitle(title);
        request.setFormat(format);
        request.setNotification(notification);
        request.setAccess(access);
        return this.createDocumentFromBos(request);
    }

    public CreateDocumentFromBosResponse createDocumentFromBos(String bucket, String object, String title, String format, String notification, String access, String targetType) {
        CreateDocumentFromBosRequest request = new CreateDocumentFromBosRequest();
        request.setBucket(bucket);
        request.setObject(object);
        request.setTitle(title);
        request.setFormat(format);
        request.setNotification(notification);
        request.setAccess(access);
        request.setTargetType(targetType);
        return this.createDocumentFromBos(request);
    }

    public CreateDocumentFromBosResponse createDocumentFromBos(String bucket, String object, String title, String format) {
        CreateDocumentFromBosRequest request = new CreateDocumentFromBosRequest();
        request.setBucket(bucket);
        request.setObject(object);
        request.setTitle(title);
        request.setFormat(format);
        return this.createDocumentFromBos(request);
    }

    public CreateDocumentFromBosResponse createDocumentFromBos(CreateDocumentFromBosRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkNotNull(request.getBucket(), "bucket should not be null.");
        Validate.checkNotNull(request.getObject(), "object should not be null.");
        Validate.checkNotNull(request.getTitle(), "title should not be null.");
        Validate.checkNotNull(request.getFormat(), "format should not be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, DOC);
        internalRequest.addParameter("source", "bos");
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return this.invokeHttpClient(internalRequest, CreateDocumentFromBosResponse.class);
    }

    private RegisterDocumentResponse registerDocument(RegisterDocumentRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, DOC);
        internalRequest.addParameter("register", null);
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return this.invokeHttpClient(internalRequest, RegisterDocumentResponse.class);
    }

    private void bosUploadDocument(String bucketName, String objectName, File file, String endpoint) {
        BosClientConfiguration config = new BosClientConfiguration(this.config);
        config.setEndpoint(endpoint);
        BosClient bosClient = new BosClient(config);
        PutObjectResponse response = bosClient.putObject(bucketName, objectName, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublishDocumentResponse publishDocument(PublishDocumentRequest request) {
        PublishDocumentResponse response;
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkNotNull(request.getDocumentId(), "documentId should not be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, DOC, request.getDocumentId());
        internalRequest.addParameter("publish", null);
        internalRequest.addHeader("Content-Length", "0");
        try {
            response = this.invokeHttpClient(internalRequest, PublishDocumentResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    public GetDocumentResponse getDocument(String documentId) {
        GetDocumentRequest request = new GetDocumentRequest();
        request.setDocumentId(documentId);
        return this.getDocument(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetDocumentResponse getDocument(GetDocumentRequest request) {
        GetDocumentResponse response;
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkNotNull(request.getDocumentId(), "documentId should not be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, DOC, request.getDocumentId());
        try {
            response = this.invokeHttpClient(internalRequest, GetDocumentResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetDocumentImagesResponse getDocumentImages(String documentId) {
        GetDocumentImagesResponse response;
        Validate.checkNotNull(documentId, "documentId should not be null.");
        GetDocumentImagesRequest request = new GetDocumentImagesRequest();
        request.setDocumentId(documentId);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, DOC, request.getDocumentId());
        internalRequest.addParameter("getImages", null);
        try {
            response = this.invokeHttpClient(internalRequest, GetDocumentImagesResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListDocumentsResponse listDocuments() {
        ListDocumentsResponse response;
        ListDocumentsRequest request = new ListDocumentsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, DOC);
        try {
            response = this.invokeHttpClient(internalRequest, ListDocumentsResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListDocumentsResponse listDocuments(String status) {
        ListDocumentsResponse response;
        ListDocumentsRequest request = new ListDocumentsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, DOC);
        internalRequest.addParameter("status", status);
        try {
            response = this.invokeHttpClient(internalRequest, ListDocumentsResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListDocumentsResponse listDocuments(String status, String marker, int maxSize) {
        ListDocumentsResponse response;
        ListDocumentsRequest request = new ListDocumentsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, DOC);
        internalRequest.addParameter("status", status);
        if (marker != null) {
            internalRequest.addParameter("marker", marker);
        }
        internalRequest.addParameter("maxSize", String.valueOf(maxSize));
        try {
            response = this.invokeHttpClient(internalRequest, ListDocumentsResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    public DeleteDocumentResponse deleteDocument(String documentId) {
        DeleteDocumentRequest request = new DeleteDocumentRequest();
        request.setDocumentId(documentId);
        return this.deleteDocument(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteDocumentResponse deleteDocument(DeleteDocumentRequest request) {
        DeleteDocumentResponse response;
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkNotNull(request.getDocumentId(), "documentId should not be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, DOC, request.getDocumentId());
        try {
            response = this.invokeHttpClient(internalRequest, DeleteDocumentResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetDocumentDownloadResponse getDocumentDownload(String documentId) {
        GetDocumentDownloadResponse response;
        Validate.checkNotNull(documentId, "documentId should not be null.");
        GetDocumentDownloadRequest request = new GetDocumentDownloadRequest();
        request.setDocumentId(documentId);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, DOC, request.getDocumentId());
        internalRequest.addParameter("download", null);
        try {
            response = this.invokeHttpClient(internalRequest, GetDocumentDownloadResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetDocumentDownloadResponse getDocumentDownload(String documentId, long expireInSeconds) {
        GetDocumentDownloadResponse response;
        Validate.checkNotNull(documentId, "documentId should not be null.");
        GetDocumentDownloadRequest request = new GetDocumentDownloadRequest();
        request.setDocumentId(documentId);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, DOC, request.getDocumentId());
        internalRequest.addParameter("download", null);
        internalRequest.addParameter("expireInSeconds", String.valueOf(expireInSeconds));
        try {
            response = this.invokeHttpClient(internalRequest, GetDocumentDownloadResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    public ReadDocumentResponse readDocument(String documentId) {
        ReadDocumentRequest request = new ReadDocumentRequest();
        request.setDocumentId(documentId);
        return this.readDocument(request);
    }

    public ReadDocumentResponse readDocument(String documentId, long expireInSeconds) {
        ReadDocumentRequest request = new ReadDocumentRequest();
        request.setDocumentId(documentId);
        request.setExpireInSeconds(expireInSeconds);
        return this.readDocument(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadDocumentResponse readDocument(ReadDocumentRequest request) {
        ReadDocumentResponse response;
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkNotNull(request.getDocumentId(), "documentId should not be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, DOC, request.getDocumentId());
        internalRequest.addParameter("read", null);
        internalRequest.addParameter("expireInSeconds", String.valueOf(request.getExpireInSeconds()));
        try {
            response = this.invokeHttpClient(internalRequest, ReadDocumentResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    public DisableReadTokenResponse disableReadToken(String documentId, String token) {
        DisableReadTokenRequest request = new DisableReadTokenRequest();
        request.setDocumentId(documentId);
        request.setToken(token);
        return this.disableReadToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisableReadTokenResponse disableReadToken(DisableReadTokenRequest request) {
        DisableReadTokenResponse response;
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkNotNull(request.getDocumentId(), "documentId should not be null.");
        Validate.checkNotNull(request.getToken(), "token should not be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, DOC, request.getDocumentId());
        internalRequest.addParameter("disableReadToken", null);
        internalRequest.addParameter("token", request.getToken());
        try {
            response = this.invokeHttpClient(internalRequest, DisableReadTokenResponse.class);
        }
        finally {
            try {
                internalRequest.getContent().close();
            }
            catch (Exception exception) {}
        }
        return response;
    }

    public ListNotificationsResponse listNotifications() {
        ListNotificationsRequest request = new ListNotificationsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, NOTIFICATION);
        return this.invokeHttpClient(internalRequest, ListNotificationsResponse.class);
    }

    public DeleteNotificationResponse deleteNotification(String name) {
        DeleteNotificationRequest request = new DeleteNotificationRequest();
        request.setName(name);
        return this.deleteNotification(request);
    }

    public DeleteNotificationResponse deleteNotification(DeleteNotificationRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, DeleteNotificationResponse.class);
    }

    public GetNotificationResponse getNotification(String name) {
        GetNotificationRequest request = new GetNotificationRequest();
        request.setName(name);
        return this.getNotification(request);
    }

    public GetNotificationResponse getNotification(GetNotificationRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, GetNotificationResponse.class);
    }

    public CreateNotificationResponse createNotification(String name, String endpoint) {
        CreateNotificationRequest request = new CreateNotificationRequest();
        request.withName(name).withEndpoint(endpoint);
        return this.createNotification(request);
    }

    public CreateNotificationResponse createNotification(CreateNotificationRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getEndpoint(), "The parameter endpoint should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, NOTIFICATION);
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return this.invokeHttpClient(internalRequest, CreateNotificationResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        return internalRequest;
    }
}

