/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdm;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.iotdm.IotDmClientHelper;
import com.baidubce.services.iotdm.model.CreateDevicesRequest;
import com.baidubce.services.iotdm.model.CreateDevicesResponse;
import com.baidubce.services.iotdm.model.CreateGroupRequest;
import com.baidubce.services.iotdm.model.DeviceAccessDetail;
import com.baidubce.services.iotdm.model.DeviceOperationRequest;
import com.baidubce.services.iotdm.model.DeviceProfileResponse;
import com.baidubce.services.iotdm.model.DeviceQueryRequest;
import com.baidubce.services.iotdm.model.DeviceQueryResponse;
import com.baidubce.services.iotdm.model.GroupInfoResponse;
import com.baidubce.services.iotdm.model.GroupListResponse;
import com.baidubce.services.iotdm.model.RemoveDevicesRequest;
import com.baidubce.services.iotdm.model.UpdateDeviceProfileRequest;
import com.baidubce.services.iotdm.model.UpdateDeviceRegistryRequest;
import com.baidubce.services.iotdm.model.UpdateGroupRequest;
import com.google.common.base.Preconditions;

public class IotDmClient
extends AbstractBceClient {
    private static final String ENDPOINT_HOST = "iotdm.gz.baidubce.com";
    private static final String DEVICE = "device";
    private static final String GROUP = "group";
    private static final String CHILDREN = "children";
    private static final String ACCESS_DETAIL = "accessDetail";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";
    private static final String QUERY = "query";
    private static final String REBOOT = "reboot";
    private static final String REMOVE = "remove";
    private static final String ROOT = "root";
    private static final String UPDATE_PROFILE = "updateProfile";
    private static final String UPDATE_REGISTRY = "updateRegistry";

    public IotDmClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT_HOST) : config, IotDmClientHelper.IOT_DM_HANDLERS);
    }

    public CreateDevicesResponse createDevices(CreateDevicesRequest createDevicesRequest, String clientToken) {
        return this.doCreation(createDevicesRequest, clientToken, DEVICE, CreateDevicesResponse.class);
    }

    public void removeDevices(RemoveDevicesRequest removeDevicesRequest) {
        this.deviceBatchOperation(removeDevicesRequest, REMOVE);
    }

    public DeviceProfileResponse getDeviceProfile(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)"device name should not be null.");
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, deviceName);
        return this.invokeHttpClient(internalRequest, DeviceProfileResponse.class);
    }

    public DeviceQueryResponse getDeviceProfiles(DeviceQueryRequest deviceQueryRequest) {
        Preconditions.checkNotNull((Object)deviceQueryRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(deviceQueryRequest, HttpMethodName.PUT, DEVICE);
        internalRequest.addParameter(QUERY, null);
        return this.invokeHttpClient(internalRequest, DeviceQueryResponse.class);
    }

    public DeviceAccessDetail getDeviceAccessDetail(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)"device name should not be null.");
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, deviceName, ACCESS_DETAIL);
        return this.invokeHttpClient(internalRequest, DeviceAccessDetail.class);
    }

    public void updateDeviceProfile(UpdateDeviceProfileRequest updateDeviceProfileRequest) {
        this.deviceBatchOperation(updateDeviceProfileRequest, UPDATE_PROFILE);
    }

    public void updateDeviceRegistry(UpdateDeviceRegistryRequest updateDeviceRegistryRequest) {
        this.deviceBatchOperation(updateDeviceRegistryRequest, UPDATE_REGISTRY);
    }

    public void disableDevices(DeviceOperationRequest deviceOperationRequest) {
        this.deviceBatchOperation(deviceOperationRequest, DISABLE);
    }

    public void enableDevices(DeviceOperationRequest deviceOperationRequest) {
        this.deviceBatchOperation(deviceOperationRequest, ENABLE);
    }

    public void rebootDevices(DeviceOperationRequest deviceOperationRequest) {
        this.deviceBatchOperation(deviceOperationRequest, REBOOT);
    }

    public GroupInfoResponse createGroup(CreateGroupRequest createGroupRequest, String clientToken) {
        return this.doCreation(createGroupRequest, clientToken, GROUP, GroupInfoResponse.class);
    }

    public void removeGroup(String groupId) {
        Preconditions.checkNotNull((Object)groupId, (Object)"groupId should not be null.");
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, GROUP, groupId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateGroup(String groupId, UpdateGroupRequest updateGroupRequest) {
        Preconditions.checkNotNull((Object)groupId, (Object)"groupId should not be null.");
        Preconditions.checkNotNull((Object)updateGroupRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(updateGroupRequest, HttpMethodName.PUT, GROUP, groupId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GroupInfoResponse getGroup(String groupId) {
        Preconditions.checkNotNull((Object)groupId, (Object)"groupId should not be null.");
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, GROUP, groupId);
        return this.invokeHttpClient(internalRequest, GroupInfoResponse.class);
    }

    public GroupListResponse getChildGroups(String groupId) {
        Preconditions.checkNotNull((Object)groupId, (Object)"groupId should not be null.");
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, GROUP, groupId, CHILDREN);
        return this.invokeHttpClient(internalRequest, GroupListResponse.class);
    }

    public GroupListResponse getRootGroups() {
        return this.getGroups(ROOT);
    }

    public GroupListResponse getDeviceGroups() {
        return this.getGroups(DEVICE);
    }

    private <T extends AbstractBceResponse> T doCreation(AbstractBceRequest request, String clientToken, String objectPath, Class<T> responseClass) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)clientToken, (Object)"client token should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, objectPath);
        internalRequest.addParameter(CLIENT_TOKEN, clientToken);
        return this.invokeHttpClient(internalRequest, responseClass);
    }

    private void deviceBatchOperation(AbstractBceRequest request, String parameter) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICE);
        internalRequest.addParameter(parameter, null);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private GroupListResponse getGroups(String param) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, GROUP);
        internalRequest.addParameter(param, null);
        return this.invokeHttpClient(internalRequest, GroupListResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        return IotDmClientHelper.createRequestForV1(bceRequest, httpMethod, this.getEndpoint(), null, pathVariables);
    }
}

