/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.moladb.model.ListTablesResponse;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class ListTablesResponseUnmarshaller
implements Unmarshaller<ListTablesResponse, InputStream> {
    private ListTablesResponse result = null;

    public ListTablesResponseUnmarshaller(AbstractBceResponse ret) {
        this.result = (ListTablesResponse)ret;
    }

    @Override
    public ListTablesResponse unmarshall(InputStream stream) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(stream);
        if (streamContents.isEmpty()) {
            return null;
        }
        JsonNode jsonObj = JsonUtils.jsonNodeOf(streamContents);
        if (!jsonObj.isObject()) {
            throw new BceClientException("json node:" + jsonObj.toString() + "is not object");
        }
        JsonNode tablesObj = jsonObj.get("tableNames");
        if (tablesObj != null) {
            Iterator namesObj = tablesObj.elements();
            ArrayList<String> names = new ArrayList<String>();
            while (namesObj.hasNext()) {
                names.add(((JsonNode)namesObj.next()).asText());
            }
            this.result.setTableNames(names);
        }
        return this.result;
    }
}

