/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator.druid;

import com.alibaba.druid.wall.WallConfig;
import com.baomidou.dynamic.datasource.toolkit.DsConfigUtil;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidWallConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(DruidWallConfigUtil.class);
    private static final Map<String, Method> METHODS = DsConfigUtil.getSetterMethods(WallConfig.class);

    public static WallConfig toWallConfig(Map<String, Object> c, Map<String, Object> g) {
        WallConfig wallConfig = new WallConfig();
        Map<String, Object> map = DsConfigUtil.mergeConfig(c, g);
        Object dir = map.get("dir");
        if (dir != null) {
            wallConfig.loadConfig(String.valueOf(dir));
        }
        for (Map.Entry<String, Object> item : map.entrySet()) {
            String key = DsConfigUtil.lineToUpper(item.getKey());
            Method method = METHODS.get(key);
            if (method != null) {
                try {
                    method.invoke((Object)wallConfig, DsConfigUtil.convertValue(method, item.getValue()));
                }
                catch (Exception e) {
                    log.warn("druid wall set param {} error", (Object)key, (Object)e);
                }
                continue;
            }
            log.warn("druid wall does not have param {}", (Object)key);
        }
        return wallConfig;
    }
}

