/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.wall.WallConfig;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidConfig {
    private static final Logger log = LoggerFactory.getLogger(DruidConfig.class);
    private Integer initialSize;
    private Integer maxActive;
    private Integer minIdle;
    private Long maxWait;
    private Long timeBetweenEvictionRunsMillis;
    private Long timeBetweenLogStatsMillis;
    private Integer statSqlMaxSize;
    private Long minEvictableIdleTimeMillis;
    private Long maxEvictableIdleTimeMillis;
    private Boolean testWhileIdle;
    private Boolean testOnBorrow;
    private Boolean testOnReturn;
    private String validationQuery;
    private Integer validationQueryTimeout;
    private Boolean useGlobalDataSourceStat;
    private Boolean asyncInit;
    private String filters;
    private Boolean clearFiltersEnable;
    private Boolean resetStatEnable;
    private Integer notFullTimeoutRetryCount;
    private Integer maxWaitThreadCount;
    private Boolean failFast;
    private Integer phyTimeoutMillis;
    private Boolean keepAlive;
    private Boolean poolPreparedStatements;
    private Boolean initVariants;
    private Boolean initGlobalVariants;
    private Boolean useUnfairLock;
    private Boolean killWhenSocketReadTimeout;
    private Properties connectionProperties;
    private Integer maxPoolPreparedStatementPerConnectionSize;
    private String initConnectionSqls;
    private Boolean sharePreparedStatements;
    private Integer connectionErrorRetryAttempts;
    private Boolean breakAfterAcquireFailure;
    private String publicKey;
    private DruidWallConfig wall = new DruidWallConfig();
    private DruidStatConfig stat = new DruidStatConfig();

    public Properties toProperties(DruidConfig globalConfig) {
        Boolean tempMergeSql;
        Long tempSlowSqlMillis;
        Boolean tempLogSlowSql;
        String tempInitConnectionSqls;
        Integer tempMaxPoolPreparedStatementPerConnectionSize;
        Properties tempConnectProperties;
        Boolean tempKillWhenSocketReadTimeout;
        Boolean tempUseUnfairLock;
        Boolean tempInitGlobalVariants;
        Boolean tempInitVariants;
        Boolean tempPoolPreparedStatements;
        Boolean tempKeepAlive;
        Integer tempPhyTimeoutMillis;
        Boolean tempFailFast;
        Integer tempMaxWaitThreadCount;
        Integer tempNotFullTimeoutRetryCount;
        Boolean tempResetStatEnable;
        Boolean tempClearFiltersEnable;
        String tempFilters;
        Boolean tempAsyncInit;
        Boolean tempUseGlobalDataSourceStat;
        String tempValidationQuery;
        Boolean tempTestOnBorrow;
        Boolean tempTestWhileIdle;
        Long tempMaxEvictableIdleTimeMillis;
        Long tempMinEvictableIdleTimeMillis;
        Integer tempStatSqlMaxSize;
        Long tempTimeBetweenLogStatsMillis;
        Long tempTimeBetweenEvictionRunsMillis;
        Long tempMaxWait;
        Integer tempMinIdle;
        Integer tempMaxActive;
        Integer tempInitialSize;
        Properties properties = new Properties();
        Integer n = tempInitialSize = this.initialSize == null ? globalConfig.getInitialSize() : this.initialSize;
        if (tempInitialSize != null && !tempInitialSize.equals(0)) {
            properties.setProperty("druid.initialSize", String.valueOf(tempInitialSize));
        }
        Integer n2 = tempMaxActive = this.maxActive == null ? globalConfig.getMaxActive() : this.maxActive;
        if (tempMaxActive != null && !tempMaxActive.equals(-1)) {
            properties.setProperty("druid.maxActive", String.valueOf(tempMaxActive));
        }
        Integer n3 = tempMinIdle = this.minIdle == null ? globalConfig.getMinIdle() : this.minIdle;
        if (tempMinIdle != null && !tempMinIdle.equals(0)) {
            properties.setProperty("druid.minIdle", String.valueOf(tempMinIdle));
        }
        Long l = tempMaxWait = this.maxWait == null ? globalConfig.getMaxWait() : this.maxWait;
        if (tempMaxWait != null && !tempMaxWait.equals(-1)) {
            properties.setProperty("druid.maxWait", String.valueOf(tempMaxWait));
        }
        Long l2 = tempTimeBetweenEvictionRunsMillis = this.timeBetweenEvictionRunsMillis == null ? globalConfig.getTimeBetweenEvictionRunsMillis() : this.timeBetweenEvictionRunsMillis;
        if (tempTimeBetweenEvictionRunsMillis != null && !tempTimeBetweenEvictionRunsMillis.equals(60000L)) {
            properties.setProperty("druid.timeBetweenEvictionRunsMillis", String.valueOf(tempTimeBetweenEvictionRunsMillis));
        }
        Long l3 = tempTimeBetweenLogStatsMillis = this.timeBetweenLogStatsMillis == null ? globalConfig.getTimeBetweenLogStatsMillis() : this.timeBetweenLogStatsMillis;
        if (tempTimeBetweenLogStatsMillis != null && tempTimeBetweenLogStatsMillis > 0L) {
            properties.setProperty("druid.timeBetweenLogStatsMillis", String.valueOf(tempTimeBetweenLogStatsMillis));
        }
        Integer n4 = tempStatSqlMaxSize = this.statSqlMaxSize == null ? globalConfig.getStatSqlMaxSize() : this.statSqlMaxSize;
        if (tempStatSqlMaxSize != null) {
            properties.setProperty("druid.stat.sql.MaxSize", String.valueOf(tempStatSqlMaxSize));
        }
        Long l4 = tempMinEvictableIdleTimeMillis = this.minEvictableIdleTimeMillis == null ? globalConfig.getMinEvictableIdleTimeMillis() : this.minEvictableIdleTimeMillis;
        if (tempMinEvictableIdleTimeMillis != null && !tempMinEvictableIdleTimeMillis.equals(1800000L)) {
            properties.setProperty("druid.minEvictableIdleTimeMillis", String.valueOf(tempMinEvictableIdleTimeMillis));
        }
        Long l5 = tempMaxEvictableIdleTimeMillis = this.maxEvictableIdleTimeMillis == null ? globalConfig.getMaxEvictableIdleTimeMillis() : this.maxEvictableIdleTimeMillis;
        if (tempMaxEvictableIdleTimeMillis != null && !tempMaxEvictableIdleTimeMillis.equals(25200000L)) {
            properties.setProperty("druid.maxEvictableIdleTimeMillis", String.valueOf(tempMaxEvictableIdleTimeMillis));
        }
        Boolean bl = tempTestWhileIdle = this.testWhileIdle == null ? globalConfig.getTestWhileIdle() : this.testWhileIdle;
        if (tempTestWhileIdle != null && !tempTestWhileIdle.equals(true)) {
            properties.setProperty("druid.testWhileIdle", "false");
        }
        Boolean bl2 = tempTestOnBorrow = this.testOnBorrow == null ? globalConfig.getTestOnBorrow() : this.testOnBorrow;
        if (tempTestOnBorrow != null && !tempTestOnBorrow.equals(false)) {
            properties.setProperty("druid.testOnBorrow", "true");
        }
        String string = tempValidationQuery = this.validationQuery == null ? globalConfig.getValidationQuery() : this.validationQuery;
        if (tempValidationQuery != null && tempValidationQuery.length() > 0) {
            properties.setProperty("druid.validationQuery", tempValidationQuery);
        }
        Boolean bl3 = tempUseGlobalDataSourceStat = this.useGlobalDataSourceStat == null ? globalConfig.getUseGlobalDataSourceStat() : this.useGlobalDataSourceStat;
        if (tempUseGlobalDataSourceStat != null && tempUseGlobalDataSourceStat.equals(Boolean.TRUE)) {
            properties.setProperty("druid.useGlobalDataSourceStat", "true");
        }
        Boolean bl4 = tempAsyncInit = this.asyncInit == null ? globalConfig.getAsyncInit() : this.asyncInit;
        if (tempAsyncInit != null && tempAsyncInit.equals(Boolean.TRUE)) {
            properties.setProperty("druid.asyncInit", "true");
        }
        String string2 = tempFilters = this.filters == null ? globalConfig.getFilters() : this.filters;
        if (tempFilters == null) {
            tempFilters = "stat,wall";
        }
        if (this.publicKey != null && this.publicKey.length() > 0 && !tempFilters.contains("config")) {
            tempFilters = tempFilters + ",config";
        }
        properties.setProperty("druid.filters", tempFilters);
        Boolean bl5 = tempClearFiltersEnable = this.clearFiltersEnable == null ? globalConfig.getClearFiltersEnable() : this.clearFiltersEnable;
        if (tempClearFiltersEnable != null && tempClearFiltersEnable.equals(Boolean.FALSE)) {
            properties.setProperty("druid.clearFiltersEnable", "false");
        }
        Boolean bl6 = tempResetStatEnable = this.resetStatEnable == null ? globalConfig.getResetStatEnable() : this.resetStatEnable;
        if (tempResetStatEnable != null && tempResetStatEnable.equals(Boolean.FALSE)) {
            properties.setProperty("druid.resetStatEnable", "false");
        }
        Integer n5 = tempNotFullTimeoutRetryCount = this.notFullTimeoutRetryCount == null ? globalConfig.getNotFullTimeoutRetryCount() : this.notFullTimeoutRetryCount;
        if (tempNotFullTimeoutRetryCount != null && !tempNotFullTimeoutRetryCount.equals(0)) {
            properties.setProperty("druid.notFullTimeoutRetryCount", String.valueOf(tempNotFullTimeoutRetryCount));
        }
        Integer n6 = tempMaxWaitThreadCount = this.maxWaitThreadCount == null ? globalConfig.getMaxWaitThreadCount() : this.maxWaitThreadCount;
        if (tempMaxWaitThreadCount != null && !tempMaxWaitThreadCount.equals(-1)) {
            properties.setProperty("druid.maxWaitThreadCount", String.valueOf(tempMaxWaitThreadCount));
        }
        Boolean bl7 = tempFailFast = this.failFast == null ? globalConfig.getFailFast() : this.failFast;
        if (tempFailFast != null && tempFailFast.equals(Boolean.TRUE)) {
            properties.setProperty("druid.failFast", "true");
        }
        Integer n7 = tempPhyTimeoutMillis = this.phyTimeoutMillis == null ? globalConfig.getPhyTimeoutMillis() : this.phyTimeoutMillis;
        if (tempPhyTimeoutMillis != null && !tempPhyTimeoutMillis.equals(-1L)) {
            properties.setProperty("druid.phyTimeoutMillis", String.valueOf(tempPhyTimeoutMillis));
        }
        Boolean bl8 = tempKeepAlive = this.keepAlive == null ? globalConfig.getKeepAlive() : this.keepAlive;
        if (tempKeepAlive != null && tempKeepAlive.equals(Boolean.TRUE)) {
            properties.setProperty("druid.keepAlive", "true");
        }
        Boolean bl9 = tempPoolPreparedStatements = this.poolPreparedStatements == null ? globalConfig.getPoolPreparedStatements() : this.poolPreparedStatements;
        if (tempPoolPreparedStatements != null && tempPoolPreparedStatements.equals(Boolean.TRUE)) {
            properties.setProperty("druid.poolPreparedStatements", "true");
        }
        Boolean bl10 = tempInitVariants = this.initVariants == null ? globalConfig.getInitVariants() : this.initVariants;
        if (tempInitVariants != null && tempInitVariants.equals(Boolean.TRUE)) {
            properties.setProperty("druid.initVariants", "true");
        }
        Boolean bl11 = tempInitGlobalVariants = this.initGlobalVariants == null ? globalConfig.getInitGlobalVariants() : this.initGlobalVariants;
        if (tempInitGlobalVariants != null && tempInitGlobalVariants.equals(Boolean.TRUE)) {
            properties.setProperty("druid.initGlobalVariants", "true");
        }
        Boolean bl12 = tempUseUnfairLock = this.useUnfairLock == null ? globalConfig.getUseUnfairLock() : this.useUnfairLock;
        if (tempUseUnfairLock != null) {
            properties.setProperty("druid.useUnfairLock", String.valueOf(tempUseUnfairLock));
        }
        Boolean bl13 = tempKillWhenSocketReadTimeout = this.killWhenSocketReadTimeout == null ? globalConfig.getKillWhenSocketReadTimeout() : this.killWhenSocketReadTimeout;
        if (tempKillWhenSocketReadTimeout != null && tempKillWhenSocketReadTimeout.equals(Boolean.TRUE)) {
            properties.setProperty("druid.killWhenSocketReadTimeout", "true");
        }
        Properties properties2 = tempConnectProperties = this.connectionProperties == null ? globalConfig.getConnectionProperties() : this.connectionProperties;
        if (this.publicKey != null && this.publicKey.length() > 0) {
            if (tempConnectProperties == null) {
                tempConnectProperties = new Properties();
            }
            log.info("\u52a8\u6001\u6570\u636e\u6e90-\u68c0\u6d4b\u5230\u60a8\u914d\u7f6e\u4e86druid\u52a0\u5bc6,\u52a0\u5bc6\u6240\u9700\u8fde\u63a5\u53c2\u6570\u5df2\u4e3a\u60a8\u81ea\u52a8\u914d\u7f6e");
            tempConnectProperties.setProperty("config.decrypt", "true");
            tempConnectProperties.setProperty("config.decrypt.key", this.publicKey);
        }
        this.connectionProperties = tempConnectProperties;
        Integer n8 = tempMaxPoolPreparedStatementPerConnectionSize = this.maxPoolPreparedStatementPerConnectionSize == null ? globalConfig.getMaxPoolPreparedStatementPerConnectionSize() : this.maxPoolPreparedStatementPerConnectionSize;
        if (tempMaxPoolPreparedStatementPerConnectionSize != null && !tempMaxPoolPreparedStatementPerConnectionSize.equals(10)) {
            properties.setProperty("druid.maxPoolPreparedStatementPerConnectionSize", String.valueOf(tempMaxPoolPreparedStatementPerConnectionSize));
        }
        String string3 = tempInitConnectionSqls = this.initConnectionSqls == null ? globalConfig.getInitConnectionSqls() : this.initConnectionSqls;
        if (tempInitConnectionSqls != null && tempInitConnectionSqls.length() > 0) {
            properties.setProperty("druid.initConnectionSqls", tempInitConnectionSqls);
        }
        Boolean bl14 = tempLogSlowSql = this.stat.getLogSlowSql() == null ? globalConfig.stat.getLogSlowSql() : this.stat.getLogSlowSql();
        if (tempLogSlowSql != null && tempLogSlowSql.booleanValue()) {
            properties.setProperty("druid.stat.logSlowSql", "true");
        }
        Long l6 = tempSlowSqlMillis = this.stat.getSlowSqlMillis() == null ? globalConfig.stat.getSlowSqlMillis() : this.stat.getSlowSqlMillis();
        if (tempSlowSqlMillis != null) {
            properties.setProperty("druid.stat.slowSqlMillis", tempSlowSqlMillis.toString());
        }
        Boolean bl15 = tempMergeSql = this.stat.getMergeSql() == null ? globalConfig.stat.getMergeSql() : this.stat.getMergeSql();
        if (tempMergeSql != null && tempMergeSql.booleanValue()) {
            properties.setProperty("druid.stat.mergeSql", "true");
        }
        return properties;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Long getMaxWait() {
        return this.maxWait;
    }

    public Long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public Long getTimeBetweenLogStatsMillis() {
        return this.timeBetweenLogStatsMillis;
    }

    public Integer getStatSqlMaxSize() {
        return this.statSqlMaxSize;
    }

    public Long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public Long getMaxEvictableIdleTimeMillis() {
        return this.maxEvictableIdleTimeMillis;
    }

    public Boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public Boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public Boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Integer getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public Boolean getUseGlobalDataSourceStat() {
        return this.useGlobalDataSourceStat;
    }

    public Boolean getAsyncInit() {
        return this.asyncInit;
    }

    public String getFilters() {
        return this.filters;
    }

    public Boolean getClearFiltersEnable() {
        return this.clearFiltersEnable;
    }

    public Boolean getResetStatEnable() {
        return this.resetStatEnable;
    }

    public Integer getNotFullTimeoutRetryCount() {
        return this.notFullTimeoutRetryCount;
    }

    public Integer getMaxWaitThreadCount() {
        return this.maxWaitThreadCount;
    }

    public Boolean getFailFast() {
        return this.failFast;
    }

    public Integer getPhyTimeoutMillis() {
        return this.phyTimeoutMillis;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public Boolean getPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public Boolean getInitVariants() {
        return this.initVariants;
    }

    public Boolean getInitGlobalVariants() {
        return this.initGlobalVariants;
    }

    public Boolean getUseUnfairLock() {
        return this.useUnfairLock;
    }

    public Boolean getKillWhenSocketReadTimeout() {
        return this.killWhenSocketReadTimeout;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public Integer getMaxPoolPreparedStatementPerConnectionSize() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    public String getInitConnectionSqls() {
        return this.initConnectionSqls;
    }

    public Boolean getSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public Integer getConnectionErrorRetryAttempts() {
        return this.connectionErrorRetryAttempts;
    }

    public Boolean getBreakAfterAcquireFailure() {
        return this.breakAfterAcquireFailure;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public DruidWallConfig getWall() {
        return this.wall;
    }

    public DruidStatConfig getStat() {
        return this.stat;
    }

    public DruidConfig setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
        return this;
    }

    public DruidConfig setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    public DruidConfig setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public DruidConfig setMaxWait(Long maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    public DruidConfig setTimeBetweenEvictionRunsMillis(Long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        return this;
    }

    public DruidConfig setTimeBetweenLogStatsMillis(Long timeBetweenLogStatsMillis) {
        this.timeBetweenLogStatsMillis = timeBetweenLogStatsMillis;
        return this;
    }

    public DruidConfig setStatSqlMaxSize(Integer statSqlMaxSize) {
        this.statSqlMaxSize = statSqlMaxSize;
        return this;
    }

    public DruidConfig setMinEvictableIdleTimeMillis(Long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        return this;
    }

    public DruidConfig setMaxEvictableIdleTimeMillis(Long maxEvictableIdleTimeMillis) {
        this.maxEvictableIdleTimeMillis = maxEvictableIdleTimeMillis;
        return this;
    }

    public DruidConfig setTestWhileIdle(Boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public DruidConfig setTestOnBorrow(Boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public DruidConfig setTestOnReturn(Boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public DruidConfig setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
        return this;
    }

    public DruidConfig setValidationQueryTimeout(Integer validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
        return this;
    }

    public DruidConfig setUseGlobalDataSourceStat(Boolean useGlobalDataSourceStat) {
        this.useGlobalDataSourceStat = useGlobalDataSourceStat;
        return this;
    }

    public DruidConfig setAsyncInit(Boolean asyncInit) {
        this.asyncInit = asyncInit;
        return this;
    }

    public DruidConfig setFilters(String filters) {
        this.filters = filters;
        return this;
    }

    public DruidConfig setClearFiltersEnable(Boolean clearFiltersEnable) {
        this.clearFiltersEnable = clearFiltersEnable;
        return this;
    }

    public DruidConfig setResetStatEnable(Boolean resetStatEnable) {
        this.resetStatEnable = resetStatEnable;
        return this;
    }

    public DruidConfig setNotFullTimeoutRetryCount(Integer notFullTimeoutRetryCount) {
        this.notFullTimeoutRetryCount = notFullTimeoutRetryCount;
        return this;
    }

    public DruidConfig setMaxWaitThreadCount(Integer maxWaitThreadCount) {
        this.maxWaitThreadCount = maxWaitThreadCount;
        return this;
    }

    public DruidConfig setFailFast(Boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public DruidConfig setPhyTimeoutMillis(Integer phyTimeoutMillis) {
        this.phyTimeoutMillis = phyTimeoutMillis;
        return this;
    }

    public DruidConfig setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public DruidConfig setPoolPreparedStatements(Boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
        return this;
    }

    public DruidConfig setInitVariants(Boolean initVariants) {
        this.initVariants = initVariants;
        return this;
    }

    public DruidConfig setInitGlobalVariants(Boolean initGlobalVariants) {
        this.initGlobalVariants = initGlobalVariants;
        return this;
    }

    public DruidConfig setUseUnfairLock(Boolean useUnfairLock) {
        this.useUnfairLock = useUnfairLock;
        return this;
    }

    public DruidConfig setKillWhenSocketReadTimeout(Boolean killWhenSocketReadTimeout) {
        this.killWhenSocketReadTimeout = killWhenSocketReadTimeout;
        return this;
    }

    public DruidConfig setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public DruidConfig setMaxPoolPreparedStatementPerConnectionSize(Integer maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
        return this;
    }

    public DruidConfig setInitConnectionSqls(String initConnectionSqls) {
        this.initConnectionSqls = initConnectionSqls;
        return this;
    }

    public DruidConfig setSharePreparedStatements(Boolean sharePreparedStatements) {
        this.sharePreparedStatements = sharePreparedStatements;
        return this;
    }

    public DruidConfig setConnectionErrorRetryAttempts(Integer connectionErrorRetryAttempts) {
        this.connectionErrorRetryAttempts = connectionErrorRetryAttempts;
        return this;
    }

    public DruidConfig setBreakAfterAcquireFailure(Boolean breakAfterAcquireFailure) {
        this.breakAfterAcquireFailure = breakAfterAcquireFailure;
        return this;
    }

    public DruidConfig setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public DruidConfig setWall(DruidWallConfig wall) {
        this.wall = wall;
        return this;
    }

    public DruidConfig setStat(DruidStatConfig stat) {
        this.stat = stat;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidConfig)) {
            return false;
        }
        DruidConfig other = (DruidConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$initialSize = this.getInitialSize();
        Integer other$initialSize = other.getInitialSize();
        if (this$initialSize == null ? other$initialSize != null : !((Object)this$initialSize).equals(other$initialSize)) {
            return false;
        }
        Integer this$maxActive = this.getMaxActive();
        Integer other$maxActive = other.getMaxActive();
        if (this$maxActive == null ? other$maxActive != null : !((Object)this$maxActive).equals(other$maxActive)) {
            return false;
        }
        Integer this$minIdle = this.getMinIdle();
        Integer other$minIdle = other.getMinIdle();
        if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
            return false;
        }
        Long this$maxWait = this.getMaxWait();
        Long other$maxWait = other.getMaxWait();
        if (this$maxWait == null ? other$maxWait != null : !((Object)this$maxWait).equals(other$maxWait)) {
            return false;
        }
        Long this$timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        Long other$timeBetweenEvictionRunsMillis = other.getTimeBetweenEvictionRunsMillis();
        if (this$timeBetweenEvictionRunsMillis == null ? other$timeBetweenEvictionRunsMillis != null : !((Object)this$timeBetweenEvictionRunsMillis).equals(other$timeBetweenEvictionRunsMillis)) {
            return false;
        }
        Long this$timeBetweenLogStatsMillis = this.getTimeBetweenLogStatsMillis();
        Long other$timeBetweenLogStatsMillis = other.getTimeBetweenLogStatsMillis();
        if (this$timeBetweenLogStatsMillis == null ? other$timeBetweenLogStatsMillis != null : !((Object)this$timeBetweenLogStatsMillis).equals(other$timeBetweenLogStatsMillis)) {
            return false;
        }
        Integer this$statSqlMaxSize = this.getStatSqlMaxSize();
        Integer other$statSqlMaxSize = other.getStatSqlMaxSize();
        if (this$statSqlMaxSize == null ? other$statSqlMaxSize != null : !((Object)this$statSqlMaxSize).equals(other$statSqlMaxSize)) {
            return false;
        }
        Long this$minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        Long other$minEvictableIdleTimeMillis = other.getMinEvictableIdleTimeMillis();
        if (this$minEvictableIdleTimeMillis == null ? other$minEvictableIdleTimeMillis != null : !((Object)this$minEvictableIdleTimeMillis).equals(other$minEvictableIdleTimeMillis)) {
            return false;
        }
        Long this$maxEvictableIdleTimeMillis = this.getMaxEvictableIdleTimeMillis();
        Long other$maxEvictableIdleTimeMillis = other.getMaxEvictableIdleTimeMillis();
        if (this$maxEvictableIdleTimeMillis == null ? other$maxEvictableIdleTimeMillis != null : !((Object)this$maxEvictableIdleTimeMillis).equals(other$maxEvictableIdleTimeMillis)) {
            return false;
        }
        Boolean this$testWhileIdle = this.getTestWhileIdle();
        Boolean other$testWhileIdle = other.getTestWhileIdle();
        if (this$testWhileIdle == null ? other$testWhileIdle != null : !((Object)this$testWhileIdle).equals(other$testWhileIdle)) {
            return false;
        }
        Boolean this$testOnBorrow = this.getTestOnBorrow();
        Boolean other$testOnBorrow = other.getTestOnBorrow();
        if (this$testOnBorrow == null ? other$testOnBorrow != null : !((Object)this$testOnBorrow).equals(other$testOnBorrow)) {
            return false;
        }
        Boolean this$testOnReturn = this.getTestOnReturn();
        Boolean other$testOnReturn = other.getTestOnReturn();
        if (this$testOnReturn == null ? other$testOnReturn != null : !((Object)this$testOnReturn).equals(other$testOnReturn)) {
            return false;
        }
        String this$validationQuery = this.getValidationQuery();
        String other$validationQuery = other.getValidationQuery();
        if (this$validationQuery == null ? other$validationQuery != null : !this$validationQuery.equals(other$validationQuery)) {
            return false;
        }
        Integer this$validationQueryTimeout = this.getValidationQueryTimeout();
        Integer other$validationQueryTimeout = other.getValidationQueryTimeout();
        if (this$validationQueryTimeout == null ? other$validationQueryTimeout != null : !((Object)this$validationQueryTimeout).equals(other$validationQueryTimeout)) {
            return false;
        }
        Boolean this$useGlobalDataSourceStat = this.getUseGlobalDataSourceStat();
        Boolean other$useGlobalDataSourceStat = other.getUseGlobalDataSourceStat();
        if (this$useGlobalDataSourceStat == null ? other$useGlobalDataSourceStat != null : !((Object)this$useGlobalDataSourceStat).equals(other$useGlobalDataSourceStat)) {
            return false;
        }
        Boolean this$asyncInit = this.getAsyncInit();
        Boolean other$asyncInit = other.getAsyncInit();
        if (this$asyncInit == null ? other$asyncInit != null : !((Object)this$asyncInit).equals(other$asyncInit)) {
            return false;
        }
        String this$filters = this.getFilters();
        String other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) {
            return false;
        }
        Boolean this$clearFiltersEnable = this.getClearFiltersEnable();
        Boolean other$clearFiltersEnable = other.getClearFiltersEnable();
        if (this$clearFiltersEnable == null ? other$clearFiltersEnable != null : !((Object)this$clearFiltersEnable).equals(other$clearFiltersEnable)) {
            return false;
        }
        Boolean this$resetStatEnable = this.getResetStatEnable();
        Boolean other$resetStatEnable = other.getResetStatEnable();
        if (this$resetStatEnable == null ? other$resetStatEnable != null : !((Object)this$resetStatEnable).equals(other$resetStatEnable)) {
            return false;
        }
        Integer this$notFullTimeoutRetryCount = this.getNotFullTimeoutRetryCount();
        Integer other$notFullTimeoutRetryCount = other.getNotFullTimeoutRetryCount();
        if (this$notFullTimeoutRetryCount == null ? other$notFullTimeoutRetryCount != null : !((Object)this$notFullTimeoutRetryCount).equals(other$notFullTimeoutRetryCount)) {
            return false;
        }
        Integer this$maxWaitThreadCount = this.getMaxWaitThreadCount();
        Integer other$maxWaitThreadCount = other.getMaxWaitThreadCount();
        if (this$maxWaitThreadCount == null ? other$maxWaitThreadCount != null : !((Object)this$maxWaitThreadCount).equals(other$maxWaitThreadCount)) {
            return false;
        }
        Boolean this$failFast = this.getFailFast();
        Boolean other$failFast = other.getFailFast();
        if (this$failFast == null ? other$failFast != null : !((Object)this$failFast).equals(other$failFast)) {
            return false;
        }
        Integer this$phyTimeoutMillis = this.getPhyTimeoutMillis();
        Integer other$phyTimeoutMillis = other.getPhyTimeoutMillis();
        if (this$phyTimeoutMillis == null ? other$phyTimeoutMillis != null : !((Object)this$phyTimeoutMillis).equals(other$phyTimeoutMillis)) {
            return false;
        }
        Boolean this$keepAlive = this.getKeepAlive();
        Boolean other$keepAlive = other.getKeepAlive();
        if (this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive)) {
            return false;
        }
        Boolean this$poolPreparedStatements = this.getPoolPreparedStatements();
        Boolean other$poolPreparedStatements = other.getPoolPreparedStatements();
        if (this$poolPreparedStatements == null ? other$poolPreparedStatements != null : !((Object)this$poolPreparedStatements).equals(other$poolPreparedStatements)) {
            return false;
        }
        Boolean this$initVariants = this.getInitVariants();
        Boolean other$initVariants = other.getInitVariants();
        if (this$initVariants == null ? other$initVariants != null : !((Object)this$initVariants).equals(other$initVariants)) {
            return false;
        }
        Boolean this$initGlobalVariants = this.getInitGlobalVariants();
        Boolean other$initGlobalVariants = other.getInitGlobalVariants();
        if (this$initGlobalVariants == null ? other$initGlobalVariants != null : !((Object)this$initGlobalVariants).equals(other$initGlobalVariants)) {
            return false;
        }
        Boolean this$useUnfairLock = this.getUseUnfairLock();
        Boolean other$useUnfairLock = other.getUseUnfairLock();
        if (this$useUnfairLock == null ? other$useUnfairLock != null : !((Object)this$useUnfairLock).equals(other$useUnfairLock)) {
            return false;
        }
        Boolean this$killWhenSocketReadTimeout = this.getKillWhenSocketReadTimeout();
        Boolean other$killWhenSocketReadTimeout = other.getKillWhenSocketReadTimeout();
        if (this$killWhenSocketReadTimeout == null ? other$killWhenSocketReadTimeout != null : !((Object)this$killWhenSocketReadTimeout).equals(other$killWhenSocketReadTimeout)) {
            return false;
        }
        Properties this$connectionProperties = this.getConnectionProperties();
        Properties other$connectionProperties = other.getConnectionProperties();
        if (this$connectionProperties == null ? other$connectionProperties != null : !((Object)this$connectionProperties).equals(other$connectionProperties)) {
            return false;
        }
        Integer this$maxPoolPreparedStatementPerConnectionSize = this.getMaxPoolPreparedStatementPerConnectionSize();
        Integer other$maxPoolPreparedStatementPerConnectionSize = other.getMaxPoolPreparedStatementPerConnectionSize();
        if (this$maxPoolPreparedStatementPerConnectionSize == null ? other$maxPoolPreparedStatementPerConnectionSize != null : !((Object)this$maxPoolPreparedStatementPerConnectionSize).equals(other$maxPoolPreparedStatementPerConnectionSize)) {
            return false;
        }
        String this$initConnectionSqls = this.getInitConnectionSqls();
        String other$initConnectionSqls = other.getInitConnectionSqls();
        if (this$initConnectionSqls == null ? other$initConnectionSqls != null : !this$initConnectionSqls.equals(other$initConnectionSqls)) {
            return false;
        }
        Boolean this$sharePreparedStatements = this.getSharePreparedStatements();
        Boolean other$sharePreparedStatements = other.getSharePreparedStatements();
        if (this$sharePreparedStatements == null ? other$sharePreparedStatements != null : !((Object)this$sharePreparedStatements).equals(other$sharePreparedStatements)) {
            return false;
        }
        Integer this$connectionErrorRetryAttempts = this.getConnectionErrorRetryAttempts();
        Integer other$connectionErrorRetryAttempts = other.getConnectionErrorRetryAttempts();
        if (this$connectionErrorRetryAttempts == null ? other$connectionErrorRetryAttempts != null : !((Object)this$connectionErrorRetryAttempts).equals(other$connectionErrorRetryAttempts)) {
            return false;
        }
        Boolean this$breakAfterAcquireFailure = this.getBreakAfterAcquireFailure();
        Boolean other$breakAfterAcquireFailure = other.getBreakAfterAcquireFailure();
        if (this$breakAfterAcquireFailure == null ? other$breakAfterAcquireFailure != null : !((Object)this$breakAfterAcquireFailure).equals(other$breakAfterAcquireFailure)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        DruidWallConfig this$wall = this.getWall();
        DruidWallConfig other$wall = other.getWall();
        if (this$wall == null ? other$wall != null : !((Object)this$wall).equals(other$wall)) {
            return false;
        }
        DruidStatConfig this$stat = this.getStat();
        DruidStatConfig other$stat = other.getStat();
        return !(this$stat == null ? other$stat != null : !((Object)this$stat).equals(other$stat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DruidConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $initialSize = this.getInitialSize();
        result = result * 59 + ($initialSize == null ? 43 : ((Object)$initialSize).hashCode());
        Integer $maxActive = this.getMaxActive();
        result = result * 59 + ($maxActive == null ? 43 : ((Object)$maxActive).hashCode());
        Integer $minIdle = this.getMinIdle();
        result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
        Long $maxWait = this.getMaxWait();
        result = result * 59 + ($maxWait == null ? 43 : ((Object)$maxWait).hashCode());
        Long $timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        result = result * 59 + ($timeBetweenEvictionRunsMillis == null ? 43 : ((Object)$timeBetweenEvictionRunsMillis).hashCode());
        Long $timeBetweenLogStatsMillis = this.getTimeBetweenLogStatsMillis();
        result = result * 59 + ($timeBetweenLogStatsMillis == null ? 43 : ((Object)$timeBetweenLogStatsMillis).hashCode());
        Integer $statSqlMaxSize = this.getStatSqlMaxSize();
        result = result * 59 + ($statSqlMaxSize == null ? 43 : ((Object)$statSqlMaxSize).hashCode());
        Long $minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        result = result * 59 + ($minEvictableIdleTimeMillis == null ? 43 : ((Object)$minEvictableIdleTimeMillis).hashCode());
        Long $maxEvictableIdleTimeMillis = this.getMaxEvictableIdleTimeMillis();
        result = result * 59 + ($maxEvictableIdleTimeMillis == null ? 43 : ((Object)$maxEvictableIdleTimeMillis).hashCode());
        Boolean $testWhileIdle = this.getTestWhileIdle();
        result = result * 59 + ($testWhileIdle == null ? 43 : ((Object)$testWhileIdle).hashCode());
        Boolean $testOnBorrow = this.getTestOnBorrow();
        result = result * 59 + ($testOnBorrow == null ? 43 : ((Object)$testOnBorrow).hashCode());
        Boolean $testOnReturn = this.getTestOnReturn();
        result = result * 59 + ($testOnReturn == null ? 43 : ((Object)$testOnReturn).hashCode());
        String $validationQuery = this.getValidationQuery();
        result = result * 59 + ($validationQuery == null ? 43 : $validationQuery.hashCode());
        Integer $validationQueryTimeout = this.getValidationQueryTimeout();
        result = result * 59 + ($validationQueryTimeout == null ? 43 : ((Object)$validationQueryTimeout).hashCode());
        Boolean $useGlobalDataSourceStat = this.getUseGlobalDataSourceStat();
        result = result * 59 + ($useGlobalDataSourceStat == null ? 43 : ((Object)$useGlobalDataSourceStat).hashCode());
        Boolean $asyncInit = this.getAsyncInit();
        result = result * 59 + ($asyncInit == null ? 43 : ((Object)$asyncInit).hashCode());
        String $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : $filters.hashCode());
        Boolean $clearFiltersEnable = this.getClearFiltersEnable();
        result = result * 59 + ($clearFiltersEnable == null ? 43 : ((Object)$clearFiltersEnable).hashCode());
        Boolean $resetStatEnable = this.getResetStatEnable();
        result = result * 59 + ($resetStatEnable == null ? 43 : ((Object)$resetStatEnable).hashCode());
        Integer $notFullTimeoutRetryCount = this.getNotFullTimeoutRetryCount();
        result = result * 59 + ($notFullTimeoutRetryCount == null ? 43 : ((Object)$notFullTimeoutRetryCount).hashCode());
        Integer $maxWaitThreadCount = this.getMaxWaitThreadCount();
        result = result * 59 + ($maxWaitThreadCount == null ? 43 : ((Object)$maxWaitThreadCount).hashCode());
        Boolean $failFast = this.getFailFast();
        result = result * 59 + ($failFast == null ? 43 : ((Object)$failFast).hashCode());
        Integer $phyTimeoutMillis = this.getPhyTimeoutMillis();
        result = result * 59 + ($phyTimeoutMillis == null ? 43 : ((Object)$phyTimeoutMillis).hashCode());
        Boolean $keepAlive = this.getKeepAlive();
        result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
        Boolean $poolPreparedStatements = this.getPoolPreparedStatements();
        result = result * 59 + ($poolPreparedStatements == null ? 43 : ((Object)$poolPreparedStatements).hashCode());
        Boolean $initVariants = this.getInitVariants();
        result = result * 59 + ($initVariants == null ? 43 : ((Object)$initVariants).hashCode());
        Boolean $initGlobalVariants = this.getInitGlobalVariants();
        result = result * 59 + ($initGlobalVariants == null ? 43 : ((Object)$initGlobalVariants).hashCode());
        Boolean $useUnfairLock = this.getUseUnfairLock();
        result = result * 59 + ($useUnfairLock == null ? 43 : ((Object)$useUnfairLock).hashCode());
        Boolean $killWhenSocketReadTimeout = this.getKillWhenSocketReadTimeout();
        result = result * 59 + ($killWhenSocketReadTimeout == null ? 43 : ((Object)$killWhenSocketReadTimeout).hashCode());
        Properties $connectionProperties = this.getConnectionProperties();
        result = result * 59 + ($connectionProperties == null ? 43 : ((Object)$connectionProperties).hashCode());
        Integer $maxPoolPreparedStatementPerConnectionSize = this.getMaxPoolPreparedStatementPerConnectionSize();
        result = result * 59 + ($maxPoolPreparedStatementPerConnectionSize == null ? 43 : ((Object)$maxPoolPreparedStatementPerConnectionSize).hashCode());
        String $initConnectionSqls = this.getInitConnectionSqls();
        result = result * 59 + ($initConnectionSqls == null ? 43 : $initConnectionSqls.hashCode());
        Boolean $sharePreparedStatements = this.getSharePreparedStatements();
        result = result * 59 + ($sharePreparedStatements == null ? 43 : ((Object)$sharePreparedStatements).hashCode());
        Integer $connectionErrorRetryAttempts = this.getConnectionErrorRetryAttempts();
        result = result * 59 + ($connectionErrorRetryAttempts == null ? 43 : ((Object)$connectionErrorRetryAttempts).hashCode());
        Boolean $breakAfterAcquireFailure = this.getBreakAfterAcquireFailure();
        result = result * 59 + ($breakAfterAcquireFailure == null ? 43 : ((Object)$breakAfterAcquireFailure).hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        DruidWallConfig $wall = this.getWall();
        result = result * 59 + ($wall == null ? 43 : ((Object)$wall).hashCode());
        DruidStatConfig $stat = this.getStat();
        result = result * 59 + ($stat == null ? 43 : ((Object)$stat).hashCode());
        return result;
    }

    public String toString() {
        return "DruidConfig(initialSize=" + this.getInitialSize() + ", maxActive=" + this.getMaxActive() + ", minIdle=" + this.getMinIdle() + ", maxWait=" + this.getMaxWait() + ", timeBetweenEvictionRunsMillis=" + this.getTimeBetweenEvictionRunsMillis() + ", timeBetweenLogStatsMillis=" + this.getTimeBetweenLogStatsMillis() + ", statSqlMaxSize=" + this.getStatSqlMaxSize() + ", minEvictableIdleTimeMillis=" + this.getMinEvictableIdleTimeMillis() + ", maxEvictableIdleTimeMillis=" + this.getMaxEvictableIdleTimeMillis() + ", testWhileIdle=" + this.getTestWhileIdle() + ", testOnBorrow=" + this.getTestOnBorrow() + ", testOnReturn=" + this.getTestOnReturn() + ", validationQuery=" + this.getValidationQuery() + ", validationQueryTimeout=" + this.getValidationQueryTimeout() + ", useGlobalDataSourceStat=" + this.getUseGlobalDataSourceStat() + ", asyncInit=" + this.getAsyncInit() + ", filters=" + this.getFilters() + ", clearFiltersEnable=" + this.getClearFiltersEnable() + ", resetStatEnable=" + this.getResetStatEnable() + ", notFullTimeoutRetryCount=" + this.getNotFullTimeoutRetryCount() + ", maxWaitThreadCount=" + this.getMaxWaitThreadCount() + ", failFast=" + this.getFailFast() + ", phyTimeoutMillis=" + this.getPhyTimeoutMillis() + ", keepAlive=" + this.getKeepAlive() + ", poolPreparedStatements=" + this.getPoolPreparedStatements() + ", initVariants=" + this.getInitVariants() + ", initGlobalVariants=" + this.getInitGlobalVariants() + ", useUnfairLock=" + this.getUseUnfairLock() + ", killWhenSocketReadTimeout=" + this.getKillWhenSocketReadTimeout() + ", connectionProperties=" + this.getConnectionProperties() + ", maxPoolPreparedStatementPerConnectionSize=" + this.getMaxPoolPreparedStatementPerConnectionSize() + ", initConnectionSqls=" + this.getInitConnectionSqls() + ", sharePreparedStatements=" + this.getSharePreparedStatements() + ", connectionErrorRetryAttempts=" + this.getConnectionErrorRetryAttempts() + ", breakAfterAcquireFailure=" + this.getBreakAfterAcquireFailure() + ", publicKey=" + this.getPublicKey() + ", wall=" + this.getWall() + ", stat=" + this.getStat() + ")";
    }

    public static class DruidWallConfig {
        private Boolean noneBaseStatementAllow;
        private Boolean callAllow;
        private Boolean selectAllow;
        private Boolean selectIntoAllow;
        private Boolean selectIntoOutfileAllow;
        private Boolean selectWhereAlwayTrueCheck;
        private Boolean selectHavingAlwayTrueCheck;
        private Boolean selectUnionCheck;
        private Boolean selectMinusCheck;
        private Boolean selectExceptCheck;
        private Boolean selectIntersectCheck;
        private Boolean createTableAllow;
        private Boolean dropTableAllow;
        private Boolean alterTableAllow;
        private Boolean renameTableAllow;
        private Boolean hintAllow;
        private Boolean lockTableAllow;
        private Boolean startTransactionAllow;
        private Boolean blockAllow;
        private Boolean conditionAndAlwayTrueAllow;
        private Boolean conditionAndAlwayFalseAllow;
        private Boolean conditionDoubleConstAllow;
        private Boolean conditionLikeTrueAllow;
        private Boolean selectAllColumnAllow;
        private Boolean deleteAllow;
        private Boolean deleteWhereAlwayTrueCheck;
        private Boolean deleteWhereNoneCheck;
        private Boolean updateAllow;
        private Boolean updateWhereAlayTrueCheck;
        private Boolean updateWhereNoneCheck;
        private Boolean insertAllow;
        private Boolean mergeAllow;
        private Boolean minusAllow;
        private Boolean intersectAllow;
        private Boolean replaceAllow;
        private Boolean setAllow;
        private Boolean commitAllow;
        private Boolean rollbackAllow;
        private Boolean useAllow;
        private Boolean multiStatementAllow;
        private Boolean truncateAllow;
        private Boolean commentAllow;
        private Boolean strictSyntaxCheck;
        private Boolean constArithmeticAllow;
        private Boolean limitZeroAllow;
        private Boolean describeAllow;
        private Boolean showAllow;
        private Boolean schemaCheck;
        private Boolean tableCheck;
        private Boolean functionCheck;
        private Boolean objectCheck;
        private Boolean variantCheck;
        private Boolean mustParameterized;
        private Boolean doPrivilegedAllow;
        private String dir;
        private String tenantTablePattern;
        private String tenantColumn;
        private Boolean wrapAllow;
        private Boolean metadataAllow;
        private Boolean conditionOpXorAllow;
        private Boolean conditionOpBitwseAllow;
        private Boolean caseConditionConstAllow;
        private Boolean completeInsertValuesCheck;
        private Integer insertValuesCheckSize;
        private Integer selectLimit;

        public WallConfig toWallConfig(DruidWallConfig config) {
            Boolean tempCompleteInsertValuesCheck;
            Boolean tempCaseConditionConstAllow;
            Boolean tempConditionOpBitwseAllow;
            Boolean tempConditionOpXorAllow;
            Boolean tempMetadataAllow;
            Boolean tempWrapAllow;
            Boolean tempDoPrivilegedAllow;
            Boolean tempMustParameterized;
            Boolean tempVariantCheck;
            Boolean tempObjectCheck;
            Boolean tempFunctionCheck;
            Boolean tempTableCheck;
            Boolean tempSchemaCheck;
            Boolean tempShowAllow;
            Boolean tempDescribeAllow;
            Boolean tempLimitZeroAllow;
            Boolean tempConstArithmeticAllow;
            Boolean tempStrictSyntaxCheck;
            Boolean tempCommentAllow;
            Boolean tempTruncateAllow;
            Boolean tempMultiStatementAllow;
            Boolean tempUseAllow;
            Boolean tempRollbackAllow;
            Boolean tempCommitAllow;
            Boolean tempSetAllow;
            Boolean tempReplaceAllow;
            Boolean tempIntersectAllow;
            Boolean tempMinusAllow;
            Boolean tempMergeAllow;
            Boolean tempInsertAllow;
            Boolean tempUpdateWhereNoneCheck;
            Boolean tempUpdateWhereAlayTrueCheck;
            Boolean tempUpdateAllow;
            Boolean tempDeleteWhereNoneCheck;
            Boolean tempDeleteWhereAlwayTrueCheck;
            Boolean tempDeleteAllow;
            Boolean tempSelectAllColumnAllow;
            Boolean tempConditionLikeTrueAllow;
            Boolean tempConditionDoubleConstAllow;
            Boolean tempConditionAndAlwayFalseAllow;
            Boolean tempConditionAndAlwayTrueAllow;
            Boolean tempBlockAllow;
            Boolean tempStartTransactionAllow;
            Boolean tempLockTableAllow;
            Boolean tempHintAllow;
            Boolean tempRenameTableAllow;
            Boolean tempAlterTableAllow;
            Boolean tempDropTableAllow;
            Boolean tempCreateTableAllow;
            Boolean tempSelectIntersectCheck;
            Boolean tempSelectExceptCheck;
            Boolean tempSelectMinusCheck;
            Boolean tempSelectUnionCheck;
            Boolean tempSelectHavingAlwayTrueCheck;
            Boolean tempSelectWhereAlwayTrueCheck;
            Boolean tempSelectIntoOutfileAllow;
            Boolean tempSelectIntoAllow;
            Boolean tempSelectAllow;
            Boolean tempCallAllow;
            Integer tempSelectLimit;
            Integer tempInsertValuesCheckSize;
            Boolean tempNoneBaseStatementAllow;
            String tempTenantColumn;
            String tempTenantTablePattern;
            String tempDir;
            WallConfig wallConfig = new WallConfig();
            String string = tempDir = StringUtils.isEmpty((String)this.dir) ? config.getDir() : this.dir;
            if (!StringUtils.isEmpty((String)tempDir)) {
                wallConfig.loadConfig(tempDir);
            }
            String string2 = tempTenantTablePattern = StringUtils.isEmpty((String)this.tenantTablePattern) ? config.getTenantTablePattern() : this.tenantTablePattern;
            if (!StringUtils.isEmpty((String)tempTenantTablePattern)) {
                wallConfig.setTenantTablePattern(tempTenantTablePattern);
            }
            String string3 = tempTenantColumn = StringUtils.isEmpty((String)this.tenantColumn) ? config.getTenantColumn() : this.tenantColumn;
            if (!StringUtils.isEmpty((String)tempTenantColumn)) {
                wallConfig.setTenantTablePattern(tempTenantColumn);
            }
            Boolean bl = tempNoneBaseStatementAllow = this.noneBaseStatementAllow == null ? config.getNoneBaseStatementAllow() : this.noneBaseStatementAllow;
            if (tempNoneBaseStatementAllow != null && tempNoneBaseStatementAllow.booleanValue()) {
                wallConfig.setNoneBaseStatementAllow(true);
            }
            Integer n = tempInsertValuesCheckSize = this.insertValuesCheckSize == null ? config.getInsertValuesCheckSize() : this.insertValuesCheckSize;
            if (tempInsertValuesCheckSize != null) {
                wallConfig.setInsertValuesCheckSize(tempInsertValuesCheckSize.intValue());
            }
            Integer n2 = tempSelectLimit = this.selectLimit == null ? config.getSelectLimit() : this.selectLimit;
            if (tempSelectLimit != null) {
                config.setSelectLimit(tempSelectLimit);
            }
            Boolean bl2 = tempCallAllow = this.callAllow == null ? config.getCallAllow() : this.callAllow;
            if (tempCallAllow != null && !tempCallAllow.booleanValue()) {
                wallConfig.setCallAllow(false);
            }
            Boolean bl3 = tempSelectAllow = this.selectAllow == null ? config.getSelectAllow() : this.selectAllow;
            if (tempSelectAllow != null && !tempSelectAllow.booleanValue()) {
                wallConfig.setSelelctAllow(false);
            }
            Boolean bl4 = tempSelectIntoAllow = this.selectIntoAllow == null ? config.getSelectIntoAllow() : this.selectIntoAllow;
            if (tempSelectIntoAllow != null && !tempSelectIntoAllow.booleanValue()) {
                wallConfig.setSelectIntoAllow(false);
            }
            Boolean bl5 = tempSelectIntoOutfileAllow = this.selectIntoOutfileAllow == null ? config.getSelectIntoOutfileAllow() : this.selectIntoOutfileAllow;
            if (tempSelectIntoOutfileAllow != null && tempSelectIntoOutfileAllow.booleanValue()) {
                wallConfig.setSelectIntoOutfileAllow(true);
            }
            Boolean bl6 = tempSelectWhereAlwayTrueCheck = this.selectWhereAlwayTrueCheck == null ? config.getSelectWhereAlwayTrueCheck() : this.selectWhereAlwayTrueCheck;
            if (tempSelectWhereAlwayTrueCheck != null && !tempSelectWhereAlwayTrueCheck.booleanValue()) {
                wallConfig.setSelectWhereAlwayTrueCheck(false);
            }
            Boolean bl7 = tempSelectHavingAlwayTrueCheck = this.selectHavingAlwayTrueCheck == null ? config.getSelectHavingAlwayTrueCheck() : this.selectHavingAlwayTrueCheck;
            if (tempSelectHavingAlwayTrueCheck != null && !tempSelectHavingAlwayTrueCheck.booleanValue()) {
                wallConfig.setSelectHavingAlwayTrueCheck(false);
            }
            Boolean bl8 = tempSelectUnionCheck = this.selectUnionCheck == null ? config.getSelectUnionCheck() : this.selectUnionCheck;
            if (tempSelectUnionCheck != null && !tempSelectUnionCheck.booleanValue()) {
                wallConfig.setSelectUnionCheck(false);
            }
            Boolean bl9 = tempSelectMinusCheck = this.selectMinusCheck == null ? config.getSelectMinusCheck() : this.selectMinusCheck;
            if (tempSelectMinusCheck != null && !tempSelectMinusCheck.booleanValue()) {
                wallConfig.setSelectMinusCheck(false);
            }
            Boolean bl10 = tempSelectExceptCheck = this.selectExceptCheck == null ? config.getSelectExceptCheck() : this.selectExceptCheck;
            if (tempSelectExceptCheck != null && !tempSelectExceptCheck.booleanValue()) {
                wallConfig.setSelectExceptCheck(false);
            }
            Boolean bl11 = tempSelectIntersectCheck = this.selectIntersectCheck == null ? config.getSelectIntersectCheck() : this.selectIntersectCheck;
            if (tempSelectIntersectCheck != null && !tempSelectIntersectCheck.booleanValue()) {
                wallConfig.setSelectIntersectCheck(false);
            }
            Boolean bl12 = tempCreateTableAllow = this.createTableAllow == null ? config.getCreateTableAllow() : this.createTableAllow;
            if (tempCreateTableAllow != null && !tempCreateTableAllow.booleanValue()) {
                wallConfig.setCreateTableAllow(false);
            }
            Boolean bl13 = tempDropTableAllow = this.dropTableAllow == null ? config.getDropTableAllow() : this.dropTableAllow;
            if (tempDropTableAllow != null && !tempDropTableAllow.booleanValue()) {
                wallConfig.setDropTableAllow(false);
            }
            Boolean bl14 = tempAlterTableAllow = this.alterTableAllow == null ? config.getAlterTableAllow() : this.alterTableAllow;
            if (tempAlterTableAllow != null && !tempAlterTableAllow.booleanValue()) {
                wallConfig.setAlterTableAllow(false);
            }
            Boolean bl15 = tempRenameTableAllow = this.renameTableAllow == null ? config.getRenameTableAllow() : this.renameTableAllow;
            if (tempRenameTableAllow != null && !tempRenameTableAllow.booleanValue()) {
                wallConfig.setRenameTableAllow(false);
            }
            Boolean bl16 = tempHintAllow = this.hintAllow == null ? config.getHintAllow() : this.hintAllow;
            if (tempHintAllow != null && !tempHintAllow.booleanValue()) {
                wallConfig.setHintAllow(false);
            }
            Boolean bl17 = tempLockTableAllow = this.lockTableAllow == null ? config.getLockTableAllow() : this.lockTableAllow;
            if (tempLockTableAllow != null && !tempLockTableAllow.booleanValue()) {
                wallConfig.setLockTableAllow(false);
            }
            Boolean bl18 = tempStartTransactionAllow = this.startTransactionAllow == null ? config.getStartTransactionAllow() : this.startTransactionAllow;
            if (tempStartTransactionAllow != null && !tempStartTransactionAllow.booleanValue()) {
                wallConfig.setStartTransactionAllow(false);
            }
            Boolean bl19 = tempBlockAllow = this.blockAllow == null ? config.getBlockAllow() : this.blockAllow;
            if (tempBlockAllow != null && !tempBlockAllow.booleanValue()) {
                wallConfig.setBlockAllow(false);
            }
            Boolean bl20 = tempConditionAndAlwayTrueAllow = this.conditionAndAlwayTrueAllow == null ? config.getConditionAndAlwayTrueAllow() : this.conditionAndAlwayTrueAllow;
            if (tempConditionAndAlwayTrueAllow != null && tempConditionAndAlwayTrueAllow.booleanValue()) {
                wallConfig.setConditionAndAlwayTrueAllow(true);
            }
            Boolean bl21 = tempConditionAndAlwayFalseAllow = this.conditionAndAlwayFalseAllow == null ? config.getConditionAndAlwayFalseAllow() : this.conditionAndAlwayFalseAllow;
            if (tempConditionAndAlwayFalseAllow != null && tempConditionAndAlwayFalseAllow.booleanValue()) {
                wallConfig.setConditionAndAlwayFalseAllow(true);
            }
            Boolean bl22 = tempConditionDoubleConstAllow = this.conditionDoubleConstAllow == null ? config.getConditionDoubleConstAllow() : this.conditionDoubleConstAllow;
            if (tempConditionDoubleConstAllow != null && tempConditionDoubleConstAllow.booleanValue()) {
                wallConfig.setConditionDoubleConstAllow(true);
            }
            Boolean bl23 = tempConditionLikeTrueAllow = this.conditionLikeTrueAllow == null ? config.getConditionLikeTrueAllow() : this.conditionLikeTrueAllow;
            if (tempConditionLikeTrueAllow != null && !tempConditionLikeTrueAllow.booleanValue()) {
                wallConfig.setConditionLikeTrueAllow(false);
            }
            Boolean bl24 = tempSelectAllColumnAllow = this.selectAllColumnAllow == null ? config.getSelectAllColumnAllow() : this.selectAllColumnAllow;
            if (tempSelectAllColumnAllow != null && !tempSelectAllColumnAllow.booleanValue()) {
                wallConfig.setSelectAllColumnAllow(false);
            }
            Boolean bl25 = tempDeleteAllow = this.deleteAllow == null ? config.getDeleteAllow() : this.deleteAllow;
            if (tempDeleteAllow != null && !tempDeleteAllow.booleanValue()) {
                wallConfig.setDeleteAllow(false);
            }
            Boolean bl26 = tempDeleteWhereAlwayTrueCheck = this.deleteWhereAlwayTrueCheck == null ? config.getDeleteWhereAlwayTrueCheck() : this.deleteWhereAlwayTrueCheck;
            if (tempDeleteWhereAlwayTrueCheck != null && !tempDeleteWhereAlwayTrueCheck.booleanValue()) {
                wallConfig.setDeleteWhereAlwayTrueCheck(false);
            }
            Boolean bl27 = tempDeleteWhereNoneCheck = this.deleteWhereNoneCheck == null ? config.getDeleteWhereNoneCheck() : this.deleteWhereNoneCheck;
            if (tempDeleteWhereNoneCheck != null && tempDeleteWhereNoneCheck.booleanValue()) {
                wallConfig.setDeleteWhereNoneCheck(true);
            }
            Boolean bl28 = tempUpdateAllow = this.updateAllow == null ? config.getUpdateAllow() : this.updateAllow;
            if (tempUpdateAllow != null && !tempUpdateAllow.booleanValue()) {
                wallConfig.setUpdateAllow(false);
            }
            Boolean bl29 = tempUpdateWhereAlayTrueCheck = this.updateWhereAlayTrueCheck == null ? config.getUpdateWhereAlayTrueCheck() : this.updateWhereAlayTrueCheck;
            if (tempUpdateWhereAlayTrueCheck != null && !tempUpdateWhereAlayTrueCheck.booleanValue()) {
                wallConfig.setUpdateWhereAlayTrueCheck(false);
            }
            Boolean bl30 = tempUpdateWhereNoneCheck = this.updateWhereNoneCheck == null ? config.getUpdateWhereNoneCheck() : this.updateWhereNoneCheck;
            if (tempUpdateWhereNoneCheck != null && tempUpdateWhereNoneCheck.booleanValue()) {
                wallConfig.setUpdateWhereNoneCheck(true);
            }
            Boolean bl31 = tempInsertAllow = this.insertAllow == null ? config.getInsertAllow() : this.insertAllow;
            if (tempInsertAllow != null && !tempInsertAllow.booleanValue()) {
                wallConfig.setInsertAllow(false);
            }
            Boolean bl32 = tempMergeAllow = this.mergeAllow == null ? config.getMergeAllow() : this.mergeAllow;
            if (tempMergeAllow != null && !tempMergeAllow.booleanValue()) {
                wallConfig.setMergeAllow(false);
            }
            Boolean bl33 = tempMinusAllow = this.minusAllow == null ? config.getMinusAllow() : this.minusAllow;
            if (tempMinusAllow != null && !tempMinusAllow.booleanValue()) {
                wallConfig.setMinusAllow(false);
            }
            Boolean bl34 = tempIntersectAllow = this.intersectAllow == null ? config.getIntersectAllow() : this.intersectAllow;
            if (tempIntersectAllow != null && !tempIntersectAllow.booleanValue()) {
                wallConfig.setIntersectAllow(false);
            }
            Boolean bl35 = tempReplaceAllow = this.replaceAllow == null ? config.getReplaceAllow() : this.replaceAllow;
            if (tempReplaceAllow != null && !tempReplaceAllow.booleanValue()) {
                wallConfig.setReplaceAllow(false);
            }
            Boolean bl36 = tempSetAllow = this.setAllow == null ? config.getSetAllow() : this.setAllow;
            if (tempSetAllow != null && !tempSetAllow.booleanValue()) {
                wallConfig.setSetAllow(false);
            }
            Boolean bl37 = tempCommitAllow = this.commitAllow == null ? config.getCommitAllow() : this.commitAllow;
            if (tempCommitAllow != null && !tempCommitAllow.booleanValue()) {
                wallConfig.setCommitAllow(false);
            }
            Boolean bl38 = tempRollbackAllow = this.rollbackAllow == null ? config.getRollbackAllow() : this.rollbackAllow;
            if (tempRollbackAllow != null && !tempRollbackAllow.booleanValue()) {
                wallConfig.setRollbackAllow(false);
            }
            Boolean bl39 = tempUseAllow = this.useAllow == null ? config.getUseAllow() : this.useAllow;
            if (tempUseAllow != null && !tempUseAllow.booleanValue()) {
                wallConfig.setUseAllow(false);
            }
            Boolean bl40 = tempMultiStatementAllow = this.multiStatementAllow == null ? config.getMultiStatementAllow() : this.multiStatementAllow;
            if (tempMultiStatementAllow != null && tempMultiStatementAllow.booleanValue()) {
                wallConfig.setMultiStatementAllow(true);
            }
            Boolean bl41 = tempTruncateAllow = this.truncateAllow == null ? config.getTruncateAllow() : this.truncateAllow;
            if (tempTruncateAllow != null && !tempTruncateAllow.booleanValue()) {
                wallConfig.setTruncateAllow(false);
            }
            Boolean bl42 = tempCommentAllow = this.commentAllow == null ? config.getCommentAllow() : this.commentAllow;
            if (tempCommentAllow != null && tempCommentAllow.booleanValue()) {
                wallConfig.setCommentAllow(true);
            }
            Boolean bl43 = tempStrictSyntaxCheck = this.strictSyntaxCheck == null ? config.getStrictSyntaxCheck() : this.strictSyntaxCheck;
            if (tempStrictSyntaxCheck != null && !tempStrictSyntaxCheck.booleanValue()) {
                wallConfig.setStrictSyntaxCheck(false);
            }
            Boolean bl44 = tempConstArithmeticAllow = this.constArithmeticAllow == null ? config.getConstArithmeticAllow() : this.constArithmeticAllow;
            if (tempConstArithmeticAllow != null && !tempConstArithmeticAllow.booleanValue()) {
                wallConfig.setConstArithmeticAllow(false);
            }
            Boolean bl45 = tempLimitZeroAllow = this.limitZeroAllow == null ? config.getLimitZeroAllow() : this.limitZeroAllow;
            if (tempLimitZeroAllow != null && tempLimitZeroAllow.booleanValue()) {
                wallConfig.setLimitZeroAllow(true);
            }
            Boolean bl46 = tempDescribeAllow = this.describeAllow == null ? config.getDescribeAllow() : this.describeAllow;
            if (tempDescribeAllow != null && !tempDescribeAllow.booleanValue()) {
                wallConfig.setDescribeAllow(false);
            }
            Boolean bl47 = tempShowAllow = this.showAllow == null ? config.getShowAllow() : this.showAllow;
            if (tempShowAllow != null && !tempShowAllow.booleanValue()) {
                wallConfig.setShowAllow(false);
            }
            Boolean bl48 = tempSchemaCheck = this.schemaCheck == null ? config.getSchemaCheck() : this.schemaCheck;
            if (tempSchemaCheck != null && !tempSchemaCheck.booleanValue()) {
                wallConfig.setSchemaCheck(false);
            }
            Boolean bl49 = tempTableCheck = this.tableCheck == null ? config.getTableCheck() : this.tableCheck;
            if (tempTableCheck != null && !tempTableCheck.booleanValue()) {
                wallConfig.setTableCheck(false);
            }
            Boolean bl50 = tempFunctionCheck = this.functionCheck == null ? config.getFunctionCheck() : this.functionCheck;
            if (tempFunctionCheck != null && !tempFunctionCheck.booleanValue()) {
                wallConfig.setFunctionCheck(false);
            }
            Boolean bl51 = tempObjectCheck = this.objectCheck == null ? config.getObjectCheck() : this.objectCheck;
            if (tempObjectCheck != null && !tempObjectCheck.booleanValue()) {
                wallConfig.setObjectCheck(false);
            }
            Boolean bl52 = tempVariantCheck = this.variantCheck == null ? config.getVariantCheck() : this.variantCheck;
            if (tempVariantCheck != null && !tempVariantCheck.booleanValue()) {
                wallConfig.setVariantCheck(false);
            }
            Boolean bl53 = tempMustParameterized = this.mustParameterized == null ? config.getMustParameterized() : this.mustParameterized;
            if (tempMustParameterized != null && tempMustParameterized.booleanValue()) {
                wallConfig.setMustParameterized(true);
            }
            Boolean bl54 = tempDoPrivilegedAllow = this.doPrivilegedAllow == null ? config.getDoPrivilegedAllow() : this.doPrivilegedAllow;
            if (tempDoPrivilegedAllow != null && tempDoPrivilegedAllow.booleanValue()) {
                wallConfig.setDoPrivilegedAllow(true);
            }
            Boolean bl55 = tempWrapAllow = this.wrapAllow == null ? config.getWrapAllow() : this.wrapAllow;
            if (tempWrapAllow != null && !tempWrapAllow.booleanValue()) {
                wallConfig.setWrapAllow(false);
            }
            Boolean bl56 = tempMetadataAllow = this.metadataAllow == null ? config.getMetadataAllow() : this.metadataAllow;
            if (tempMetadataAllow != null && !tempMetadataAllow.booleanValue()) {
                wallConfig.setMetadataAllow(false);
            }
            Boolean bl57 = tempConditionOpXorAllow = this.conditionOpXorAllow == null ? config.getConditionOpXorAllow() : this.conditionOpXorAllow;
            if (tempConditionOpXorAllow != null && tempConditionOpXorAllow.booleanValue()) {
                wallConfig.setConditionOpXorAllow(true);
            }
            Boolean bl58 = tempConditionOpBitwseAllow = this.conditionOpBitwseAllow == null ? config.getConditionOpBitwseAllow() : this.conditionOpBitwseAllow;
            if (tempConditionOpBitwseAllow != null && !tempConditionOpBitwseAllow.booleanValue()) {
                wallConfig.setConditionOpBitwseAllow(false);
            }
            Boolean bl59 = tempCaseConditionConstAllow = this.caseConditionConstAllow == null ? config.getCaseConditionConstAllow() : this.caseConditionConstAllow;
            if (tempCaseConditionConstAllow != null && tempCaseConditionConstAllow.booleanValue()) {
                wallConfig.setCaseConditionConstAllow(true);
            }
            Boolean bl60 = tempCompleteInsertValuesCheck = this.completeInsertValuesCheck == null ? config.getCompleteInsertValuesCheck() : this.completeInsertValuesCheck;
            if (tempCompleteInsertValuesCheck != null && tempCompleteInsertValuesCheck.booleanValue()) {
                wallConfig.setCompleteInsertValuesCheck(true);
            }
            return wallConfig;
        }

        public Boolean getNoneBaseStatementAllow() {
            return this.noneBaseStatementAllow;
        }

        public Boolean getCallAllow() {
            return this.callAllow;
        }

        public Boolean getSelectAllow() {
            return this.selectAllow;
        }

        public Boolean getSelectIntoAllow() {
            return this.selectIntoAllow;
        }

        public Boolean getSelectIntoOutfileAllow() {
            return this.selectIntoOutfileAllow;
        }

        public Boolean getSelectWhereAlwayTrueCheck() {
            return this.selectWhereAlwayTrueCheck;
        }

        public Boolean getSelectHavingAlwayTrueCheck() {
            return this.selectHavingAlwayTrueCheck;
        }

        public Boolean getSelectUnionCheck() {
            return this.selectUnionCheck;
        }

        public Boolean getSelectMinusCheck() {
            return this.selectMinusCheck;
        }

        public Boolean getSelectExceptCheck() {
            return this.selectExceptCheck;
        }

        public Boolean getSelectIntersectCheck() {
            return this.selectIntersectCheck;
        }

        public Boolean getCreateTableAllow() {
            return this.createTableAllow;
        }

        public Boolean getDropTableAllow() {
            return this.dropTableAllow;
        }

        public Boolean getAlterTableAllow() {
            return this.alterTableAllow;
        }

        public Boolean getRenameTableAllow() {
            return this.renameTableAllow;
        }

        public Boolean getHintAllow() {
            return this.hintAllow;
        }

        public Boolean getLockTableAllow() {
            return this.lockTableAllow;
        }

        public Boolean getStartTransactionAllow() {
            return this.startTransactionAllow;
        }

        public Boolean getBlockAllow() {
            return this.blockAllow;
        }

        public Boolean getConditionAndAlwayTrueAllow() {
            return this.conditionAndAlwayTrueAllow;
        }

        public Boolean getConditionAndAlwayFalseAllow() {
            return this.conditionAndAlwayFalseAllow;
        }

        public Boolean getConditionDoubleConstAllow() {
            return this.conditionDoubleConstAllow;
        }

        public Boolean getConditionLikeTrueAllow() {
            return this.conditionLikeTrueAllow;
        }

        public Boolean getSelectAllColumnAllow() {
            return this.selectAllColumnAllow;
        }

        public Boolean getDeleteAllow() {
            return this.deleteAllow;
        }

        public Boolean getDeleteWhereAlwayTrueCheck() {
            return this.deleteWhereAlwayTrueCheck;
        }

        public Boolean getDeleteWhereNoneCheck() {
            return this.deleteWhereNoneCheck;
        }

        public Boolean getUpdateAllow() {
            return this.updateAllow;
        }

        public Boolean getUpdateWhereAlayTrueCheck() {
            return this.updateWhereAlayTrueCheck;
        }

        public Boolean getUpdateWhereNoneCheck() {
            return this.updateWhereNoneCheck;
        }

        public Boolean getInsertAllow() {
            return this.insertAllow;
        }

        public Boolean getMergeAllow() {
            return this.mergeAllow;
        }

        public Boolean getMinusAllow() {
            return this.minusAllow;
        }

        public Boolean getIntersectAllow() {
            return this.intersectAllow;
        }

        public Boolean getReplaceAllow() {
            return this.replaceAllow;
        }

        public Boolean getSetAllow() {
            return this.setAllow;
        }

        public Boolean getCommitAllow() {
            return this.commitAllow;
        }

        public Boolean getRollbackAllow() {
            return this.rollbackAllow;
        }

        public Boolean getUseAllow() {
            return this.useAllow;
        }

        public Boolean getMultiStatementAllow() {
            return this.multiStatementAllow;
        }

        public Boolean getTruncateAllow() {
            return this.truncateAllow;
        }

        public Boolean getCommentAllow() {
            return this.commentAllow;
        }

        public Boolean getStrictSyntaxCheck() {
            return this.strictSyntaxCheck;
        }

        public Boolean getConstArithmeticAllow() {
            return this.constArithmeticAllow;
        }

        public Boolean getLimitZeroAllow() {
            return this.limitZeroAllow;
        }

        public Boolean getDescribeAllow() {
            return this.describeAllow;
        }

        public Boolean getShowAllow() {
            return this.showAllow;
        }

        public Boolean getSchemaCheck() {
            return this.schemaCheck;
        }

        public Boolean getTableCheck() {
            return this.tableCheck;
        }

        public Boolean getFunctionCheck() {
            return this.functionCheck;
        }

        public Boolean getObjectCheck() {
            return this.objectCheck;
        }

        public Boolean getVariantCheck() {
            return this.variantCheck;
        }

        public Boolean getMustParameterized() {
            return this.mustParameterized;
        }

        public Boolean getDoPrivilegedAllow() {
            return this.doPrivilegedAllow;
        }

        public String getDir() {
            return this.dir;
        }

        public String getTenantTablePattern() {
            return this.tenantTablePattern;
        }

        public String getTenantColumn() {
            return this.tenantColumn;
        }

        public Boolean getWrapAllow() {
            return this.wrapAllow;
        }

        public Boolean getMetadataAllow() {
            return this.metadataAllow;
        }

        public Boolean getConditionOpXorAllow() {
            return this.conditionOpXorAllow;
        }

        public Boolean getConditionOpBitwseAllow() {
            return this.conditionOpBitwseAllow;
        }

        public Boolean getCaseConditionConstAllow() {
            return this.caseConditionConstAllow;
        }

        public Boolean getCompleteInsertValuesCheck() {
            return this.completeInsertValuesCheck;
        }

        public Integer getInsertValuesCheckSize() {
            return this.insertValuesCheckSize;
        }

        public Integer getSelectLimit() {
            return this.selectLimit;
        }

        public DruidWallConfig setNoneBaseStatementAllow(Boolean noneBaseStatementAllow) {
            this.noneBaseStatementAllow = noneBaseStatementAllow;
            return this;
        }

        public DruidWallConfig setCallAllow(Boolean callAllow) {
            this.callAllow = callAllow;
            return this;
        }

        public DruidWallConfig setSelectAllow(Boolean selectAllow) {
            this.selectAllow = selectAllow;
            return this;
        }

        public DruidWallConfig setSelectIntoAllow(Boolean selectIntoAllow) {
            this.selectIntoAllow = selectIntoAllow;
            return this;
        }

        public DruidWallConfig setSelectIntoOutfileAllow(Boolean selectIntoOutfileAllow) {
            this.selectIntoOutfileAllow = selectIntoOutfileAllow;
            return this;
        }

        public DruidWallConfig setSelectWhereAlwayTrueCheck(Boolean selectWhereAlwayTrueCheck) {
            this.selectWhereAlwayTrueCheck = selectWhereAlwayTrueCheck;
            return this;
        }

        public DruidWallConfig setSelectHavingAlwayTrueCheck(Boolean selectHavingAlwayTrueCheck) {
            this.selectHavingAlwayTrueCheck = selectHavingAlwayTrueCheck;
            return this;
        }

        public DruidWallConfig setSelectUnionCheck(Boolean selectUnionCheck) {
            this.selectUnionCheck = selectUnionCheck;
            return this;
        }

        public DruidWallConfig setSelectMinusCheck(Boolean selectMinusCheck) {
            this.selectMinusCheck = selectMinusCheck;
            return this;
        }

        public DruidWallConfig setSelectExceptCheck(Boolean selectExceptCheck) {
            this.selectExceptCheck = selectExceptCheck;
            return this;
        }

        public DruidWallConfig setSelectIntersectCheck(Boolean selectIntersectCheck) {
            this.selectIntersectCheck = selectIntersectCheck;
            return this;
        }

        public DruidWallConfig setCreateTableAllow(Boolean createTableAllow) {
            this.createTableAllow = createTableAllow;
            return this;
        }

        public DruidWallConfig setDropTableAllow(Boolean dropTableAllow) {
            this.dropTableAllow = dropTableAllow;
            return this;
        }

        public DruidWallConfig setAlterTableAllow(Boolean alterTableAllow) {
            this.alterTableAllow = alterTableAllow;
            return this;
        }

        public DruidWallConfig setRenameTableAllow(Boolean renameTableAllow) {
            this.renameTableAllow = renameTableAllow;
            return this;
        }

        public DruidWallConfig setHintAllow(Boolean hintAllow) {
            this.hintAllow = hintAllow;
            return this;
        }

        public DruidWallConfig setLockTableAllow(Boolean lockTableAllow) {
            this.lockTableAllow = lockTableAllow;
            return this;
        }

        public DruidWallConfig setStartTransactionAllow(Boolean startTransactionAllow) {
            this.startTransactionAllow = startTransactionAllow;
            return this;
        }

        public DruidWallConfig setBlockAllow(Boolean blockAllow) {
            this.blockAllow = blockAllow;
            return this;
        }

        public DruidWallConfig setConditionAndAlwayTrueAllow(Boolean conditionAndAlwayTrueAllow) {
            this.conditionAndAlwayTrueAllow = conditionAndAlwayTrueAllow;
            return this;
        }

        public DruidWallConfig setConditionAndAlwayFalseAllow(Boolean conditionAndAlwayFalseAllow) {
            this.conditionAndAlwayFalseAllow = conditionAndAlwayFalseAllow;
            return this;
        }

        public DruidWallConfig setConditionDoubleConstAllow(Boolean conditionDoubleConstAllow) {
            this.conditionDoubleConstAllow = conditionDoubleConstAllow;
            return this;
        }

        public DruidWallConfig setConditionLikeTrueAllow(Boolean conditionLikeTrueAllow) {
            this.conditionLikeTrueAllow = conditionLikeTrueAllow;
            return this;
        }

        public DruidWallConfig setSelectAllColumnAllow(Boolean selectAllColumnAllow) {
            this.selectAllColumnAllow = selectAllColumnAllow;
            return this;
        }

        public DruidWallConfig setDeleteAllow(Boolean deleteAllow) {
            this.deleteAllow = deleteAllow;
            return this;
        }

        public DruidWallConfig setDeleteWhereAlwayTrueCheck(Boolean deleteWhereAlwayTrueCheck) {
            this.deleteWhereAlwayTrueCheck = deleteWhereAlwayTrueCheck;
            return this;
        }

        public DruidWallConfig setDeleteWhereNoneCheck(Boolean deleteWhereNoneCheck) {
            this.deleteWhereNoneCheck = deleteWhereNoneCheck;
            return this;
        }

        public DruidWallConfig setUpdateAllow(Boolean updateAllow) {
            this.updateAllow = updateAllow;
            return this;
        }

        public DruidWallConfig setUpdateWhereAlayTrueCheck(Boolean updateWhereAlayTrueCheck) {
            this.updateWhereAlayTrueCheck = updateWhereAlayTrueCheck;
            return this;
        }

        public DruidWallConfig setUpdateWhereNoneCheck(Boolean updateWhereNoneCheck) {
            this.updateWhereNoneCheck = updateWhereNoneCheck;
            return this;
        }

        public DruidWallConfig setInsertAllow(Boolean insertAllow) {
            this.insertAllow = insertAllow;
            return this;
        }

        public DruidWallConfig setMergeAllow(Boolean mergeAllow) {
            this.mergeAllow = mergeAllow;
            return this;
        }

        public DruidWallConfig setMinusAllow(Boolean minusAllow) {
            this.minusAllow = minusAllow;
            return this;
        }

        public DruidWallConfig setIntersectAllow(Boolean intersectAllow) {
            this.intersectAllow = intersectAllow;
            return this;
        }

        public DruidWallConfig setReplaceAllow(Boolean replaceAllow) {
            this.replaceAllow = replaceAllow;
            return this;
        }

        public DruidWallConfig setSetAllow(Boolean setAllow) {
            this.setAllow = setAllow;
            return this;
        }

        public DruidWallConfig setCommitAllow(Boolean commitAllow) {
            this.commitAllow = commitAllow;
            return this;
        }

        public DruidWallConfig setRollbackAllow(Boolean rollbackAllow) {
            this.rollbackAllow = rollbackAllow;
            return this;
        }

        public DruidWallConfig setUseAllow(Boolean useAllow) {
            this.useAllow = useAllow;
            return this;
        }

        public DruidWallConfig setMultiStatementAllow(Boolean multiStatementAllow) {
            this.multiStatementAllow = multiStatementAllow;
            return this;
        }

        public DruidWallConfig setTruncateAllow(Boolean truncateAllow) {
            this.truncateAllow = truncateAllow;
            return this;
        }

        public DruidWallConfig setCommentAllow(Boolean commentAllow) {
            this.commentAllow = commentAllow;
            return this;
        }

        public DruidWallConfig setStrictSyntaxCheck(Boolean strictSyntaxCheck) {
            this.strictSyntaxCheck = strictSyntaxCheck;
            return this;
        }

        public DruidWallConfig setConstArithmeticAllow(Boolean constArithmeticAllow) {
            this.constArithmeticAllow = constArithmeticAllow;
            return this;
        }

        public DruidWallConfig setLimitZeroAllow(Boolean limitZeroAllow) {
            this.limitZeroAllow = limitZeroAllow;
            return this;
        }

        public DruidWallConfig setDescribeAllow(Boolean describeAllow) {
            this.describeAllow = describeAllow;
            return this;
        }

        public DruidWallConfig setShowAllow(Boolean showAllow) {
            this.showAllow = showAllow;
            return this;
        }

        public DruidWallConfig setSchemaCheck(Boolean schemaCheck) {
            this.schemaCheck = schemaCheck;
            return this;
        }

        public DruidWallConfig setTableCheck(Boolean tableCheck) {
            this.tableCheck = tableCheck;
            return this;
        }

        public DruidWallConfig setFunctionCheck(Boolean functionCheck) {
            this.functionCheck = functionCheck;
            return this;
        }

        public DruidWallConfig setObjectCheck(Boolean objectCheck) {
            this.objectCheck = objectCheck;
            return this;
        }

        public DruidWallConfig setVariantCheck(Boolean variantCheck) {
            this.variantCheck = variantCheck;
            return this;
        }

        public DruidWallConfig setMustParameterized(Boolean mustParameterized) {
            this.mustParameterized = mustParameterized;
            return this;
        }

        public DruidWallConfig setDoPrivilegedAllow(Boolean doPrivilegedAllow) {
            this.doPrivilegedAllow = doPrivilegedAllow;
            return this;
        }

        public DruidWallConfig setDir(String dir) {
            this.dir = dir;
            return this;
        }

        public DruidWallConfig setTenantTablePattern(String tenantTablePattern) {
            this.tenantTablePattern = tenantTablePattern;
            return this;
        }

        public DruidWallConfig setTenantColumn(String tenantColumn) {
            this.tenantColumn = tenantColumn;
            return this;
        }

        public DruidWallConfig setWrapAllow(Boolean wrapAllow) {
            this.wrapAllow = wrapAllow;
            return this;
        }

        public DruidWallConfig setMetadataAllow(Boolean metadataAllow) {
            this.metadataAllow = metadataAllow;
            return this;
        }

        public DruidWallConfig setConditionOpXorAllow(Boolean conditionOpXorAllow) {
            this.conditionOpXorAllow = conditionOpXorAllow;
            return this;
        }

        public DruidWallConfig setConditionOpBitwseAllow(Boolean conditionOpBitwseAllow) {
            this.conditionOpBitwseAllow = conditionOpBitwseAllow;
            return this;
        }

        public DruidWallConfig setCaseConditionConstAllow(Boolean caseConditionConstAllow) {
            this.caseConditionConstAllow = caseConditionConstAllow;
            return this;
        }

        public DruidWallConfig setCompleteInsertValuesCheck(Boolean completeInsertValuesCheck) {
            this.completeInsertValuesCheck = completeInsertValuesCheck;
            return this;
        }

        public DruidWallConfig setInsertValuesCheckSize(Integer insertValuesCheckSize) {
            this.insertValuesCheckSize = insertValuesCheckSize;
            return this;
        }

        public DruidWallConfig setSelectLimit(Integer selectLimit) {
            this.selectLimit = selectLimit;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DruidWallConfig)) {
                return false;
            }
            DruidWallConfig other = (DruidWallConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$noneBaseStatementAllow = this.getNoneBaseStatementAllow();
            Boolean other$noneBaseStatementAllow = other.getNoneBaseStatementAllow();
            if (this$noneBaseStatementAllow == null ? other$noneBaseStatementAllow != null : !((Object)this$noneBaseStatementAllow).equals(other$noneBaseStatementAllow)) {
                return false;
            }
            Boolean this$callAllow = this.getCallAllow();
            Boolean other$callAllow = other.getCallAllow();
            if (this$callAllow == null ? other$callAllow != null : !((Object)this$callAllow).equals(other$callAllow)) {
                return false;
            }
            Boolean this$selectAllow = this.getSelectAllow();
            Boolean other$selectAllow = other.getSelectAllow();
            if (this$selectAllow == null ? other$selectAllow != null : !((Object)this$selectAllow).equals(other$selectAllow)) {
                return false;
            }
            Boolean this$selectIntoAllow = this.getSelectIntoAllow();
            Boolean other$selectIntoAllow = other.getSelectIntoAllow();
            if (this$selectIntoAllow == null ? other$selectIntoAllow != null : !((Object)this$selectIntoAllow).equals(other$selectIntoAllow)) {
                return false;
            }
            Boolean this$selectIntoOutfileAllow = this.getSelectIntoOutfileAllow();
            Boolean other$selectIntoOutfileAllow = other.getSelectIntoOutfileAllow();
            if (this$selectIntoOutfileAllow == null ? other$selectIntoOutfileAllow != null : !((Object)this$selectIntoOutfileAllow).equals(other$selectIntoOutfileAllow)) {
                return false;
            }
            Boolean this$selectWhereAlwayTrueCheck = this.getSelectWhereAlwayTrueCheck();
            Boolean other$selectWhereAlwayTrueCheck = other.getSelectWhereAlwayTrueCheck();
            if (this$selectWhereAlwayTrueCheck == null ? other$selectWhereAlwayTrueCheck != null : !((Object)this$selectWhereAlwayTrueCheck).equals(other$selectWhereAlwayTrueCheck)) {
                return false;
            }
            Boolean this$selectHavingAlwayTrueCheck = this.getSelectHavingAlwayTrueCheck();
            Boolean other$selectHavingAlwayTrueCheck = other.getSelectHavingAlwayTrueCheck();
            if (this$selectHavingAlwayTrueCheck == null ? other$selectHavingAlwayTrueCheck != null : !((Object)this$selectHavingAlwayTrueCheck).equals(other$selectHavingAlwayTrueCheck)) {
                return false;
            }
            Boolean this$selectUnionCheck = this.getSelectUnionCheck();
            Boolean other$selectUnionCheck = other.getSelectUnionCheck();
            if (this$selectUnionCheck == null ? other$selectUnionCheck != null : !((Object)this$selectUnionCheck).equals(other$selectUnionCheck)) {
                return false;
            }
            Boolean this$selectMinusCheck = this.getSelectMinusCheck();
            Boolean other$selectMinusCheck = other.getSelectMinusCheck();
            if (this$selectMinusCheck == null ? other$selectMinusCheck != null : !((Object)this$selectMinusCheck).equals(other$selectMinusCheck)) {
                return false;
            }
            Boolean this$selectExceptCheck = this.getSelectExceptCheck();
            Boolean other$selectExceptCheck = other.getSelectExceptCheck();
            if (this$selectExceptCheck == null ? other$selectExceptCheck != null : !((Object)this$selectExceptCheck).equals(other$selectExceptCheck)) {
                return false;
            }
            Boolean this$selectIntersectCheck = this.getSelectIntersectCheck();
            Boolean other$selectIntersectCheck = other.getSelectIntersectCheck();
            if (this$selectIntersectCheck == null ? other$selectIntersectCheck != null : !((Object)this$selectIntersectCheck).equals(other$selectIntersectCheck)) {
                return false;
            }
            Boolean this$createTableAllow = this.getCreateTableAllow();
            Boolean other$createTableAllow = other.getCreateTableAllow();
            if (this$createTableAllow == null ? other$createTableAllow != null : !((Object)this$createTableAllow).equals(other$createTableAllow)) {
                return false;
            }
            Boolean this$dropTableAllow = this.getDropTableAllow();
            Boolean other$dropTableAllow = other.getDropTableAllow();
            if (this$dropTableAllow == null ? other$dropTableAllow != null : !((Object)this$dropTableAllow).equals(other$dropTableAllow)) {
                return false;
            }
            Boolean this$alterTableAllow = this.getAlterTableAllow();
            Boolean other$alterTableAllow = other.getAlterTableAllow();
            if (this$alterTableAllow == null ? other$alterTableAllow != null : !((Object)this$alterTableAllow).equals(other$alterTableAllow)) {
                return false;
            }
            Boolean this$renameTableAllow = this.getRenameTableAllow();
            Boolean other$renameTableAllow = other.getRenameTableAllow();
            if (this$renameTableAllow == null ? other$renameTableAllow != null : !((Object)this$renameTableAllow).equals(other$renameTableAllow)) {
                return false;
            }
            Boolean this$hintAllow = this.getHintAllow();
            Boolean other$hintAllow = other.getHintAllow();
            if (this$hintAllow == null ? other$hintAllow != null : !((Object)this$hintAllow).equals(other$hintAllow)) {
                return false;
            }
            Boolean this$lockTableAllow = this.getLockTableAllow();
            Boolean other$lockTableAllow = other.getLockTableAllow();
            if (this$lockTableAllow == null ? other$lockTableAllow != null : !((Object)this$lockTableAllow).equals(other$lockTableAllow)) {
                return false;
            }
            Boolean this$startTransactionAllow = this.getStartTransactionAllow();
            Boolean other$startTransactionAllow = other.getStartTransactionAllow();
            if (this$startTransactionAllow == null ? other$startTransactionAllow != null : !((Object)this$startTransactionAllow).equals(other$startTransactionAllow)) {
                return false;
            }
            Boolean this$blockAllow = this.getBlockAllow();
            Boolean other$blockAllow = other.getBlockAllow();
            if (this$blockAllow == null ? other$blockAllow != null : !((Object)this$blockAllow).equals(other$blockAllow)) {
                return false;
            }
            Boolean this$conditionAndAlwayTrueAllow = this.getConditionAndAlwayTrueAllow();
            Boolean other$conditionAndAlwayTrueAllow = other.getConditionAndAlwayTrueAllow();
            if (this$conditionAndAlwayTrueAllow == null ? other$conditionAndAlwayTrueAllow != null : !((Object)this$conditionAndAlwayTrueAllow).equals(other$conditionAndAlwayTrueAllow)) {
                return false;
            }
            Boolean this$conditionAndAlwayFalseAllow = this.getConditionAndAlwayFalseAllow();
            Boolean other$conditionAndAlwayFalseAllow = other.getConditionAndAlwayFalseAllow();
            if (this$conditionAndAlwayFalseAllow == null ? other$conditionAndAlwayFalseAllow != null : !((Object)this$conditionAndAlwayFalseAllow).equals(other$conditionAndAlwayFalseAllow)) {
                return false;
            }
            Boolean this$conditionDoubleConstAllow = this.getConditionDoubleConstAllow();
            Boolean other$conditionDoubleConstAllow = other.getConditionDoubleConstAllow();
            if (this$conditionDoubleConstAllow == null ? other$conditionDoubleConstAllow != null : !((Object)this$conditionDoubleConstAllow).equals(other$conditionDoubleConstAllow)) {
                return false;
            }
            Boolean this$conditionLikeTrueAllow = this.getConditionLikeTrueAllow();
            Boolean other$conditionLikeTrueAllow = other.getConditionLikeTrueAllow();
            if (this$conditionLikeTrueAllow == null ? other$conditionLikeTrueAllow != null : !((Object)this$conditionLikeTrueAllow).equals(other$conditionLikeTrueAllow)) {
                return false;
            }
            Boolean this$selectAllColumnAllow = this.getSelectAllColumnAllow();
            Boolean other$selectAllColumnAllow = other.getSelectAllColumnAllow();
            if (this$selectAllColumnAllow == null ? other$selectAllColumnAllow != null : !((Object)this$selectAllColumnAllow).equals(other$selectAllColumnAllow)) {
                return false;
            }
            Boolean this$deleteAllow = this.getDeleteAllow();
            Boolean other$deleteAllow = other.getDeleteAllow();
            if (this$deleteAllow == null ? other$deleteAllow != null : !((Object)this$deleteAllow).equals(other$deleteAllow)) {
                return false;
            }
            Boolean this$deleteWhereAlwayTrueCheck = this.getDeleteWhereAlwayTrueCheck();
            Boolean other$deleteWhereAlwayTrueCheck = other.getDeleteWhereAlwayTrueCheck();
            if (this$deleteWhereAlwayTrueCheck == null ? other$deleteWhereAlwayTrueCheck != null : !((Object)this$deleteWhereAlwayTrueCheck).equals(other$deleteWhereAlwayTrueCheck)) {
                return false;
            }
            Boolean this$deleteWhereNoneCheck = this.getDeleteWhereNoneCheck();
            Boolean other$deleteWhereNoneCheck = other.getDeleteWhereNoneCheck();
            if (this$deleteWhereNoneCheck == null ? other$deleteWhereNoneCheck != null : !((Object)this$deleteWhereNoneCheck).equals(other$deleteWhereNoneCheck)) {
                return false;
            }
            Boolean this$updateAllow = this.getUpdateAllow();
            Boolean other$updateAllow = other.getUpdateAllow();
            if (this$updateAllow == null ? other$updateAllow != null : !((Object)this$updateAllow).equals(other$updateAllow)) {
                return false;
            }
            Boolean this$updateWhereAlayTrueCheck = this.getUpdateWhereAlayTrueCheck();
            Boolean other$updateWhereAlayTrueCheck = other.getUpdateWhereAlayTrueCheck();
            if (this$updateWhereAlayTrueCheck == null ? other$updateWhereAlayTrueCheck != null : !((Object)this$updateWhereAlayTrueCheck).equals(other$updateWhereAlayTrueCheck)) {
                return false;
            }
            Boolean this$updateWhereNoneCheck = this.getUpdateWhereNoneCheck();
            Boolean other$updateWhereNoneCheck = other.getUpdateWhereNoneCheck();
            if (this$updateWhereNoneCheck == null ? other$updateWhereNoneCheck != null : !((Object)this$updateWhereNoneCheck).equals(other$updateWhereNoneCheck)) {
                return false;
            }
            Boolean this$insertAllow = this.getInsertAllow();
            Boolean other$insertAllow = other.getInsertAllow();
            if (this$insertAllow == null ? other$insertAllow != null : !((Object)this$insertAllow).equals(other$insertAllow)) {
                return false;
            }
            Boolean this$mergeAllow = this.getMergeAllow();
            Boolean other$mergeAllow = other.getMergeAllow();
            if (this$mergeAllow == null ? other$mergeAllow != null : !((Object)this$mergeAllow).equals(other$mergeAllow)) {
                return false;
            }
            Boolean this$minusAllow = this.getMinusAllow();
            Boolean other$minusAllow = other.getMinusAllow();
            if (this$minusAllow == null ? other$minusAllow != null : !((Object)this$minusAllow).equals(other$minusAllow)) {
                return false;
            }
            Boolean this$intersectAllow = this.getIntersectAllow();
            Boolean other$intersectAllow = other.getIntersectAllow();
            if (this$intersectAllow == null ? other$intersectAllow != null : !((Object)this$intersectAllow).equals(other$intersectAllow)) {
                return false;
            }
            Boolean this$replaceAllow = this.getReplaceAllow();
            Boolean other$replaceAllow = other.getReplaceAllow();
            if (this$replaceAllow == null ? other$replaceAllow != null : !((Object)this$replaceAllow).equals(other$replaceAllow)) {
                return false;
            }
            Boolean this$setAllow = this.getSetAllow();
            Boolean other$setAllow = other.getSetAllow();
            if (this$setAllow == null ? other$setAllow != null : !((Object)this$setAllow).equals(other$setAllow)) {
                return false;
            }
            Boolean this$commitAllow = this.getCommitAllow();
            Boolean other$commitAllow = other.getCommitAllow();
            if (this$commitAllow == null ? other$commitAllow != null : !((Object)this$commitAllow).equals(other$commitAllow)) {
                return false;
            }
            Boolean this$rollbackAllow = this.getRollbackAllow();
            Boolean other$rollbackAllow = other.getRollbackAllow();
            if (this$rollbackAllow == null ? other$rollbackAllow != null : !((Object)this$rollbackAllow).equals(other$rollbackAllow)) {
                return false;
            }
            Boolean this$useAllow = this.getUseAllow();
            Boolean other$useAllow = other.getUseAllow();
            if (this$useAllow == null ? other$useAllow != null : !((Object)this$useAllow).equals(other$useAllow)) {
                return false;
            }
            Boolean this$multiStatementAllow = this.getMultiStatementAllow();
            Boolean other$multiStatementAllow = other.getMultiStatementAllow();
            if (this$multiStatementAllow == null ? other$multiStatementAllow != null : !((Object)this$multiStatementAllow).equals(other$multiStatementAllow)) {
                return false;
            }
            Boolean this$truncateAllow = this.getTruncateAllow();
            Boolean other$truncateAllow = other.getTruncateAllow();
            if (this$truncateAllow == null ? other$truncateAllow != null : !((Object)this$truncateAllow).equals(other$truncateAllow)) {
                return false;
            }
            Boolean this$commentAllow = this.getCommentAllow();
            Boolean other$commentAllow = other.getCommentAllow();
            if (this$commentAllow == null ? other$commentAllow != null : !((Object)this$commentAllow).equals(other$commentAllow)) {
                return false;
            }
            Boolean this$strictSyntaxCheck = this.getStrictSyntaxCheck();
            Boolean other$strictSyntaxCheck = other.getStrictSyntaxCheck();
            if (this$strictSyntaxCheck == null ? other$strictSyntaxCheck != null : !((Object)this$strictSyntaxCheck).equals(other$strictSyntaxCheck)) {
                return false;
            }
            Boolean this$constArithmeticAllow = this.getConstArithmeticAllow();
            Boolean other$constArithmeticAllow = other.getConstArithmeticAllow();
            if (this$constArithmeticAllow == null ? other$constArithmeticAllow != null : !((Object)this$constArithmeticAllow).equals(other$constArithmeticAllow)) {
                return false;
            }
            Boolean this$limitZeroAllow = this.getLimitZeroAllow();
            Boolean other$limitZeroAllow = other.getLimitZeroAllow();
            if (this$limitZeroAllow == null ? other$limitZeroAllow != null : !((Object)this$limitZeroAllow).equals(other$limitZeroAllow)) {
                return false;
            }
            Boolean this$describeAllow = this.getDescribeAllow();
            Boolean other$describeAllow = other.getDescribeAllow();
            if (this$describeAllow == null ? other$describeAllow != null : !((Object)this$describeAllow).equals(other$describeAllow)) {
                return false;
            }
            Boolean this$showAllow = this.getShowAllow();
            Boolean other$showAllow = other.getShowAllow();
            if (this$showAllow == null ? other$showAllow != null : !((Object)this$showAllow).equals(other$showAllow)) {
                return false;
            }
            Boolean this$schemaCheck = this.getSchemaCheck();
            Boolean other$schemaCheck = other.getSchemaCheck();
            if (this$schemaCheck == null ? other$schemaCheck != null : !((Object)this$schemaCheck).equals(other$schemaCheck)) {
                return false;
            }
            Boolean this$tableCheck = this.getTableCheck();
            Boolean other$tableCheck = other.getTableCheck();
            if (this$tableCheck == null ? other$tableCheck != null : !((Object)this$tableCheck).equals(other$tableCheck)) {
                return false;
            }
            Boolean this$functionCheck = this.getFunctionCheck();
            Boolean other$functionCheck = other.getFunctionCheck();
            if (this$functionCheck == null ? other$functionCheck != null : !((Object)this$functionCheck).equals(other$functionCheck)) {
                return false;
            }
            Boolean this$objectCheck = this.getObjectCheck();
            Boolean other$objectCheck = other.getObjectCheck();
            if (this$objectCheck == null ? other$objectCheck != null : !((Object)this$objectCheck).equals(other$objectCheck)) {
                return false;
            }
            Boolean this$variantCheck = this.getVariantCheck();
            Boolean other$variantCheck = other.getVariantCheck();
            if (this$variantCheck == null ? other$variantCheck != null : !((Object)this$variantCheck).equals(other$variantCheck)) {
                return false;
            }
            Boolean this$mustParameterized = this.getMustParameterized();
            Boolean other$mustParameterized = other.getMustParameterized();
            if (this$mustParameterized == null ? other$mustParameterized != null : !((Object)this$mustParameterized).equals(other$mustParameterized)) {
                return false;
            }
            Boolean this$doPrivilegedAllow = this.getDoPrivilegedAllow();
            Boolean other$doPrivilegedAllow = other.getDoPrivilegedAllow();
            if (this$doPrivilegedAllow == null ? other$doPrivilegedAllow != null : !((Object)this$doPrivilegedAllow).equals(other$doPrivilegedAllow)) {
                return false;
            }
            String this$dir = this.getDir();
            String other$dir = other.getDir();
            if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
                return false;
            }
            String this$tenantTablePattern = this.getTenantTablePattern();
            String other$tenantTablePattern = other.getTenantTablePattern();
            if (this$tenantTablePattern == null ? other$tenantTablePattern != null : !this$tenantTablePattern.equals(other$tenantTablePattern)) {
                return false;
            }
            String this$tenantColumn = this.getTenantColumn();
            String other$tenantColumn = other.getTenantColumn();
            if (this$tenantColumn == null ? other$tenantColumn != null : !this$tenantColumn.equals(other$tenantColumn)) {
                return false;
            }
            Boolean this$wrapAllow = this.getWrapAllow();
            Boolean other$wrapAllow = other.getWrapAllow();
            if (this$wrapAllow == null ? other$wrapAllow != null : !((Object)this$wrapAllow).equals(other$wrapAllow)) {
                return false;
            }
            Boolean this$metadataAllow = this.getMetadataAllow();
            Boolean other$metadataAllow = other.getMetadataAllow();
            if (this$metadataAllow == null ? other$metadataAllow != null : !((Object)this$metadataAllow).equals(other$metadataAllow)) {
                return false;
            }
            Boolean this$conditionOpXorAllow = this.getConditionOpXorAllow();
            Boolean other$conditionOpXorAllow = other.getConditionOpXorAllow();
            if (this$conditionOpXorAllow == null ? other$conditionOpXorAllow != null : !((Object)this$conditionOpXorAllow).equals(other$conditionOpXorAllow)) {
                return false;
            }
            Boolean this$conditionOpBitwseAllow = this.getConditionOpBitwseAllow();
            Boolean other$conditionOpBitwseAllow = other.getConditionOpBitwseAllow();
            if (this$conditionOpBitwseAllow == null ? other$conditionOpBitwseAllow != null : !((Object)this$conditionOpBitwseAllow).equals(other$conditionOpBitwseAllow)) {
                return false;
            }
            Boolean this$caseConditionConstAllow = this.getCaseConditionConstAllow();
            Boolean other$caseConditionConstAllow = other.getCaseConditionConstAllow();
            if (this$caseConditionConstAllow == null ? other$caseConditionConstAllow != null : !((Object)this$caseConditionConstAllow).equals(other$caseConditionConstAllow)) {
                return false;
            }
            Boolean this$completeInsertValuesCheck = this.getCompleteInsertValuesCheck();
            Boolean other$completeInsertValuesCheck = other.getCompleteInsertValuesCheck();
            if (this$completeInsertValuesCheck == null ? other$completeInsertValuesCheck != null : !((Object)this$completeInsertValuesCheck).equals(other$completeInsertValuesCheck)) {
                return false;
            }
            Integer this$insertValuesCheckSize = this.getInsertValuesCheckSize();
            Integer other$insertValuesCheckSize = other.getInsertValuesCheckSize();
            if (this$insertValuesCheckSize == null ? other$insertValuesCheckSize != null : !((Object)this$insertValuesCheckSize).equals(other$insertValuesCheckSize)) {
                return false;
            }
            Integer this$selectLimit = this.getSelectLimit();
            Integer other$selectLimit = other.getSelectLimit();
            return !(this$selectLimit == null ? other$selectLimit != null : !((Object)this$selectLimit).equals(other$selectLimit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DruidWallConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $noneBaseStatementAllow = this.getNoneBaseStatementAllow();
            result = result * 59 + ($noneBaseStatementAllow == null ? 43 : ((Object)$noneBaseStatementAllow).hashCode());
            Boolean $callAllow = this.getCallAllow();
            result = result * 59 + ($callAllow == null ? 43 : ((Object)$callAllow).hashCode());
            Boolean $selectAllow = this.getSelectAllow();
            result = result * 59 + ($selectAllow == null ? 43 : ((Object)$selectAllow).hashCode());
            Boolean $selectIntoAllow = this.getSelectIntoAllow();
            result = result * 59 + ($selectIntoAllow == null ? 43 : ((Object)$selectIntoAllow).hashCode());
            Boolean $selectIntoOutfileAllow = this.getSelectIntoOutfileAllow();
            result = result * 59 + ($selectIntoOutfileAllow == null ? 43 : ((Object)$selectIntoOutfileAllow).hashCode());
            Boolean $selectWhereAlwayTrueCheck = this.getSelectWhereAlwayTrueCheck();
            result = result * 59 + ($selectWhereAlwayTrueCheck == null ? 43 : ((Object)$selectWhereAlwayTrueCheck).hashCode());
            Boolean $selectHavingAlwayTrueCheck = this.getSelectHavingAlwayTrueCheck();
            result = result * 59 + ($selectHavingAlwayTrueCheck == null ? 43 : ((Object)$selectHavingAlwayTrueCheck).hashCode());
            Boolean $selectUnionCheck = this.getSelectUnionCheck();
            result = result * 59 + ($selectUnionCheck == null ? 43 : ((Object)$selectUnionCheck).hashCode());
            Boolean $selectMinusCheck = this.getSelectMinusCheck();
            result = result * 59 + ($selectMinusCheck == null ? 43 : ((Object)$selectMinusCheck).hashCode());
            Boolean $selectExceptCheck = this.getSelectExceptCheck();
            result = result * 59 + ($selectExceptCheck == null ? 43 : ((Object)$selectExceptCheck).hashCode());
            Boolean $selectIntersectCheck = this.getSelectIntersectCheck();
            result = result * 59 + ($selectIntersectCheck == null ? 43 : ((Object)$selectIntersectCheck).hashCode());
            Boolean $createTableAllow = this.getCreateTableAllow();
            result = result * 59 + ($createTableAllow == null ? 43 : ((Object)$createTableAllow).hashCode());
            Boolean $dropTableAllow = this.getDropTableAllow();
            result = result * 59 + ($dropTableAllow == null ? 43 : ((Object)$dropTableAllow).hashCode());
            Boolean $alterTableAllow = this.getAlterTableAllow();
            result = result * 59 + ($alterTableAllow == null ? 43 : ((Object)$alterTableAllow).hashCode());
            Boolean $renameTableAllow = this.getRenameTableAllow();
            result = result * 59 + ($renameTableAllow == null ? 43 : ((Object)$renameTableAllow).hashCode());
            Boolean $hintAllow = this.getHintAllow();
            result = result * 59 + ($hintAllow == null ? 43 : ((Object)$hintAllow).hashCode());
            Boolean $lockTableAllow = this.getLockTableAllow();
            result = result * 59 + ($lockTableAllow == null ? 43 : ((Object)$lockTableAllow).hashCode());
            Boolean $startTransactionAllow = this.getStartTransactionAllow();
            result = result * 59 + ($startTransactionAllow == null ? 43 : ((Object)$startTransactionAllow).hashCode());
            Boolean $blockAllow = this.getBlockAllow();
            result = result * 59 + ($blockAllow == null ? 43 : ((Object)$blockAllow).hashCode());
            Boolean $conditionAndAlwayTrueAllow = this.getConditionAndAlwayTrueAllow();
            result = result * 59 + ($conditionAndAlwayTrueAllow == null ? 43 : ((Object)$conditionAndAlwayTrueAllow).hashCode());
            Boolean $conditionAndAlwayFalseAllow = this.getConditionAndAlwayFalseAllow();
            result = result * 59 + ($conditionAndAlwayFalseAllow == null ? 43 : ((Object)$conditionAndAlwayFalseAllow).hashCode());
            Boolean $conditionDoubleConstAllow = this.getConditionDoubleConstAllow();
            result = result * 59 + ($conditionDoubleConstAllow == null ? 43 : ((Object)$conditionDoubleConstAllow).hashCode());
            Boolean $conditionLikeTrueAllow = this.getConditionLikeTrueAllow();
            result = result * 59 + ($conditionLikeTrueAllow == null ? 43 : ((Object)$conditionLikeTrueAllow).hashCode());
            Boolean $selectAllColumnAllow = this.getSelectAllColumnAllow();
            result = result * 59 + ($selectAllColumnAllow == null ? 43 : ((Object)$selectAllColumnAllow).hashCode());
            Boolean $deleteAllow = this.getDeleteAllow();
            result = result * 59 + ($deleteAllow == null ? 43 : ((Object)$deleteAllow).hashCode());
            Boolean $deleteWhereAlwayTrueCheck = this.getDeleteWhereAlwayTrueCheck();
            result = result * 59 + ($deleteWhereAlwayTrueCheck == null ? 43 : ((Object)$deleteWhereAlwayTrueCheck).hashCode());
            Boolean $deleteWhereNoneCheck = this.getDeleteWhereNoneCheck();
            result = result * 59 + ($deleteWhereNoneCheck == null ? 43 : ((Object)$deleteWhereNoneCheck).hashCode());
            Boolean $updateAllow = this.getUpdateAllow();
            result = result * 59 + ($updateAllow == null ? 43 : ((Object)$updateAllow).hashCode());
            Boolean $updateWhereAlayTrueCheck = this.getUpdateWhereAlayTrueCheck();
            result = result * 59 + ($updateWhereAlayTrueCheck == null ? 43 : ((Object)$updateWhereAlayTrueCheck).hashCode());
            Boolean $updateWhereNoneCheck = this.getUpdateWhereNoneCheck();
            result = result * 59 + ($updateWhereNoneCheck == null ? 43 : ((Object)$updateWhereNoneCheck).hashCode());
            Boolean $insertAllow = this.getInsertAllow();
            result = result * 59 + ($insertAllow == null ? 43 : ((Object)$insertAllow).hashCode());
            Boolean $mergeAllow = this.getMergeAllow();
            result = result * 59 + ($mergeAllow == null ? 43 : ((Object)$mergeAllow).hashCode());
            Boolean $minusAllow = this.getMinusAllow();
            result = result * 59 + ($minusAllow == null ? 43 : ((Object)$minusAllow).hashCode());
            Boolean $intersectAllow = this.getIntersectAllow();
            result = result * 59 + ($intersectAllow == null ? 43 : ((Object)$intersectAllow).hashCode());
            Boolean $replaceAllow = this.getReplaceAllow();
            result = result * 59 + ($replaceAllow == null ? 43 : ((Object)$replaceAllow).hashCode());
            Boolean $setAllow = this.getSetAllow();
            result = result * 59 + ($setAllow == null ? 43 : ((Object)$setAllow).hashCode());
            Boolean $commitAllow = this.getCommitAllow();
            result = result * 59 + ($commitAllow == null ? 43 : ((Object)$commitAllow).hashCode());
            Boolean $rollbackAllow = this.getRollbackAllow();
            result = result * 59 + ($rollbackAllow == null ? 43 : ((Object)$rollbackAllow).hashCode());
            Boolean $useAllow = this.getUseAllow();
            result = result * 59 + ($useAllow == null ? 43 : ((Object)$useAllow).hashCode());
            Boolean $multiStatementAllow = this.getMultiStatementAllow();
            result = result * 59 + ($multiStatementAllow == null ? 43 : ((Object)$multiStatementAllow).hashCode());
            Boolean $truncateAllow = this.getTruncateAllow();
            result = result * 59 + ($truncateAllow == null ? 43 : ((Object)$truncateAllow).hashCode());
            Boolean $commentAllow = this.getCommentAllow();
            result = result * 59 + ($commentAllow == null ? 43 : ((Object)$commentAllow).hashCode());
            Boolean $strictSyntaxCheck = this.getStrictSyntaxCheck();
            result = result * 59 + ($strictSyntaxCheck == null ? 43 : ((Object)$strictSyntaxCheck).hashCode());
            Boolean $constArithmeticAllow = this.getConstArithmeticAllow();
            result = result * 59 + ($constArithmeticAllow == null ? 43 : ((Object)$constArithmeticAllow).hashCode());
            Boolean $limitZeroAllow = this.getLimitZeroAllow();
            result = result * 59 + ($limitZeroAllow == null ? 43 : ((Object)$limitZeroAllow).hashCode());
            Boolean $describeAllow = this.getDescribeAllow();
            result = result * 59 + ($describeAllow == null ? 43 : ((Object)$describeAllow).hashCode());
            Boolean $showAllow = this.getShowAllow();
            result = result * 59 + ($showAllow == null ? 43 : ((Object)$showAllow).hashCode());
            Boolean $schemaCheck = this.getSchemaCheck();
            result = result * 59 + ($schemaCheck == null ? 43 : ((Object)$schemaCheck).hashCode());
            Boolean $tableCheck = this.getTableCheck();
            result = result * 59 + ($tableCheck == null ? 43 : ((Object)$tableCheck).hashCode());
            Boolean $functionCheck = this.getFunctionCheck();
            result = result * 59 + ($functionCheck == null ? 43 : ((Object)$functionCheck).hashCode());
            Boolean $objectCheck = this.getObjectCheck();
            result = result * 59 + ($objectCheck == null ? 43 : ((Object)$objectCheck).hashCode());
            Boolean $variantCheck = this.getVariantCheck();
            result = result * 59 + ($variantCheck == null ? 43 : ((Object)$variantCheck).hashCode());
            Boolean $mustParameterized = this.getMustParameterized();
            result = result * 59 + ($mustParameterized == null ? 43 : ((Object)$mustParameterized).hashCode());
            Boolean $doPrivilegedAllow = this.getDoPrivilegedAllow();
            result = result * 59 + ($doPrivilegedAllow == null ? 43 : ((Object)$doPrivilegedAllow).hashCode());
            String $dir = this.getDir();
            result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
            String $tenantTablePattern = this.getTenantTablePattern();
            result = result * 59 + ($tenantTablePattern == null ? 43 : $tenantTablePattern.hashCode());
            String $tenantColumn = this.getTenantColumn();
            result = result * 59 + ($tenantColumn == null ? 43 : $tenantColumn.hashCode());
            Boolean $wrapAllow = this.getWrapAllow();
            result = result * 59 + ($wrapAllow == null ? 43 : ((Object)$wrapAllow).hashCode());
            Boolean $metadataAllow = this.getMetadataAllow();
            result = result * 59 + ($metadataAllow == null ? 43 : ((Object)$metadataAllow).hashCode());
            Boolean $conditionOpXorAllow = this.getConditionOpXorAllow();
            result = result * 59 + ($conditionOpXorAllow == null ? 43 : ((Object)$conditionOpXorAllow).hashCode());
            Boolean $conditionOpBitwseAllow = this.getConditionOpBitwseAllow();
            result = result * 59 + ($conditionOpBitwseAllow == null ? 43 : ((Object)$conditionOpBitwseAllow).hashCode());
            Boolean $caseConditionConstAllow = this.getCaseConditionConstAllow();
            result = result * 59 + ($caseConditionConstAllow == null ? 43 : ((Object)$caseConditionConstAllow).hashCode());
            Boolean $completeInsertValuesCheck = this.getCompleteInsertValuesCheck();
            result = result * 59 + ($completeInsertValuesCheck == null ? 43 : ((Object)$completeInsertValuesCheck).hashCode());
            Integer $insertValuesCheckSize = this.getInsertValuesCheckSize();
            result = result * 59 + ($insertValuesCheckSize == null ? 43 : ((Object)$insertValuesCheckSize).hashCode());
            Integer $selectLimit = this.getSelectLimit();
            result = result * 59 + ($selectLimit == null ? 43 : ((Object)$selectLimit).hashCode());
            return result;
        }

        public String toString() {
            return "DruidConfig.DruidWallConfig(noneBaseStatementAllow=" + this.getNoneBaseStatementAllow() + ", callAllow=" + this.getCallAllow() + ", selectAllow=" + this.getSelectAllow() + ", selectIntoAllow=" + this.getSelectIntoAllow() + ", selectIntoOutfileAllow=" + this.getSelectIntoOutfileAllow() + ", selectWhereAlwayTrueCheck=" + this.getSelectWhereAlwayTrueCheck() + ", selectHavingAlwayTrueCheck=" + this.getSelectHavingAlwayTrueCheck() + ", selectUnionCheck=" + this.getSelectUnionCheck() + ", selectMinusCheck=" + this.getSelectMinusCheck() + ", selectExceptCheck=" + this.getSelectExceptCheck() + ", selectIntersectCheck=" + this.getSelectIntersectCheck() + ", createTableAllow=" + this.getCreateTableAllow() + ", dropTableAllow=" + this.getDropTableAllow() + ", alterTableAllow=" + this.getAlterTableAllow() + ", renameTableAllow=" + this.getRenameTableAllow() + ", hintAllow=" + this.getHintAllow() + ", lockTableAllow=" + this.getLockTableAllow() + ", startTransactionAllow=" + this.getStartTransactionAllow() + ", blockAllow=" + this.getBlockAllow() + ", conditionAndAlwayTrueAllow=" + this.getConditionAndAlwayTrueAllow() + ", conditionAndAlwayFalseAllow=" + this.getConditionAndAlwayFalseAllow() + ", conditionDoubleConstAllow=" + this.getConditionDoubleConstAllow() + ", conditionLikeTrueAllow=" + this.getConditionLikeTrueAllow() + ", selectAllColumnAllow=" + this.getSelectAllColumnAllow() + ", deleteAllow=" + this.getDeleteAllow() + ", deleteWhereAlwayTrueCheck=" + this.getDeleteWhereAlwayTrueCheck() + ", deleteWhereNoneCheck=" + this.getDeleteWhereNoneCheck() + ", updateAllow=" + this.getUpdateAllow() + ", updateWhereAlayTrueCheck=" + this.getUpdateWhereAlayTrueCheck() + ", updateWhereNoneCheck=" + this.getUpdateWhereNoneCheck() + ", insertAllow=" + this.getInsertAllow() + ", mergeAllow=" + this.getMergeAllow() + ", minusAllow=" + this.getMinusAllow() + ", intersectAllow=" + this.getIntersectAllow() + ", replaceAllow=" + this.getReplaceAllow() + ", setAllow=" + this.getSetAllow() + ", commitAllow=" + this.getCommitAllow() + ", rollbackAllow=" + this.getRollbackAllow() + ", useAllow=" + this.getUseAllow() + ", multiStatementAllow=" + this.getMultiStatementAllow() + ", truncateAllow=" + this.getTruncateAllow() + ", commentAllow=" + this.getCommentAllow() + ", strictSyntaxCheck=" + this.getStrictSyntaxCheck() + ", constArithmeticAllow=" + this.getConstArithmeticAllow() + ", limitZeroAllow=" + this.getLimitZeroAllow() + ", describeAllow=" + this.getDescribeAllow() + ", showAllow=" + this.getShowAllow() + ", schemaCheck=" + this.getSchemaCheck() + ", tableCheck=" + this.getTableCheck() + ", functionCheck=" + this.getFunctionCheck() + ", objectCheck=" + this.getObjectCheck() + ", variantCheck=" + this.getVariantCheck() + ", mustParameterized=" + this.getMustParameterized() + ", doPrivilegedAllow=" + this.getDoPrivilegedAllow() + ", dir=" + this.getDir() + ", tenantTablePattern=" + this.getTenantTablePattern() + ", tenantColumn=" + this.getTenantColumn() + ", wrapAllow=" + this.getWrapAllow() + ", metadataAllow=" + this.getMetadataAllow() + ", conditionOpXorAllow=" + this.getConditionOpXorAllow() + ", conditionOpBitwseAllow=" + this.getConditionOpBitwseAllow() + ", caseConditionConstAllow=" + this.getCaseConditionConstAllow() + ", completeInsertValuesCheck=" + this.getCompleteInsertValuesCheck() + ", insertValuesCheckSize=" + this.getInsertValuesCheckSize() + ", selectLimit=" + this.getSelectLimit() + ")";
        }
    }

    public static class DruidStatConfig {
        private Long slowSqlMillis;
        private Boolean logSlowSql;
        private Boolean mergeSql;

        public Long getSlowSqlMillis() {
            return this.slowSqlMillis;
        }

        public Boolean getLogSlowSql() {
            return this.logSlowSql;
        }

        public Boolean getMergeSql() {
            return this.mergeSql;
        }

        public DruidStatConfig setSlowSqlMillis(Long slowSqlMillis) {
            this.slowSqlMillis = slowSqlMillis;
            return this;
        }

        public DruidStatConfig setLogSlowSql(Boolean logSlowSql) {
            this.logSlowSql = logSlowSql;
            return this;
        }

        public DruidStatConfig setMergeSql(Boolean mergeSql) {
            this.mergeSql = mergeSql;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DruidStatConfig)) {
                return false;
            }
            DruidStatConfig other = (DruidStatConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$slowSqlMillis = this.getSlowSqlMillis();
            Long other$slowSqlMillis = other.getSlowSqlMillis();
            if (this$slowSqlMillis == null ? other$slowSqlMillis != null : !((Object)this$slowSqlMillis).equals(other$slowSqlMillis)) {
                return false;
            }
            Boolean this$logSlowSql = this.getLogSlowSql();
            Boolean other$logSlowSql = other.getLogSlowSql();
            if (this$logSlowSql == null ? other$logSlowSql != null : !((Object)this$logSlowSql).equals(other$logSlowSql)) {
                return false;
            }
            Boolean this$mergeSql = this.getMergeSql();
            Boolean other$mergeSql = other.getMergeSql();
            return !(this$mergeSql == null ? other$mergeSql != null : !((Object)this$mergeSql).equals(other$mergeSql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DruidStatConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $slowSqlMillis = this.getSlowSqlMillis();
            result = result * 59 + ($slowSqlMillis == null ? 43 : ((Object)$slowSqlMillis).hashCode());
            Boolean $logSlowSql = this.getLogSlowSql();
            result = result * 59 + ($logSlowSql == null ? 43 : ((Object)$logSlowSql).hashCode());
            Boolean $mergeSql = this.getMergeSql();
            result = result * 59 + ($mergeSql == null ? 43 : ((Object)$mergeSql).hashCode());
            return result;
        }

        public String toString() {
            return "DruidConfig.DruidStatConfig(slowSqlMillis=" + this.getSlowSqlMillis() + ", logSlowSql=" + this.getLogSlowSql() + ", mergeSql=" + this.getMergeSql() + ")";
        }
    }
}

