/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.hibernateplus.dao.impl;

import com.baomidou.hibernateplus.condition.SelectWrapper;
import com.baomidou.hibernateplus.condition.wrapper.Wrapper;
import com.baomidou.hibernateplus.dao.IDao;
import com.baomidou.hibernateplus.entity.Convert;
import com.baomidou.hibernateplus.entity.page.Page;
import com.baomidou.hibernateplus.utils.Assert;
import com.baomidou.hibernateplus.utils.CollectionUtils;
import com.baomidou.hibernateplus.utils.EntityInfoUtils;
import com.baomidou.hibernateplus.utils.HibernateUtils;
import com.baomidou.hibernateplus.utils.MapUtils;
import com.baomidou.hibernateplus.utils.RandomUtils;
import com.baomidou.hibernateplus.utils.ReflectionKit;
import com.baomidou.hibernateplus.utils.SqlUtils;
import com.baomidou.hibernateplus.utils.StringUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoImpl<P extends Convert>
implements IDao<P> {
    private static final Logger logger = Logger.getLogger(DaoImpl.class);

    protected SessionFactory masterSession() {
        return EntityInfoUtils.getEntityInfo(this.poClass()).getMaster();
    }

    protected SessionFactory slaveSession() {
        Set<SessionFactory> slaves = EntityInfoUtils.getEntityInfo(this.poClass()).getSlaves();
        if (CollectionUtils.isEmpty(slaves)) {
            return this.masterSession();
        }
        return RandomUtils.getRandomElement(slaves);
    }

    public P selectById(Serializable id) {
        Assert.notNull(id);
        return (P)((Convert)HibernateUtils.getSession(this.slaveSession(), this.isCurrent()).get(this.poClass(), id));
    }

    @Override
    public P get(Serializable id) {
        Assert.notNull(id);
        String primaryKey = SqlUtils.getPrimaryKey(this.poClass());
        Wrapper wrapper = SelectWrapper.instance().eq(primaryKey, id);
        return (P)this.selectOne(wrapper);
    }

    protected P get(String hql) {
        return this.get(hql, Collections.EMPTY_MAP);
    }

    protected P get(String hql, Map<String, Object> params) {
        Assert.hasLength(hql);
        Convert t = null;
        try {
            Query query = HibernateUtils.getHqlQuery(hql, this.slaveSession(), this.isCurrent());
            this.setParamMap(params, query);
            t = (Convert)query.uniqueResult();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return (P)t;
    }

    @Override
    public P save(P p) {
        Assert.notNull(p);
        HibernateUtils.getSession(this.masterSession(), this.isCurrent()).save(p);
        return p;
    }

    @Override
    public P saveOrUpdate(P p) {
        Assert.notNull(p);
        HibernateUtils.getSession(this.masterSession(), this.isCurrent()).saveOrUpdate(p);
        return p;
    }

    @Override
    public P update(P p) {
        Assert.notNull(p);
        HibernateUtils.getSession(this.masterSession(), this.isCurrent()).merge(p);
        return p;
    }

    @Override
    public int update(Wrapper wrapper) {
        Assert.notEmpty(wrapper.getSetMap());
        String sqlUpdate = SqlUtils.sqlUpdate(this.poClass(), wrapper);
        return this.executeSqlUpdate(sqlUpdate);
    }

    @Override
    public boolean delete(P p) {
        Assert.notNull(p);
        try {
            HibernateUtils.getSession(this.masterSession(), this.isCurrent()).delete(p);
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
            return false;
        }
        return true;
    }

    @Override
    public int delete(Wrapper wrapper) {
        String sqlDelete = SqlUtils.sqlDelete(this.poClass(), wrapper);
        return this.executeSqlUpdate(sqlDelete);
    }

    @Override
    public int delete(Serializable id) {
        Assert.notNull(id);
        String sqlDelete = SqlUtils.sqlDelete(this.poClass(), id);
        return this.executeSqlUpdate(sqlDelete);
    }

    @Override
    public boolean insertBatch(List<P> list, int size) {
        Assert.notEmpty(list);
        try {
            Session session = HibernateUtils.getSession(this.masterSession(), this.isCurrent());
            for (int i = 0; i < list.size(); ++i) {
                session.save(list.get(i));
                if (i % size != 0) continue;
                session.flush();
                session.clear();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
            return false;
        }
        return true;
    }

    @Override
    public boolean updateBatch(List<P> list, int size) {
        Assert.notEmpty(list);
        try {
            Session session = HibernateUtils.getSession(this.masterSession(), this.isCurrent());
            for (int i = 0; i < list.size(); ++i) {
                session.merge(list.get(i));
                if (i % size != 0) continue;
                session.flush();
                session.clear();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
            return false;
        }
        return true;
    }

    @Override
    public boolean saveOrUpdateBatch(List<P> list, int size) {
        Assert.notEmpty(list);
        try {
            Session session = HibernateUtils.getSession(this.masterSession(), this.isCurrent());
            for (int i = 0; i < list.size(); ++i) {
                session.saveOrUpdate(list.get(i));
                if (i % size != 0) continue;
                session.flush();
                session.clear();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
            return false;
        }
        return true;
    }

    @Override
    public P selectOne(Wrapper wrapper) {
        List<P> list = this.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                logger.warn((Object)String.format("Warn: selectOne Method There are  %s results.", size));
            }
            return (P)((Convert)list.get(0));
        }
        return null;
    }

    @Override
    public <P> List<P> selectList(Wrapper wrapper) {
        List list = Collections.emptyList();
        try {
            String sql = SqlUtils.sqlEntityList(this.poClass(), wrapper, null);
            Query query = HibernateUtils.getEntitySqlQuery(this.poClass(), sql, this.slaveSession(), this.isCurrent());
            list = query.list();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> selectMaps(Wrapper wrapper) {
        List list = Collections.emptyList();
        try {
            String sql = SqlUtils.sqlList(this.poClass(), wrapper, null);
            Query query = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            list = query.list();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return list;
    }

    @Override
    public int selectCount(Wrapper wrapper) {
        int count = 0;
        try {
            String sql = SqlUtils.sqlCount(this.poClass(), wrapper);
            Query query = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent());
            BigInteger bigInteger = (BigInteger)query.uniqueResult();
            count = bigInteger.intValue();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return count;
    }

    @Override
    public Page<Map<String, Object>> selectMapsPage(Wrapper wrapper, Page<Map<String, Object>> page) {
        try {
            String sql = SqlUtils.sqlList(this.poClass(), wrapper, page);
            Query query = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            HibernateUtils.setPage(page.getCurrent(), page.getSize(), query);
            page.setRecords(query.list());
            this.setPageTotal(sql, page);
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return page;
    }

    @Override
    public Page selectPage(Wrapper wrapper, Page page) {
        try {
            String sql = SqlUtils.sqlEntityList(this.poClass(), wrapper, page);
            Query query = HibernateUtils.getEntitySqlQuery(this.poClass(), sql, this.slaveSession(), this.isCurrent());
            HibernateUtils.setPage(page.getCurrent(), page.getSize(), query);
            page.setRecords(query.list());
            this.setPageTotal(sql, page);
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return page;
    }

    protected int executeHql(String hql) {
        return this.executeHql(hql, Collections.EMPTY_MAP);
    }

    protected int executeHql(String hql, Map<String, Object> params) {
        Assert.hasLength(hql);
        Query query = HibernateUtils.getHqlQuery(hql, this.masterSession(), this.isCurrent());
        this.setParamMap(params, query);
        return query.executeUpdate();
    }

    protected List<P> queryListWithHql(String hql) {
        return this.queryListWithHql(hql, Collections.EMPTY_MAP);
    }

    protected List<P> queryListWithHql(String hql, Map<String, Object> params) {
        return this.queryListWithHql(hql, params, 0, 0);
    }

    protected List<P> queryListWithHql(String hql, Map<String, Object> params, int page, int rows) {
        Assert.hasLength(hql);
        List list = Collections.emptyList();
        try {
            Query query = HibernateUtils.getHqlQuery(hql, this.slaveSession(), this.isCurrent());
            this.setParamMap(params, query);
            HibernateUtils.setPage(page, rows, query);
            list = query.list();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return list;
    }

    protected List<P> queryListWithHql(String hql, int page, int rows) {
        return this.queryListWithHql(hql, Collections.EMPTY_MAP, page, rows);
    }

    protected List<Map<String, Object>> queryMapsWithHql(String hql) {
        return this.queryMapsWithHql(hql, 0, 0);
    }

    protected List<Map<String, Object>> queryMapsWithHql(String hql, int page, int rows) {
        Assert.hasLength(hql);
        List list = Collections.emptyList();
        try {
            Query query = HibernateUtils.getHqlQuery(hql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            HibernateUtils.setPage(page, rows, query);
            list = query.list();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return list;
    }

    protected int queryCountWithHql(String hql) {
        return this.queryCountWithHql(hql, Collections.EMPTY_MAP);
    }

    protected int queryCountWithHql(String hql, Map<String, Object> params) {
        Assert.hasLength(hql);
        Query query = HibernateUtils.getHqlQuery(hql, this.slaveSession(), this.isCurrent());
        this.setParamMap(params, query);
        BigInteger bigInteger = (BigInteger)query.uniqueResult();
        return bigInteger.intValue();
    }

    protected int executeSqlUpdate(String sql) {
        return this.executeSqlUpdate(sql, Collections.EMPTY_MAP);
    }

    protected int executeSqlUpdate(String sql, Object[] args) {
        Assert.hasLength(sql);
        int resultCount = 0;
        try {
            Query query = HibernateUtils.getSqlQuery(sql, this.masterSession(), this.isCurrent());
            if (null != args) {
                for (int i = 0; i < args.length; ++i) {
                    HibernateUtils.setParams(query, StringUtils.toString(i), args[i]);
                }
            }
            resultCount = query.executeUpdate();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return resultCount;
    }

    protected int executeSqlUpdate(String sql, Map<String, Object> params) {
        Assert.hasLength(sql);
        int resultCount = 0;
        if (StringUtils.isNotBlank(sql)) {
            try {
                Query query = HibernateUtils.getSqlQuery(sql, this.masterSession(), this.isCurrent());
                this.setParamMap(params, query);
                resultCount = query.executeUpdate();
            }
            catch (Exception e) {
                logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
            }
        }
        return resultCount;
    }

    protected int queryCount(String sql) {
        return this.queryCount(sql, SelectWrapper.DEFAULT);
    }

    protected int queryCount(String sql, Wrapper wrapper) {
        Assert.hasLength(sql);
        sql = sql + wrapper.getSqlSegment();
        int count = 0;
        try {
            Query query = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent());
            BigInteger bigInteger = (BigInteger)query.uniqueResult();
            bigInteger.intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    protected Map<String, Object> queryMap(String sql, Wrapper wrapper) {
        Assert.hasLength(sql);
        Map map = Collections.emptyMap();
        try {
            sql = sql + wrapper.getSqlSegment();
            Query query = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            map = (Map)query.uniqueResult();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return map;
    }

    protected Map<String, Object> queryMap(String sql) {
        return this.queryMap(sql, SelectWrapper.DEFAULT);
    }

    protected Page<Map<String, Object>> queryMapsPage(String sql, Page page) {
        return this.queryMapsPage(sql, SelectWrapper.DEFAULT, page);
    }

    protected Page<Map<String, Object>> queryMapsPage(String sql, Wrapper wrapper, Page page) {
        Assert.hasLength(sql);
        try {
            sql = SqlUtils.sqlList(sql, wrapper, page);
            Query query = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            HibernateUtils.setPage(page.getCurrent(), page.getSize(), query);
            page.setRecords(query.list());
            this.setPageTotal(sql, page);
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return page;
    }

    protected List<Map<String, Object>> queryMaps(String sql) {
        return this.queryMaps(sql, Collections.EMPTY_MAP);
    }

    protected List<Map<String, Object>> queryMaps(String sql, Map<String, Object> params) {
        Assert.hasLength(sql);
        List list = Collections.emptyList();
        try {
            Query query = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            this.setParamMap(params, query);
            list = query.list();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return list;
    }

    protected List<Map<String, Object>> queryMaps(String sql, Wrapper wrapper) {
        Assert.hasLength(sql);
        List list = Collections.emptyList();
        try {
            sql = sql + wrapper.toString();
            Query query = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            list = query.list();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return list;
    }

    public List<Map<String, Object>> queryMaps(Map<String, Object> params) {
        List list = Collections.emptyList();
        try {
            String hql = HibernateUtils.getListHql(this.poClass(), params);
            Query query = HibernateUtils.getHqlQuery(hql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            this.setParamMap(params, query);
            list = query.list();
        }
        catch (Exception e) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + e));
        }
        return list;
    }

    private void setPageTotal(String sql, Page<?> page) {
        if (page.isSearchCount()) {
            String sqlCount = SqlUtils.sqlCountOptimize(sql);
            Query countQuery = HibernateUtils.getSqlQuery(sqlCount, this.slaveSession(), this.isCurrent());
            BigInteger bigInteger = (BigInteger)countQuery.uniqueResult();
            page.setTotal(bigInteger.intValue());
        }
    }

    private void setParamMap(Map<String, Object> params, Query query) {
        if (MapUtils.isNotEmpty(params)) {
            for (String key : params.keySet()) {
                Object obj = params.get(key);
                HibernateUtils.setParams(query, key, obj);
            }
        }
    }

    protected Class<P> poClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), 0);
    }

    protected Boolean isCurrent() {
        return true;
    }
}

