/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.hibernateplus.generator.config.builder;

import com.baomidou.hibernateplus.generator.config.DataSourceConfig;
import com.baomidou.hibernateplus.generator.config.GlobalConfig;
import com.baomidou.hibernateplus.generator.config.PackageConfig;
import com.baomidou.hibernateplus.generator.config.StrategyConfig;
import com.baomidou.hibernateplus.generator.config.TemplateConfig;
import com.baomidou.hibernateplus.generator.config.po.TableField;
import com.baomidou.hibernateplus.generator.config.po.TableInfo;
import com.baomidou.hibernateplus.generator.config.rules.DbType;
import com.baomidou.hibernateplus.generator.config.rules.NamingStrategy;
import com.baomidou.hibernateplus.generator.config.rules.QuerySQL;
import com.baomidou.hibernateplus.utils.StringUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigBuilder {
    private Connection connection;
    private QuerySQL querySQL;
    private String superModelClass;
    private String superDaoClass;
    private String superDaoImplClass;
    private String superServiceClass;
    private String superServiceImplClass;
    private String superControllerClass;
    private List<TableInfo> tableInfoList;
    private Map<String, String> packageInfo;
    private Map<String, String> pathInfo;
    private TemplateConfig template;
    private StrategyConfig strategyConfig;
    private GlobalConfig globalConfig;

    public ConfigBuilder(PackageConfig packageConfig, DataSourceConfig dataSourceConfig, StrategyConfig strategyConfig, TemplateConfig template, GlobalConfig globalConfig) {
        this.globalConfig = null == globalConfig ? new GlobalConfig() : globalConfig;
        if (null == packageConfig) {
            this.handlerPackage(this.globalConfig.getOutputDir(), new PackageConfig());
        } else {
            this.handlerPackage(this.globalConfig.getOutputDir(), packageConfig);
        }
        this.handlerDataSource(dataSourceConfig);
        this.strategyConfig = null == strategyConfig ? new StrategyConfig() : strategyConfig;
        this.handlerStrategy(this.strategyConfig);
        this.template = null == template ? new TemplateConfig() : template;
    }

    public Map<String, String> getPackageInfo() {
        return this.packageInfo;
    }

    public Map<String, String> getPathInfo() {
        return this.pathInfo;
    }

    public String getSuperModelClass() {
        return this.superModelClass;
    }

    public String getSuperDaoClass() {
        return this.superDaoClass;
    }

    public String getSuperDaoImplClass() {
        return this.superDaoImplClass;
    }

    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    public String getSuperControllerClass() {
        return this.superControllerClass;
    }

    public List<TableInfo> getTableInfoList() {
        return this.tableInfoList;
    }

    public TemplateConfig getTemplate() {
        return this.template == null ? new TemplateConfig() : this.template;
    }

    private void handlerPackage(String outputDir, PackageConfig config) {
        this.packageInfo = new HashMap<String, String>();
        this.packageInfo.put("ModuleName", config.getModuleName());
        this.packageInfo.put("PO", this.joinPackage(config.getParent(), config.getPo()));
        this.packageInfo.put("VO", this.joinPackage(config.getParent(), config.getVo()));
        this.packageInfo.put("Dao", this.joinPackage(config.getParent(), config.getDao()));
        this.packageInfo.put("DaoImpl", this.joinPackage(config.getParent(), config.getDaoImpl()));
        this.packageInfo.put("Service", this.joinPackage(config.getParent(), config.getService()));
        this.packageInfo.put("ServiceImpl", this.joinPackage(config.getParent(), config.getServiceImpl()));
        this.packageInfo.put("Controller", this.joinPackage(config.getParent(), config.getController()));
        this.pathInfo = new HashMap<String, String>();
        this.pathInfo.put("po_path", this.joinPath(outputDir, this.packageInfo.get("PO")));
        this.pathInfo.put("vo_path", this.joinPath(outputDir, this.packageInfo.get("VO")));
        this.pathInfo.put("dao_path", this.joinPath(outputDir, this.packageInfo.get("Dao")));
        this.pathInfo.put("daoimpl_path", this.joinPath(outputDir, this.packageInfo.get("DaoImpl")));
        this.pathInfo.put("serivce_path", this.joinPath(outputDir, this.packageInfo.get("Service")));
        this.pathInfo.put("serviceimpl_path", this.joinPath(outputDir, this.packageInfo.get("ServiceImpl")));
        this.pathInfo.put("controller_path", this.joinPath(outputDir, this.packageInfo.get("Controller")));
    }

    private void handlerDataSource(DataSourceConfig config) {
        this.connection = config.getConn();
        this.querySQL = this.getQuerySQL(config.getDbType());
    }

    private void handlerStrategy(StrategyConfig config) {
        this.processTypes(config);
        this.tableInfoList = this.getTablesInfo(config);
    }

    private void processTypes(StrategyConfig config) {
        this.superServiceClass = StringUtils.isBlank(config.getSuperServiceClass()) ? "com.baomidou.hibernateplus.service.IService" : config.getSuperServiceClass();
        this.superServiceImplClass = StringUtils.isBlank(config.getSuperServiceImplClass()) ? "com.baomidou.hibernateplus.service.impl.ServiceImpl" : config.getSuperServiceImplClass();
        this.superDaoClass = StringUtils.isBlank(config.getSuperDaoClass()) ? "com.baomidou.hibernateplus.dao.IDao" : config.getSuperDaoClass();
        this.superDaoImplClass = StringUtils.isBlank(config.getSuperDaoImplClass()) ? "com.baomidou.hibernateplus.dao.impl.DaoImpl" : config.getSuperDaoImplClass();
        this.superModelClass = config.getSuperModelClass();
        this.superControllerClass = config.getSuperControllerClass();
    }

    private List<TableInfo> processTable(List<TableInfo> tableList, NamingStrategy strategy, String tablePrefix) {
        for (TableInfo tableInfo : tableList) {
            tableInfo.setPoName(NamingStrategy.capitalFirst(this.processName(tableInfo.getName(), strategy, tablePrefix)));
            tableInfo.setVoName(NamingStrategy.capitalFirst(this.processName(tableInfo.getName(), strategy, tablePrefix)));
            if (StringUtils.isNotBlank(this.globalConfig.getDaoName())) {
                tableInfo.setDaoName(String.format(this.globalConfig.getDaoName(), tableInfo.getPoName()));
            } else {
                tableInfo.setDaoName(tableInfo.getPoName() + "Dao");
            }
            if (StringUtils.isNotBlank(this.globalConfig.getDaoImplName())) {
                tableInfo.setDaoImplName(String.format(this.globalConfig.getDaoImplName(), tableInfo.getPoName()));
            } else {
                tableInfo.setDaoImplName(tableInfo.getPoName() + "DaoImpl");
            }
            if (StringUtils.isNotBlank(this.globalConfig.getServiceName())) {
                tableInfo.setServiceName(String.format(this.globalConfig.getServiceName(), tableInfo.getPoName()));
            } else {
                tableInfo.setServiceName(tableInfo.getPoName() + "Service");
            }
            if (StringUtils.isNotBlank(this.globalConfig.getServiceImplName())) {
                tableInfo.setServiceImplName(String.format(this.globalConfig.getServiceImplName(), tableInfo.getPoName()));
            } else {
                tableInfo.setServiceImplName(tableInfo.getPoName() + "ServiceImpl");
            }
            if (StringUtils.isNotBlank(this.globalConfig.getControllerName())) {
                tableInfo.setControllerName(String.format(this.globalConfig.getControllerName(), tableInfo.getPoName()));
            } else {
                tableInfo.setControllerName(tableInfo.getPoName() + "Controller");
            }
            if (StringUtils.isNotBlank(this.globalConfig.getPoName())) {
                tableInfo.setPoName(String.format(this.globalConfig.getPoName(), tableInfo.getPoName()));
            } else {
                tableInfo.setPoName(tableInfo.getPoName() + "PO");
            }
            if (StringUtils.isNotBlank(this.globalConfig.getVoName())) {
                tableInfo.setVoName(String.format(this.globalConfig.getVoName(), tableInfo.getPoName()));
                continue;
            }
            tableInfo.setVoName(tableInfo.getPoName() + "VO");
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableInfo> getTablesInfo(StrategyConfig config) {
        boolean isExclude;
        boolean isInclude = null != config.getInclude() && config.getInclude().length > 0;
        boolean bl = isExclude = null != config.getExclude() && config.getExclude().length > 0;
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> \u6807\u7b7e\u4e2d <include> \u4e0e <exclude> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        HashSet<String> notExistTables = new HashSet<String>();
        NamingStrategy strategy = config.getNaming();
        NamingStrategy fieldStrategy = config.getFieldNaming();
        PreparedStatement pstate = null;
        try {
            pstate = this.connection.prepareStatement(this.querySQL.getTableCommentsSql());
            ResultSet results = pstate.executeQuery();
            while (results.next()) {
                String tableName = results.getString(this.querySQL.getTableName());
                if (StringUtils.isNotBlank(tableName)) {
                    String tableComment = results.getString(this.querySQL.getTableComment());
                    TableInfo tableInfo = new TableInfo();
                    if (isInclude) {
                        for (String includeTab : config.getInclude()) {
                            if (includeTab.equalsIgnoreCase(tableName)) {
                                tableInfo.setName(tableName);
                                tableInfo.setComment(tableComment);
                                continue;
                            }
                            notExistTables.add(includeTab);
                        }
                    } else if (isExclude) {
                        for (String excludeTab : config.getExclude()) {
                            if (!excludeTab.equalsIgnoreCase(tableName)) {
                                tableInfo.setName(tableName);
                                tableInfo.setComment(tableComment);
                                continue;
                            }
                            notExistTables.add(excludeTab);
                        }
                    } else {
                        tableInfo.setName(tableName);
                        tableInfo.setComment(tableComment);
                    }
                    if (!StringUtils.isNotBlank(tableInfo.getName())) continue;
                    List<TableField> fieldList = this.getListFields(tableInfo.getName(), fieldStrategy);
                    tableInfo.setFields(fieldList);
                    tableList.add(tableInfo);
                    continue;
                }
                System.err.println("\u5f53\u524d\u6570\u636e\u5e93\u4e3a\u7a7a\uff01\uff01\uff01");
            }
            for (TableInfo tabInfo : tableList) {
                notExistTables.remove(tabInfo.getName());
            }
            if (notExistTables.size() > 0) {
                System.err.println("\u8868 " + notExistTables + " \u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (pstate != null) {
                    pstate.close();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.processTable(tableList, strategy, config.getTablePrefix());
    }

    private List<TableField> getListFields(String tableName, NamingStrategy strategy) throws SQLException {
        boolean havedId = false;
        PreparedStatement pstate = this.connection.prepareStatement(String.format(this.querySQL.getTableFieldsSql(), tableName));
        ResultSet results = pstate.executeQuery();
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        while (results.next()) {
            boolean isId;
            TableField field = new TableField();
            String key = results.getString(this.querySQL.getFieldKey());
            boolean bl = isId = StringUtils.isNotBlank(key) && key.toUpperCase().equals("PRI");
            if (isId && !havedId) {
                field.setKeyFlag(true);
                havedId = true;
            } else {
                field.setKeyFlag(false);
            }
            field.setName(results.getString(this.querySQL.getFieldName()));
            if (this.strategyConfig.includeSuperModelColumns(field.getName())) continue;
            field.setType(results.getString(this.querySQL.getFieldType()));
            field.setPropertyName(this.processName(field.getName(), strategy));
            field.setPropertyType(this.processFiledType(field.getType()));
            field.setComment(results.getString(this.querySQL.getFieldComment()));
            fieldList.add(field);
        }
        return fieldList;
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank(parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith(parentDir, File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String joinPackage(String parent, String subPackage) {
        if (StringUtils.isBlank(parent)) {
            return subPackage;
        }
        return parent + "." + subPackage;
    }

    private String processFiledType(String type) {
        if (QuerySQL.MYSQL == this.querySQL) {
            return this.processMySqlType(type);
        }
        if (QuerySQL.ORACLE == this.querySQL) {
            return this.processOracleType(type);
        }
        return null;
    }

    private String processName(String name, NamingStrategy strategy) {
        return this.processName(name, strategy, null);
    }

    private String processName(String name, NamingStrategy strategy, String tablePrefix) {
        String propertyName = "";
        propertyName = strategy == NamingStrategy.remove_prefix_and_camel ? NamingStrategy.removePrefixAndCamel(name, tablePrefix) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel(name) : (strategy == NamingStrategy.remove_prefix ? NamingStrategy.removePrefix(name, tablePrefix) : name));
        return propertyName;
    }

    private String processMySqlType(String type) {
        String t = type.toLowerCase();
        if (t.contains("char") || t.contains("text")) {
            return "String";
        }
        if (t.contains("bigint")) {
            return "Long";
        }
        if (t.contains("int")) {
            return "Integer";
        }
        if (t.contains("date") || t.contains("time") || t.contains("year")) {
            return "Date";
        }
        if (t.contains("text")) {
            return "String";
        }
        if (t.contains("bit")) {
            return "Boolean";
        }
        if (t.contains("decimal")) {
            return "BigDecimal";
        }
        if (t.contains("blob")) {
            return "byte[]";
        }
        if (t.contains("float")) {
            return "Float";
        }
        if (t.contains("double")) {
            return "Double";
        }
        if (t.contains("json") || t.contains("enum")) {
            return "String";
        }
        return "String";
    }

    private String processOracleType(String type) {
        String t = type.toUpperCase();
        if (t.contains("CHAR")) {
            return "String";
        }
        if (t.contains("DATE") || t.contains("TIMESTAMP")) {
            return "Date";
        }
        if (t.contains("NUMBER")) {
            if (t.matches("NUMBER\\(+\\d{1}+\\)")) {
                return "Integer";
            }
            if (t.matches("NUMBER\\(+\\d{2}+\\)")) {
                return "Long";
            }
            return "Double";
        }
        if (t.contains("FLOAT")) {
            return "Float";
        }
        if (t.contains("BLOB")) {
            return "Object";
        }
        if (t.contains("RAW")) {
            return "byte[]";
        }
        return "String";
    }

    private QuerySQL getQuerySQL(DbType dbType) {
        for (QuerySQL qs : QuerySQL.values()) {
            if (!qs.getDbType().equals(dbType.getValue())) continue;
            return qs;
        }
        return QuerySQL.MYSQL;
    }

    public StrategyConfig getStrategyConfig() {
        return this.strategyConfig;
    }

    public void setStrategyConfig(StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }
}

