/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.hibernateplus.utils;

import com.baomidou.hibernateplus.enums.SQLlikeType;
import com.baomidou.hibernateplus.utils.ArrayUtils;
import com.baomidou.hibernateplus.utils.StringEscape;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final char UNDERLINE = '_';
    public static final String EMPTY = "";
    public static final String PLACE_HOLDER = "{%s}";

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        return !StringUtils.isAnyBlank(css);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtils.isBlank(cs)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static String camelToUnderline(String param) {
        if (StringUtils.isBlank(param)) {
            return EMPTY;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (StringUtils.isBlank(param)) {
            return EMPTY;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(String str) {
        return StringUtils.match("^[A-Z]+$", str);
    }

    public static boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static String sqlArgsFill(String content, Object ... args) {
        int length;
        if (null == content) {
            return null;
        }
        if (args != null && (length = args.length) >= 1) {
            for (int i = 0; i < length; ++i) {
                content = Pattern.compile(String.format(PLACE_HOLDER, i), 16).matcher(content).replaceAll(StringUtils.sqlParam(args[i]));
            }
        }
        return content;
    }

    public static String sqlParam(Object obj) {
        String repStr = obj instanceof Collection ? StringUtils.quotaMarkList((Collection)obj) : StringUtils.quotaMark(obj);
        return repStr;
    }

    public static String quotaMark(Object obj) {
        String srcStr = String.valueOf(obj);
        if (obj instanceof String) {
            return StringEscape.escapeString(srcStr);
        }
        return srcStr;
    }

    public static String quotaMarkList(Collection<?> coll) {
        StringBuilder sqlBuild = new StringBuilder();
        sqlBuild.append("(");
        int _size = coll.size();
        int i = 0;
        Iterator<?> iterator = coll.iterator();
        while (iterator.hasNext()) {
            String tempVal = StringUtils.quotaMark(iterator.next());
            if (i + 1 == _size) {
                sqlBuild.append(tempVal);
            } else {
                sqlBuild.append(tempVal);
                sqlBuild.append(",");
            }
            ++i;
        }
        sqlBuild.append(")");
        return sqlBuild.toString();
    }

    public static String concatCapitalize(String concatStr, String str) {
        int strLen;
        if (StringUtils.isBlank(concatStr)) {
            concatStr = EMPTY;
        }
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        return new StringBuilder(strLen).append(concatStr).append(Character.toTitleCase(firstChar)).append(str.substring(1)).toString();
    }

    public static String capitalize(String str) {
        return StringUtils.concatCapitalize(null, str);
    }

    public static boolean checkValNotNull(Object object) {
        if (object instanceof CharSequence) {
            return StringUtils.isNotBlank((CharSequence)object);
        }
        return object != null;
    }

    public static boolean checkValNull(Object object) {
        return !StringUtils.checkValNotNull(object);
    }

    public static String toString(Object obj) {
        return StringUtils.toString(obj, EMPTY);
    }

    public static String toString(Object obj, String defaults) {
        return obj == null ? defaults : (EMPTY.equals(obj.toString().trim()) ? defaults : obj.toString().trim());
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static boolean endsWith(String str, String suffix) {
        return StringUtils.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return StringUtils.endsWith(str, suffix, true);
    }

    private static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static String concatLike(String str, SQLlikeType type) {
        switch (type) {
            case LEFT: {
                str = "%" + str;
                break;
            }
            case RIGHT: {
                str = str + "%";
                break;
            }
            default: {
                str = "%" + str + "%";
            }
        }
        return StringEscape.escapeString(str);
    }
}

