/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.lock.executor;

import com.baomidou.lock.executor.AbstractLockExecutor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonLockExecutor
extends AbstractLockExecutor<RLock> {
    private static final Logger log = LoggerFactory.getLogger(RedissonLockExecutor.class);
    private final RedissonClient redissonClient;

    public RLock acquire(String lockKey, String lockValue, long expire, long acquireTimeout) {
        try {
            RLock lockInstance = this.redissonClient.getLock(lockKey);
            boolean locked = lockInstance.tryLock(acquireTimeout, expire, TimeUnit.MILLISECONDS);
            return (RLock)this.obtainLockInstance(locked, lockInstance);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public boolean releaseLock(String key, String value, RLock lockInstance) {
        if (lockInstance.isHeldByCurrentThread()) {
            try {
                return (Boolean)lockInstance.forceUnlockAsync().get();
            }
            catch (InterruptedException | ExecutionException e) {
                return false;
            }
        }
        return false;
    }

    public RedissonLockExecutor(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

