/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;

public class OptimisticLockerInnerInterceptor
implements InnerInterceptor {
    private RuntimeException exception;

    public void setException(RuntimeException exception) {
        this.exception = exception;
    }

    @Override
    public void beforeUpdate(Executor executor, MappedStatement ms, Object parameter) throws SQLException {
        if (SqlCommandType.UPDATE != ms.getSqlCommandType()) {
            return;
        }
        if (parameter instanceof Map) {
            Map map = (Map)parameter;
            this.doOptimisticLocker(map, ms.getId());
        }
    }

    protected void doOptimisticLocker(Map<String, Object> map, String msId) {
        Object et = map.getOrDefault("et", null);
        if (et != null) {
            String methodName = msId.substring(msId.lastIndexOf(".") + 1);
            TableInfo tableInfo = TableInfoHelper.getTableInfo(et.getClass());
            if (tableInfo == null || !tableInfo.isWithVersion()) {
                return;
            }
            try {
                TableFieldInfo fieldInfo = tableInfo.getVersionFieldInfo();
                Field versionField = fieldInfo.getField();
                Object originalVersionVal = versionField.get(et);
                if (originalVersionVal == null) {
                    if (null != this.exception) {
                        throw this.exception;
                    }
                    return;
                }
                String versionColumn = fieldInfo.getColumn();
                Object updatedVersionVal = this.getUpdatedVersionVal(fieldInfo.getPropertyType(), originalVersionVal);
                if ("update".equals(methodName)) {
                    AbstractWrapper aw = map.getOrDefault("ew", null);
                    if (aw == null) {
                        UpdateWrapper uw = new UpdateWrapper();
                        uw.eq((Object)versionColumn, originalVersionVal);
                        map.put("ew", uw);
                    } else {
                        aw.apply(versionColumn + " = {0}", new Object[]{originalVersionVal});
                    }
                } else {
                    map.put("MP_OPTLOCK_VERSION_ORIGINAL", originalVersionVal);
                }
                versionField.set(et, updatedVersionVal);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.mpe((Throwable)e);
            }
        }
    }

    protected Object getUpdatedVersionVal(Class<?> clazz, Object originalVersionVal) {
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return (Long)originalVersionVal + 1L;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return (Integer)originalVersionVal + 1;
        }
        if (Date.class.equals(clazz)) {
            return new Date();
        }
        if (Timestamp.class.equals(clazz)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (LocalDateTime.class.equals(clazz)) {
            return LocalDateTime.now();
        }
        return originalVersionVal;
    }
}

