/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.autoconfigure;

import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Lazy
@ConditionalOnClass(value={InetUtils.class})
@ConditionalOnBean(value={InetUtils.class})
@Configuration(proxyBeanMethods=false)
public class IdentifierGeneratorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public IdentifierGenerator identifierGenerator(InetUtils inetUtils) {
        try {
            return new DefaultIdentifierGenerator(inetUtils.findFirstNonLoopbackAddress());
        }
        catch (Exception e) {
            Log log = LogFactory.getLog(IdentifierGeneratorAutoConfiguration.class);
            return DefaultIdentifierGenerator.getFixedIdentifierGenerator((Log)log);
        }
    }
}

