/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit;

import com.cat2bug.junit.annotation.AutoTestScan;
import com.cat2bug.junit.clazz.SpringControllerTestClassFactory;
import com.cat2bug.junit.listener.Cat2BugRunListener;
import com.cat2bug.junit.service.CompileClassResultService;
import com.cat2bug.junit.service.ParameterService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.RunnerBuilder;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

@RunWith(value=Suite.class)
public class Cat2BugAutoSpringSuite
extends Suite {
    private static final Log log = LogFactory.getLog(Cat2BugAutoSpringSuite.class);
    private static Class<?>[] testClasses = null;
    private static SpringControllerTestClassFactory controllerScriptFactory = new SpringControllerTestClassFactory();
    private Class<?> klass;

    public Cat2BugAutoSpringSuite(Class<?> klass, RunnerBuilder builder) throws Exception {
        super(builder, klass, (Class[])Cat2BugAutoSpringSuite.createTestControllerProxyClasses(klass));
        this.klass = klass;
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        notifier.addListener((RunListener)new Cat2BugRunListener(this.klass));
    }

    private static Class<?>[] createTestControllerProxyClasses(Class<?> testCaseClass) throws Exception {
        if (testClasses == null) {
            AutoTestScan atc = testCaseClass.getAnnotation(AutoTestScan.class);
            String scanPackage = atc == null || atc.packageName() == null ? "" : atc.packageName();
            Set<Class<?>> controllerClasses = Cat2BugAutoSpringSuite.scanControllerClass(scanPackage);
            ParameterService.getInstance().addParameterCreateClass(testCaseClass, (String[])controllerClasses.stream().map(item -> item.getName() + "Test").toArray(String[]::new));
            ArrayList proxyClasses = new ArrayList();
            for (Class<?> clazz : controllerClasses) {
                try {
                    Class<?> ctlClass = Cat2BugAutoSpringSuite.createProxyClass(testCaseClass, clazz);
                    proxyClasses.add(ctlClass);
                    CompileClassResultService.addSuccessClass(clazz);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CompileClassResultService.addFailClass(clazz, e);
                }
            }
            testClasses = proxyClasses.toArray(new Class[0]);
        }
        return testClasses;
    }

    private static Class<?> createProxyClass(Class<?> testCaseClass, Class<?> destTestClass) throws Exception {
        Class<?> clazz = controllerScriptFactory.createTestClass(testCaseClass, destTestClass);
        return clazz;
    }

    private static Set<Class<?>> scanControllerClass(String scanPackage) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Controller.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RestController.class));
        HashSet clazzs = new HashSet();
        provider.findCandidateComponents(scanPackage).forEach(beanDefinition -> {
            try {
                clazzs.add(Class.forName(beanDefinition.getBeanClassName()));
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e);
            }
        });
        return clazzs;
    }
}

