/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.clazz;

import com.cat2bug.junit.clazz.AbstractTestClassDecorator;
import com.cat2bug.junit.clazz.ITestClassFactory;
import com.cat2bug.junit.util.JavassistUtils;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;

public class AddAnnotationOfTestClass
extends AbstractTestClassDecorator {
    private Class<? extends java.lang.annotation.Annotation> annotationClass;
    private Map<String, Object> params;

    public AddAnnotationOfTestClass(ITestClassFactory factory, Class<? extends java.lang.annotation.Annotation> annotationClass) {
        this(factory, annotationClass, null);
    }

    public AddAnnotationOfTestClass(ITestClassFactory factory, Class<? extends java.lang.annotation.Annotation> annotationClass, Map<String, Object> params) {
        super(factory);
        this.annotationClass = annotationClass;
        this.params = params;
    }

    @Override
    public CtClass createTestClass(Class<?> clazz) throws Exception {
        CtClass ctClass = super.createTestClass(clazz);
        ClassFile classFile = ctClass.getClassFile();
        ConstPool constpool = classFile.getConstPool();
        AnnotationsAttribute attr = null;
        List attrs = classFile.getAttributes();
        for (Object ai : attrs) {
            if (!(ai instanceof AnnotationsAttribute)) continue;
            attr = (AnnotationsAttribute)ai;
            break;
        }
        if (attr == null) {
            attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
        }
        Annotation annotation = new Annotation(this.annotationClass.getName(), constpool);
        if (this.params != null && this.params.size() > 0) {
            for (Map.Entry entry : this.params.entrySet()) {
                if (entry.getValue().getClass().isArray()) {
                    int len = Array.getLength(entry.getValue());
                    MemberValue[] mvs = new MemberValue[len];
                    for (int i = 0; i < len; ++i) {
                        mvs[i] = JavassistUtils.obj2MemberObj(entry.getValue(), constpool);
                    }
                    ArrayMemberValue amv = new ArrayMemberValue(constpool);
                    amv.setValue(mvs);
                    annotation.addMemberValue((String)entry.getKey(), (MemberValue)amv);
                    continue;
                }
                MemberValue obj = JavassistUtils.obj2MemberObj(entry.getValue(), constpool);
                annotation.addMemberValue((String)entry.getKey(), obj);
            }
        }
        try {
            attr.addAnnotation(annotation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        classFile.addAttribute((AttributeInfo)attr);
        return ctClass;
    }
}

