/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.clazz;

import com.cat2bug.junit.clazz.AbstractAddMethodOfTestClass;
import com.cat2bug.junit.clazz.ITestClassFactory;
import com.cat2bug.junit.service.ParameterService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;

public class AddArgeMethodOfTestClass
extends AbstractAddMethodOfTestClass {
    ClassPool pool = ClassPool.getDefault();
    private Class<?> srcClass;
    private String proxyClassName;
    private String srcMethodName;
    private String parameterName;
    private CtClass paramType;
    private Object[] pramAnnotations;

    public AddArgeMethodOfTestClass(ITestClassFactory factory, String name, Class<?> srcClass, String proxyClassName, Method srcMethod, String parameterName, CtClass paramType, Object[] pramAnnotations) throws Exception {
        super(factory, name, null, null, paramType);
        this.srcClass = srcClass;
        this.proxyClassName = proxyClassName;
        this.srcMethodName = srcMethod.getName();
        this.parameterName = parameterName;
        this.paramType = paramType;
        this.pramAnnotations = pramAnnotations;
    }

    @Override
    public CtClass getReturnClasses() throws ClassNotFoundException, NotFoundException {
        return this.pool.get("java.lang.Object");
    }

    @Override
    public String body(CtClass ctClass) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Method testCaseMethod = ParameterService.getInstance().getTestCaseMethod(this.srcClass.getName(), this.proxyClassName, this.srcMethodName, this.parameterName, this.paramType.getName());
        if (testCaseMethod == null) {
            String paramTypeName = this.paramType.getName();
            sb.append(String.format("java.lang.Class paramCls = com.cat2bug.junit.service.ParameterService.getInstance().stringToClass(\"%s\");", paramTypeName));
            sb.append("return com.cat2bug.junit.service.ParameterService.getInstance().createParameterRandomValue(paramCls);");
        } else {
            CtClass srcClass = this.pool.getCtClass(testCaseMethod.getDeclaringClass().getName());
            CtMethod srcMethod = srcClass.getDeclaredMethod(testCaseMethod.getName());
            MethodInfo methodInfo = srcMethod.getMethodInfo();
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            if (codeAttribute != null) {
                LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
                int paramLen = srcMethod.getParameterTypes().length;
                Object[][] ans = srcMethod.getParameterAnnotations();
                int pos = Modifier.isStatic((int)srcMethod.getModifiers()) ? 0 : 1;
                ArrayList<String> paramList = new ArrayList<String>();
                for (int i = 0; i < paramLen; ++i) {
                    String paramName = attr.variableName(i + pos);
                    String paramType = srcMethod.getParameterTypes()[i].getName();
                    paramList.add(paramName);
                    sb.append(String.format("%s %s = webContext.getBean(%s.class);", paramType, paramName, paramType));
                }
                String methodName = "src" + this.name;
                CtMethod newMethod = CtNewMethod.copy((CtMethod)srcMethod, (String)methodName, (CtClass)ctClass, null);
                ctClass.addMethod(newMethod);
                switch (testCaseMethod.getReturnType().getName()) {
                    case "long": {
                        sb.append(String.format("return java.lang.Long.valueOf(this.%s(%s));", methodName, paramList.stream().collect(Collectors.joining(","))));
                        break;
                    }
                    case "int": {
                        sb.append(String.format("return java.lang.Integer.valueOf(this.%s(%s));", methodName, paramList.stream().collect(Collectors.joining(","))));
                        break;
                    }
                    case "short": {
                        sb.append(String.format("return java.lang.Short.valueOf(this.%s(%s));", methodName, paramList.stream().collect(Collectors.joining(","))));
                        break;
                    }
                    case "double": {
                        sb.append(String.format("return java.lang.Double.valueOf(this.%s(%s));", methodName, paramList.stream().collect(Collectors.joining(","))));
                        break;
                    }
                    case "float": {
                        sb.append(String.format("return java.lang.float.valueOf(this.%s(%s));", methodName, paramList.stream().collect(Collectors.joining(","))));
                        break;
                    }
                    case "chat": {
                        sb.append(String.format("return java.lang.Character.valueOf(this.%s(%s));", methodName, paramList.stream().collect(Collectors.joining(","))));
                        break;
                    }
                    case "boolean": {
                        sb.append(String.format("return java.lang.Boolean.valueOf(this.%s(%s));", methodName, paramList.stream().collect(Collectors.joining(","))));
                        break;
                    }
                    default: {
                        sb.append(String.format("return (%s)this.%s(%s);", this.paramType.getName(), methodName, paramList.stream().collect(Collectors.joining(","))));
                    }
                }
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static CtClass toCtClass(String clazzName) throws Exception {
        ClassPool cp = ClassPool.getDefault();
        switch (clazzName) {
            case "int": {
                return CtClass.intType;
            }
            case "long": {
                return CtClass.longType;
            }
            case "short": {
                return CtClass.shortType;
            }
            case "double": {
                return CtClass.doubleType;
            }
            case "float": {
                return CtClass.floatType;
            }
            case "boolean": {
                return CtClass.booleanType;
            }
            case "char": {
                return CtClass.charType;
            }
        }
        return cp.getCtClass(clazzName);
    }
}

