/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.clazz;

import com.cat2bug.junit.clazz.AbstractTestClassDecorator;
import com.cat2bug.junit.clazz.ITestClassFactory;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;

public class CopyFiledOfTestClass
extends AbstractTestClassDecorator {
    private CtField field;
    private Class<?> testCaseClass;

    public CopyFiledOfTestClass(ITestClassFactory factory, Class<?> testCaseClass, CtField field) {
        super(factory);
        this.field = field;
        this.testCaseClass = testCaseClass;
    }

    @Override
    public CtClass createTestClass(Class<?> clazz) throws Exception {
        CtClass ctClass = super.createTestClass(clazz);
        CtField copiedField = new CtField(this.field.getType(), this.field.getName(), ctClass);
        copiedField.setModifiers(this.field.getModifiers());
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)this.field.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute != null) {
            copiedField.getFieldInfo().addAttribute(annotationsAttribute.copy(copiedField.getFieldInfo().getConstPool(), null));
        }
        ctClass.addField(copiedField);
        return ctClass;
    }

    private static String getDefaultInitValue(CtField field) {
        try {
            CtClass fieldType = field.getType();
            if (fieldType.equals(CtClass.booleanType)) {
                return "false";
            }
            if (fieldType.equals(CtClass.byteType) || fieldType.equals(CtClass.shortType) || fieldType.equals(CtClass.intType) || fieldType.equals(CtClass.longType) || fieldType.equals(CtClass.floatType) || fieldType.equals(CtClass.doubleType)) {
                return "0";
            }
            if (fieldType.equals(CtClass.charType)) {
                return "'\\u0000'";
            }
            return "null";
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            return "null";
        }
    }
}

