/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.clazz;

import com.cat2bug.junit.Cat2BugSpringAutoRunner;
import com.cat2bug.junit.annotation.Authentication;
import com.cat2bug.junit.annotation.Copy;
import com.cat2bug.junit.clazz.AbstractAddConstructorOfTestClass;
import com.cat2bug.junit.clazz.AbstractAddMethodOfTestClass;
import com.cat2bug.junit.clazz.AddAnnotationOfTestClass;
import com.cat2bug.junit.clazz.AddArgeMethodOfTestClass;
import com.cat2bug.junit.clazz.AddFieldOfTestClass;
import com.cat2bug.junit.clazz.AddHttpDeleteOfTestMethod;
import com.cat2bug.junit.clazz.AddHttpGetOfTestMethod;
import com.cat2bug.junit.clazz.AddHttpPostOfTestMethod;
import com.cat2bug.junit.clazz.AddHttpPutOfTestMethod;
import com.cat2bug.junit.clazz.CopyFiledOfTestClass;
import com.cat2bug.junit.clazz.CopyMethodOfTestClass;
import com.cat2bug.junit.clazz.ITestClassFactory;
import com.cat2bug.junit.clazz.TestClassFactory;
import com.cat2bug.junit.service.ParameterService;
import com.cat2bug.junit.util.ParamMethodUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.apache.commons.logging.Log;
import org.junit.Test;
import org.junit.platform.commons.util.StringUtils;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;

public class SpringControllerTestClassFactory {
    ClassPool pool = ClassPool.getDefault();

    public Class<?> createTestClass(Class<?> testCaseClass, Class<?> clazz) throws Exception {
        Authentication auth;
        Annotation[] anns;
        String proxyClassName = clazz.getSimpleName() + "Test";
        String packageName = clazz.getPackage().getName();
        final String longProxyClassName = packageName + "." + proxyClassName;
        ITestClassFactory factory = new TestClassFactory(proxyClassName, packageName);
        HashMap<String, Object> runWithParams = new HashMap<String, Object>();
        runWithParams.put("value", Cat2BugSpringAutoRunner.class);
        factory = new AddAnnotationOfTestClass(factory, RunWith.class, runWithParams);
        for (Annotation ann : anns = testCaseClass.getAnnotations()) {
            Method[] annMethods;
            if (ann instanceof RunWith) continue;
            HashMap<String, Object> annParams = new HashMap<String, Object>();
            for (Method annMethod : annMethods = ann.annotationType().getDeclaredMethods()) {
                Object retAnnValue = annMethod.invoke((Object)ann, new Object[0]);
                annParams.put(annMethod.getName(), retAnnValue);
            }
            factory = new AddAnnotationOfTestClass(factory, ann.annotationType(), annParams);
        }
        SpringBootTest springBootTest = testCaseClass.getAnnotation(SpringBootTest.class);
        if (springBootTest == null) {
            factory = new AddAnnotationOfTestClass(factory, SpringBootTest.class);
        }
        if (testCaseClass.getAnnotation(WebAppConfiguration.class) == null && springBootTest.webEnvironment() == SpringBootTest.WebEnvironment.MOCK) {
            factory = new AddAnnotationOfTestClass(factory, WebAppConfiguration.class);
        }
        factory = new AddFieldOfTestClass(factory, Log.class, "log");
        HashMap<Class<? extends Annotation>, Map<String, Object>> webContextAnnotationParams = new HashMap<Class<? extends Annotation>, Map<String, Object>>();
        webContextAnnotationParams.put(Autowired.class, null);
        factory = new AddFieldOfTestClass(factory, WebApplicationContext.class, "webContext", webContextAnnotationParams);
        factory = new AddFieldOfTestClass(factory, MockMvc.class, "mock");
        factory = new AbstractAddConstructorOfTestClass(factory){

            @Override
            public String body() {
                return "{ this.log=org.apache.commons.logging.LogFactory.getLog(\"" + longProxyClassName + "\"); }";
            }
        };
        HashMap<Class<Autowired>, Object> beforeAnnotationParams = new HashMap<Class<Autowired>, Object>();
        beforeAnnotationParams.put(Autowired.class, null);
        factory = new AbstractAddMethodOfTestClass(factory, "before", null, beforeAnnotationParams){

            @Override
            public String body(CtClass ctClass) {
                return "{mock = org.springframework.test.web.servlet.setup.MockMvcBuilders.webAppContextSetup(webContext).build();}";
            }
        };
        Optional<Annotation> authentication = Arrays.stream(anns).filter(a -> a instanceof Authentication).findFirst();
        if (authentication.isPresent() && StringUtils.isNotBlank((String)(auth = (Authentication)authentication.get()).name()) && StringUtils.isNotBlank((String)auth.password())) {
            HashMap authenticationManagerAnnotationParams = new HashMap();
            authenticationManagerAnnotationParams.put(Autowired.class, null);
            factory = new AddFieldOfTestClass(factory, AuthenticationManager.class, "authenticationManager", authenticationManagerAnnotationParams);
            HashMap<Class<Autowired>, Object> securityAnnotationParams = new HashMap<Class<Autowired>, Object>();
            securityAnnotationParams.put(Autowired.class, null);
            factory = new AbstractAddMethodOfTestClass(factory, "cat2bugAuthentication", null, securityAnnotationParams){

                @Override
                public String body(CtClass ctClass) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("{");
                    sb.append("try {");
                    sb.append(String.format("org.springframework.security.authentication.UsernamePasswordAuthenticationToken authenticationToken = new org.springframework.security.authentication.UsernamePasswordAuthenticationToken(\"%s\", \"%s\");", auth.name(), auth.password()));
                    sb.append("org.springframework.security.core.context.SecurityContext securityContext = org.springframework.security.core.context.SecurityContextHolder.createEmptyContext();");
                    sb.append("securityContext.setAuthentication(authenticationManager.authenticate(authenticationToken));");
                    sb.append("org.springframework.security.core.context.SecurityContextHolder.setContext(securityContext);");
                    sb.append("} catch (Exception e) {");
                    sb.append("log.error(e);");
                    sb.append("}");
                    sb.append("}");
                    return sb.toString();
                }
            };
        }
        Set<Method> methods = this.scanControllerMethod(clazz);
        for (Method m : methods) {
            CtClass srcClass = this.pool.getCtClass(m.getDeclaringClass().getName());
            CtMethod srcMethod = srcClass.getDeclaredMethod(m.getName());
            MethodInfo methodInfo = srcMethod.getMethodInfo();
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            if (codeAttribute == null) continue;
            LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
            int paramLen = srcMethod.getParameterTypes().length;
            Object[][] ans = srcMethod.getParameterAnnotations();
            int pos = Modifier.isStatic((int)srcMethod.getModifiers()) ? 0 : 1;
            for (int i = 0; i < paramLen; ++i) {
                if (ParameterService.getInstance().isFilter(srcMethod.getParameterTypes()[i].getName())) continue;
                String paramName = attr.variableName(i + pos);
                CtClass paramType = srcMethod.getParameterTypes()[i];
                String methodName = ParamMethodUtil.createMethodName(m.getName(), paramName, paramType.getName());
                factory = new AddArgeMethodOfTestClass(factory, methodName, clazz, longProxyClassName, m, paramName, paramType, ans[i]);
            }
        }
        factory = this.addTestMethod(factory, methods);
        factory = this.copyMethod(factory, testCaseClass);
        factory = this.copyField(factory, testCaseClass);
        CtClass ctClass = factory.createTestClass(clazz);
        this.writeFile(ctClass);
        Class cs = ctClass.toClass();
        return cs;
    }

    private ITestClassFactory addTestMethod(ITestClassFactory factory, Set<Method> methods) {
        HashMap<Class<? extends Annotation>, Map<String, Object>> testMethodAnnotationParams = new HashMap<Class<? extends Annotation>, Map<String, Object>>();
        testMethodAnnotationParams.put(Test.class, null);
        for (Method m : methods) {
            String testMethodName = "test" + m.getName().substring(0, 1).toUpperCase() + m.getName().substring(1);
            if (m.getAnnotation(GetMapping.class) != null) {
                factory = new AddHttpGetOfTestMethod(factory, testMethodName, m, null, testMethodAnnotationParams);
                continue;
            }
            if (m.getAnnotation(PostMapping.class) != null) {
                factory = new AddHttpPostOfTestMethod(factory, testMethodName, m, null, testMethodAnnotationParams);
                continue;
            }
            if (m.getAnnotation(PutMapping.class) != null) {
                factory = new AddHttpPutOfTestMethod(factory, testMethodName, m, null, testMethodAnnotationParams);
                continue;
            }
            if (m.getAnnotation(DeleteMapping.class) != null) {
                factory = new AddHttpDeleteOfTestMethod(factory, testMethodName, m, null, testMethodAnnotationParams);
                continue;
            }
            if (m.getAnnotation(PatchMapping.class) != null || m.getAnnotation(RequestMapping.class) == null) continue;
            RequestMapping rms = m.getAnnotation(RequestMapping.class);
            if (rms.method().length > 0) {
                block10: for (RequestMethod rm : rms.method()) {
                    switch (rm) {
                        case GET: {
                            factory = new AddHttpGetOfTestMethod(factory, testMethodName, m, null, testMethodAnnotationParams);
                            continue block10;
                        }
                        case HEAD: {
                            continue block10;
                        }
                        case POST: {
                            factory = new AddHttpPostOfTestMethod(factory, testMethodName, m, null, testMethodAnnotationParams);
                            continue block10;
                        }
                        case PUT: {
                            factory = new AddHttpPutOfTestMethod(factory, testMethodName, m, null, testMethodAnnotationParams);
                            continue block10;
                        }
                        case PATCH: {
                            continue block10;
                        }
                        case DELETE: {
                            factory = new AddHttpDeleteOfTestMethod(factory, testMethodName, m, null, testMethodAnnotationParams);
                            continue block10;
                        }
                        case OPTIONS: {
                            continue block10;
                        }
                    }
                }
                continue;
            }
            factory = new AddHttpGetOfTestMethod(factory, testMethodName, m, null, testMethodAnnotationParams);
        }
        return factory;
    }

    private ITestClassFactory copyMethod(ITestClassFactory factory, Class<?> testCaseClass) throws NotFoundException {
        for (Method cm : testCaseClass.getMethods()) {
            if (cm.getAnnotation(Copy.class) == null) continue;
            CtClass srcClass = this.pool.getCtClass(cm.getDeclaringClass().getName());
            CtMethod srcMethod = srcClass.getDeclaredMethod(cm.getName());
            factory = new CopyMethodOfTestClass(factory, srcMethod);
        }
        return factory;
    }

    private ITestClassFactory copyField(ITestClassFactory factory, Class<?> testCaseClass) throws NotFoundException, ClassNotFoundException {
        CtField[] fields;
        CtClass srcClass = this.pool.getCtClass(testCaseClass.getName());
        for (CtField f : fields = srcClass.getDeclaredFields()) {
            if (f.getAnnotation(Copy.class) == null) continue;
            factory = new CopyFiledOfTestClass(factory, testCaseClass, f);
        }
        return factory;
    }

    private void writeFile(CtClass ctClass) {
        try {
            ctClass.writeFile("./target/cat2bug-junit/classes");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Set<Method> scanControllerMethod(Class<?> testClass) {
        Method[] methods;
        HashSet<Method> ret = new HashSet<Method>();
        for (Method m : methods = testClass.getMethods()) {
            if (m.getAnnotation(GetMapping.class) == null && m.getAnnotation(PostMapping.class) == null && m.getAnnotation(PutMapping.class) == null && m.getAnnotation(DeleteMapping.class) == null && m.getAnnotation(RequestMapping.class) == null && m.getAnnotation(PatchMapping.class) == null) continue;
            ret.add(m);
        }
        return ret;
    }
}

