/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.listener;

import com.cat2bug.junit.listener.Cat2BugAutoRunListener;
import com.cat2bug.junit.service.IReport;
import com.cat2bug.junit.service.report.AbstractTableReport;
import com.cat2bug.junit.service.report.CompileConsoleReportService;
import com.cat2bug.junit.service.report.ConsoleReportService;
import com.cat2bug.junit.service.report.HttpInterfaceConsoleReport;
import com.cat2bug.junit.service.report.PushReportService;
import com.cat2bug.junit.service.report.html.CompileFailHtmlReportService;
import com.cat2bug.junit.service.report.html.HtmlReportService;
import com.cat2bug.junit.service.report.html.TestFailHtmlReportService;
import com.cat2bug.junit.util.AppUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.runner.Result;

public class Cat2BugRunListener
extends Cat2BugAutoRunListener {
    private Logger log = LogManager.getLogger(Cat2BugRunListener.class);
    private static final List<IReport> reports = new ArrayList<IReport>();
    private Class<?> testCaseClass;

    public Cat2BugRunListener(Class<?> testCaseClass) {
        this.testCaseClass = testCaseClass;
        reports.add(new CompileConsoleReportService());
        reports.add(new ConsoleReportService());
        reports.add(new TestFailHtmlReportService());
        reports.add(new CompileFailHtmlReportService());
        reports.add(new HttpInterfaceConsoleReport());
        AbstractTableReport[] tableReports = reports.stream().filter(r -> r instanceof AbstractTableReport).collect(Collectors.toList()).toArray(new AbstractTableReport[0]);
        reports.add(new PushReportService(testCaseClass, tableReports));
        reports.add(new HtmlReportService(tableReports));
    }

    public void testRunFinished(Result result) throws Exception {
        super.testRunFinished(result);
        String banner = AppUtils.getBanner();
        System.out.println(banner);
        reports.forEach(r -> {
            try {
                Object report = r.getReport();
                if (report != null) {
                    System.out.println("Title: " + r.getTitle());
                    System.out.println(report);
                }
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        });
    }
}

