/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.service;

import com.cat2bug.junit.vo.HttpInterfaceVo;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class FunctionTestClassReportService {
    private static Map<String, HttpInterfaceVo> httpInterfaceMap = new ConcurrentHashMap<String, HttpInterfaceVo>();
    private static Map<Class<?>, Set<Description>> successMap = new ConcurrentHashMap();
    private static Map<Class<?>, Set<Failure>> failMap = new ConcurrentHashMap();

    private FunctionTestClassReportService() {
    }

    public static Map<Class<?>, Set<Description>> getSuccessDescription() {
        return successMap;
    }

    public static Map<Class<?>, Set<Failure>> getFailDescription() {
        return failMap;
    }

    public static Map<String, HttpInterfaceVo> getHttpInterfaceMap() {
        return httpInterfaceMap;
    }

    public static HttpInterfaceVo getHttpInterface(String className, String methodName) {
        String key = className + "." + methodName;
        if (httpInterfaceMap.containsKey(key)) {
            return httpInterfaceMap.get(key);
        }
        return null;
    }

    public static void addHttpInterface(HttpInterfaceVo httpInterface) {
        httpInterfaceMap.put(httpInterface.getClassName() + "." + httpInterface.getMethodName(), httpInterface);
    }

    public static boolean containsFail(Description description) {
        if (!failMap.containsKey(description.getTestClass())) {
            return false;
        }
        return failMap.get(description.getTestClass()).stream().anyMatch(d -> d.getDescription().getDisplayName().equals(description.getDisplayName()));
    }

    public static void addSuccessDescription(Description description) {
        if (!successMap.containsKey(description.getTestClass())) {
            successMap.put(description.getTestClass(), new HashSet());
        }
        successMap.get(description.getTestClass()).add(description);
    }

    public static void addFailure(Failure failure) {
        if (!failMap.containsKey(failure.getDescription().getTestClass())) {
            failMap.put(failure.getDescription().getTestClass(), new HashSet());
        }
        failMap.get(failure.getDescription().getTestClass()).add(failure);
    }
}

