/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.service;

import com.cat2bug.junit.annotation.RandomParameter;
import com.cat2bug.junit.service.IRandomStringService;
import com.cat2bug.junit.service.string.CharRandomStringService;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service
public class ParameterService {
    public static final String CHAR_RANDOM_STRING = "char";
    private Map<String, Class<?>> createParameterClassMap = new ConcurrentHashMap();
    public static ParameterService instance;
    private Map<String, IRandomStringService> randomStringServices = new HashMap<String, IRandomStringService>();
    ClassPool pool = ClassPool.getDefault();
    private Random random = new Random();

    private ParameterService() {
        this.randomStringServices.put(CHAR_RANDOM_STRING, new CharRandomStringService());
    }

    public static ParameterService getInstance() {
        if (instance == null) {
            instance = new ParameterService();
        }
        return instance;
    }

    public void addParameterCreateClass(Class<?> caseClass, String[] useClassNames) throws Exception {
        for (String cls : useClassNames) {
            this.createParameterClassMap.put(cls, caseClass);
        }
    }

    public Method getTestCaseMethod(String srcClassName, String proxyClassName, String srcMethodName, String parameterName, String paramType) throws Exception {
        if (this.createParameterClassMap.containsKey(proxyClassName)) {
            Method[] methods;
            Class<?> testCaseClass = this.createParameterClassMap.get(proxyClassName);
            for (Method m : methods = testCaseClass.getMethods()) {
                boolean isMatch;
                RandomParameter rp = m.getAnnotation(RandomParameter.class);
                if (rp == null || !(isMatch = Pattern.matches(rp.className(), srcClassName)) && !"".equals(rp.className()) || !(isMatch = Pattern.matches(rp.methodName(), srcMethodName)) && !"".equals(rp.methodName()) || !(isMatch = Pattern.matches(rp.parameterName(), parameterName)) && !"".equals(rp.parameterName()) || !this.typeEquals(paramType, m.getReturnType().getName())) continue;
                return m;
            }
        }
        return null;
    }

    private boolean typeEquals(String t1, String t2) {
        try {
            return t1.equals(t2) || Class.forName(t1).getSimpleName().toUpperCase().equals(t2.toUpperCase()) && (t2.equals("long") || t2.equals("int") || t2.equals(CHAR_RANDOM_STRING) || t2.equals("boolean") || t2.equals("double") || t2.equals("float") || t2.equals("short"));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> Class<T> getFieldClass(Field field) throws ClassNotFoundException {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        return field.getType();
    }

    public boolean isFilter(String typeName) {
        return typeName.equals(HttpServletResponse.class.getName()) || typeName.equals(HttpServletRequest.class.getName());
    }

    public static <T> Class<T> getFieldGenericClass(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length > 0 && actualTypeArguments[0] instanceof Class) {
                return (Class)actualTypeArguments[0];
            }
        }
        return null;
    }

    private void setClassFieldValue(int layer, Object obj) throws Exception {
        Field[] fields;
        if (layer < 0) {
            return;
        }
        for (Field f : fields = obj.getClass().getDeclaredFields()) {
            Class fieldGenericClass;
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
            Class fieldClass = ParameterService.getFieldClass(f);
            Object value = this.createParameterRandomValue(layer, fieldClass, fieldGenericClass = ParameterService.getFieldGenericClass(f));
            if (value == null) continue;
            try {
                f.setAccessible(true);
                f.set(obj, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Class stringToClass(String className) throws ClassNotFoundException {
        if (className.matches(".*(\\[\\])$")) {
            return Class.forName("[L" + className.substring(0, className.length() - 2) + ";");
        }
        switch (className) {
            case "boolean": {
                return Boolean.class;
            }
            case "int": {
                return Integer.class;
            }
            case "long": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
            case "chat": {
                return Character.class;
            }
        }
        return Class.forName(className);
    }

    public Object createParameterRandomValue(Class<?> clazz) throws Exception {
        return this.createParameterRandomValue(3, clazz, new Class[0]);
    }

    public boolean isArray(Class<?> cls) {
        return cls.isArray();
    }

    public boolean isList(Class<?> cls) {
        return List.class.isAssignableFrom(cls);
    }

    public boolean isMap(Class<?> cls) {
        return Map.class.isAssignableFrom(cls);
    }

    public boolean isSet(Class<?> cls) {
        return Set.class.isAssignableFrom(cls);
    }

    public boolean isEnum(Class<?> cls) {
        return cls.isEnum();
    }

    public boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls.getName().startsWith("java.lang");
    }

    public boolean isDate(Class<?> cls) {
        return cls.equals(Date.class);
    }

    public Object createParameterRandomValue(int layer, Class<?> clazz, Class<?> ... genericClass) throws Exception {
        if (this.isArray(clazz)) {
            return this.generateArrayData(clazz);
        }
        if (this.isList(clazz)) {
            return this.generateListData(layer, clazz, genericClass);
        }
        if (this.isMap(clazz)) {
            return this.generateMapData(clazz);
        }
        if (this.isSet(clazz)) {
            return this.generateSetData(clazz);
        }
        if (this.isEnum(clazz)) {
            return this.generateEnumData(clazz);
        }
        if (this.isPrimitive(clazz)) {
            return this.generatePrimitiveData(clazz);
        }
        if (this.isDate(clazz)) {
            return this.generateRandomDate();
        }
        if (clazz.equals(Currency.class)) {
            return Currency.getInstance("USD");
        }
        return this.generateCustomClassData(layer, clazz, genericClass);
    }

    private Object generatePrimitiveData(Class<?> clazz) {
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return this.random.nextInt();
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return this.random.nextDouble();
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return this.random.nextBoolean();
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return Math.round(Math.random() * 9.223372036854776E18);
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Float.valueOf(this.random.nextFloat());
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return (short)this.random.nextInt(Short.MAX_VALUE);
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return (byte)this.random.nextInt(127);
        }
        if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
            return Character.valueOf((char)(this.random.nextInt(26) + 97));
        }
        if (clazz.equals(String.class)) {
            return this.randomStringServices.get(CHAR_RANDOM_STRING).getRandomString();
        }
        return null;
    }

    private Object generateArrayData(Class<?> clazz) throws Exception {
        Class<?> componentType = clazz.getComponentType();
        Object array = Array.newInstance(componentType, 5);
        for (int i = 0; i < 5; ++i) {
            Array.set(array, i, this.createParameterRandomValue(componentType));
        }
        return array;
    }

    private Object generateListData(int layer, Class<?> clazz, Class<?> ... genericClass) throws Exception {
        Class elementType;
        ArrayList<Object> list = new ArrayList<Object>();
        ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
        if (genericClass.length > 0) {
            elementType = genericClass[0];
        } else if (parameterizedType != null && parameterizedType.getActualTypeArguments().length > 0) {
            elementType = (Class)parameterizedType.getActualTypeArguments()[0];
        } else {
            return list;
        }
        for (int i = 0; i < 5; ++i) {
            list.add(this.createParameterRandomValue(layer, elementType, new Class[0]));
        }
        return list;
    }

    private Object generateSetData(Class<?> clazz) throws Exception {
        HashSet<Object> set = new HashSet<Object>();
        ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
        if (parameterizedType == null || parameterizedType.getActualTypeArguments().length == 0) {
            return set;
        }
        Class keyType = (Class)parameterizedType.getActualTypeArguments()[0];
        for (int i = 0; i < 5; ++i) {
            set.add(this.createParameterRandomValue(keyType));
        }
        return set;
    }

    private Object generateMapData(Class<?> clazz) throws Exception {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
        Class keyType = (Class)parameterizedType.getActualTypeArguments()[0];
        Class valueType = (Class)parameterizedType.getActualTypeArguments()[1];
        for (int i = 0; i < 5; ++i) {
            map.put(this.createParameterRandomValue(keyType), this.createParameterRandomValue(valueType));
        }
        return map;
    }

    private Object generateEnumData(Class<?> clazz) throws Exception {
        ?[] enumConstants = clazz.getEnumConstants();
        int randomIndex = this.random.nextInt(enumConstants.length);
        return enumConstants[randomIndex];
    }

    private Date generateRandomDate() {
        long offset = Timestamp.valueOf("1970-01-01 00:00:00").getTime();
        long end = Timestamp.valueOf("2025-12-31 23:59:59").getTime();
        long diff = end - offset + 1L;
        return new Date(offset + (long)(Math.random() * (double)diff));
    }

    private Object generateCustomClassData(int layer, Class cls, Class<?> ... genericClass) throws Exception {
        try {
            Constructor constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(new Object[0]);
            this.setClassFieldValue(--layer, obj);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

