/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.service.report;

import com.cat2bug.junit.service.IReport;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;

public abstract class AbstractHtmlReport
implements IReport {
    private static final String COMPILE_PATH = "target/cat2bug-junit/report";
    private static final String TEMPLATE_PATH = "/templates";

    protected abstract String getTemplateName();

    protected abstract String getOutputFileName();

    protected abstract Map getData();

    protected abstract String getReport(String var1);

    public Object getReport() {
        StringBuffer sb = new StringBuffer();
        try {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_30);
            ClassTemplateLoader templateLoader = new ClassTemplateLoader(this.getClass(), TEMPLATE_PATH);
            configuration.setTemplateLoader((TemplateLoader)templateLoader);
            configuration.setDefaultEncoding("utf-8");
            Template template = configuration.getTemplate(this.getTemplateName());
            Map dataModel = this.getData();
            File dir = new File(COMPILE_PATH);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, this.getOutputFileName());
            FileWriter out = new FileWriter(file, false);
            template.process((Object)dataModel, (Writer)out);
            String report = this.getReport(file.getAbsolutePath());
            if (Strings.isNotBlank((String)report)) {
                sb.append(report);
            }
            ((Writer)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }
}

