/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.service.report;

import com.alibaba.fastjson.JSON;
import com.cat2bug.junit.annotation.PushReport;
import com.cat2bug.junit.service.CompileClassResultService;
import com.cat2bug.junit.service.FunctionTestClassReportService;
import com.cat2bug.junit.service.IReport;
import com.cat2bug.junit.service.report.AbstractTableReport;
import com.cat2bug.junit.type.DefectState;
import com.cat2bug.junit.type.DefectType;
import com.cat2bug.junit.type.PushReportType;
import com.cat2bug.junit.util.AppUtils;
import com.cat2bug.junit.vo.DefectVo;
import com.cat2bug.junit.vo.ReportVo;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.util.Strings;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class PushReportService
implements IReport<String> {
    private static final Log logger = LogFactory.getLog(PushReportService.class);
    private static final String CONFIG_FILE = "cat2bug.properties";
    private static final String DEFAULT_API_HOST = "https://www.cat2bug.com/cloud/";
    private static final String AUTH_TOKEN_HEADER_NAME = "CAT2BUG-API-KEY";
    private static final String PUSH_DEFECT_URL = "/api/report/defect";
    private static final MediaType FORM_CONTENT_TYPE = MediaType.parse((String)"application/json;charset=utf-8");
    private List<AbstractTableReport> reportList = new ArrayList<AbstractTableReport>();
    private Class<?> testCaseClass;

    public PushReportService(Class<?> testCaseClass, AbstractTableReport ... list) {
        this.testCaseClass = testCaseClass;
        this.reportList.addAll(Arrays.stream(list).collect(Collectors.toList()));
    }

    @Override
    public String getTitle() {
        return "\u63d0\u4ea4\u6d4b\u8bd5\u62a5\u544a";
    }

    @Override
    public String getReport() {
        if (this.testCaseClass == null) {
            return null;
        }
        PushReport pushReport = this.testCaseClass.getAnnotation(PushReport.class);
        if (pushReport == null || !pushReport.isPush()) {
            return null;
        }
        String url = this.getPushDefectUrl(pushReport);
        if (Strings.isBlank((String)url)) {
            return null;
        }
        String projectKey = this.getProjectKey(pushReport);
        if (Strings.isBlank((String)projectKey)) {
            return null;
        }
        String version = this.getVersion(pushReport);
        String handler = this.getHandler(pushReport);
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("\u63a8\u9001\u5730\u5740:%s\n\u5904\u7406\u4eba:%s\n", url, handler));
        ArrayList defectList = new ArrayList();
        PushReportType pushReportType = this.getPushType(pushReport);
        if (pushReportType == PushReportType.All) {
            HashSet successGroupKeySet = new HashSet();
            FunctionTestClassReportService.getSuccessDescription().values().stream().forEach(vs -> {
                for (Description d : vs) {
                    successGroupKeySet.add(this.getGroupKey(d));
                }
            });
            HashSet failGroupKeySet = new HashSet();
            FunctionTestClassReportService.getFailDescription().values().stream().forEach(vs -> {
                for (Failure f : vs) {
                    failGroupKeySet.add(this.getGroupKey(f.getDescription()));
                }
            });
            successGroupKeySet.removeAll(failGroupKeySet);
            successGroupKeySet.forEach(s -> {
                DefectVo defect = new DefectVo();
                defect.setDefectGroupKey((String)s);
                defect.setDefectState(DefectState.CLOSED);
                defectList.add(defect);
            });
        }
        FunctionTestClassReportService.getFailDescription().entrySet().stream().forEach(f -> {
            List tempList = ((Set)f.getValue()).stream().map(d -> this.failure2Defect((Failure)d, version)).collect(Collectors.toList());
            defectList.addAll(tempList);
        });
        ReportVo reportVo = new ReportVo();
        reportVo.setHandler(handler);
        reportVo.setReportData(defectList);
        reportVo.setReportTime(new Date());
        reportVo.setReportTitle("\u5355\u5143\u6d4b\u8bd5\u62a5\u544a:" + this.testCaseClass.getName());
        String reportDescription = Arrays.asList(this.getEnvironmentInfo(), this.getDataBaseInfo(), this.getDataDetails()).stream().collect(Collectors.joining("\n"));
        reportVo.setReportDescription(reportDescription);
        try {
            this.pushReport(url, projectKey, reportVo);
            sb.append("\u63a8\u9001\u62a5\u544a\u6210\u529f\n");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sb.toString();
    }

    private DefectVo failure2Defect(Failure f, String version) {
        DefectVo defect = new DefectVo();
        defect.setModuleVersion(version);
        String defectName = "[" + f.getDescription().getDisplayName() + "]" + f.getException().toString();
        defect.setDefectName(defectName);
        StringBuffer describe = new StringBuffer();
        describe.append(this.getEnvironmentInfo());
        describe.append("\n``` java");
        describe.append(f.getTrace());
        describe.append("\n```");
        defect.setDefectDescribe(describe.toString());
        defect.setDefectState(DefectState.PROCESSING);
        defect.setDefectType(DefectType.BUG);
        String groupKey = f.getDescription().getClassName() + "." + f.getDescription().getMethodName();
        defect.setDefectGroupKey(groupKey);
        defect.setDefectKey(groupKey + ":" + f.getException().toString());
        return defect;
    }

    private String getGroupKey(Description d) {
        return d.getClassName() + "." + d.getMethodName();
    }

    private String getEnvironmentInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        String javaVersion = System.getProperty("java.version");
        List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        return Arrays.asList("## \u57fa\u7840\u4fe1\u606f", "* **Report Time:** " + sdf.format(new Date()), "* **Tools:** Cat2Bug-Spring-Boot-JUnit", "* **Tools Version:** " + AppUtils.getAppVersion(), "* **OS Name:** " + osName, "* **OS Version:** " + osVersion, "* **OS Arch:** " + osArch, "* **Java Version:** " + javaVersion, "* **JVM Args:** " + jvmArgs.stream().collect(Collectors.joining(";"))).stream().collect(Collectors.joining("\n"));
    }

    private String getDataBaseInfo() {
        String ret = this.reportList.stream().map(r -> {
            StringBuffer sb = new StringBuffer();
            sb.append("### " + r.getTitle() + "\n");
            sb.append(" | " + Arrays.stream(r.getTableHeader()).collect(Collectors.joining(" | ")) + " | \n");
            sb.append(" | " + Arrays.stream(r.getTableHeader()).map(m -> "---------").collect(Collectors.joining(" | ")) + " | \n");
            for (String[] data : r.getTableData()) {
                sb.append(" | " + Arrays.stream(data).collect(Collectors.joining(" | ")) + " | \n");
            }
            return sb.toString();
        }).collect(Collectors.joining("\n"));
        return ret;
    }

    private String getDataDetails() {
        StringBuffer ret = new StringBuffer();
        ret.append("## \u6570\u636e\u62a5\u544a\u8be6\u60c5\n");
        ret.append(CompileClassResultService.getFailResults().entrySet().stream().map(f -> {
            StringBuffer sb = new StringBuffer();
            sb.append("* Class Name:" + f.getKey() + "\n");
            sb.append(((Throwable)f.getValue()).getMessage() + "\n");
            return sb.toString();
        }).collect(Collectors.joining("\n")));
        ret.append(FunctionTestClassReportService.getFailDescription().entrySet().stream().map(f -> {
            StringBuffer sb = new StringBuffer();
            sb.append("### " + ((Class)f.getKey()).getName() + "\n\n");
            sb.append(((Set)f.getValue()).stream().map(failure -> {
                StringBuffer fsb = new StringBuffer();
                fsb.append("* Method Name: " + failure.getDescription().getMethodName() + "\n\n");
                fsb.append("```java\n");
                fsb.append(failure.getTrace() + "\n");
                fsb.append("```\n");
                return fsb.toString();
            }).collect(Collectors.joining("\n")));
            return sb.toString();
        }).collect(Collectors.joining("\n")));
        return ret.toString();
    }

    private void pushReport(String url, String projectKey, ReportVo report) throws IOException {
        OkHttpClient client = new OkHttpClient();
        String body = JSON.toJSONString((Object)report);
        RequestBody formBody = RequestBody.create((MediaType)FORM_CONTENT_TYPE, (String)body);
        Request request = new Request.Builder().url(url).header("content-type", "application/json").header(AUTH_TOKEN_HEADER_NAME, projectKey).post(formBody).build();
        Response response = client.newCall(request).execute();
        if (response.code() != 200) {
            new RuntimeException("\u63d0\u4ea4\u95ee\u9898\u63a5\u53e3\u5931\u8d25\nstate code:" + response.code() + "\n body:" + response.body().string());
        }
    }

    private PushReportType getPushType(PushReport pushReport) {
        if (pushReport.type() != PushReportType.DEFAULT) {
            return pushReport.type();
        }
        return AppUtils.getPushType();
    }

    private String getVersion(PushReport pushReport) {
        if (Strings.isNotBlank((String)pushReport.version())) {
            return pushReport.version();
        }
        String version = AppUtils.getPushVersion();
        if (Strings.isNotBlank((String)version)) {
            return version;
        }
        return null;
    }

    private String getHandler(PushReport pushReport) {
        if (Strings.isNotBlank((String)pushReport.handler())) {
            return pushReport.handler();
        }
        String handler = AppUtils.getPushHandler();
        if (Strings.isNotBlank((String)handler)) {
            return handler;
        }
        return null;
    }

    private String getProjectKey(PushReport pushReport) {
        if (Strings.isNotBlank((String)pushReport.projectKey())) {
            return pushReport.projectKey();
        }
        String projectKey = AppUtils.getPushProjectKey();
        if (Strings.isNotBlank((String)projectKey)) {
            return projectKey;
        }
        return null;
    }

    private String getPushDefectUrl(PushReport pushReport) {
        if (Strings.isNotBlank((String)pushReport.host())) {
            return pushReport.host().replaceAll("/$", "") + PUSH_DEFECT_URL;
        }
        String host = AppUtils.getPushUrl();
        if (Strings.isNotBlank((String)host)) {
            return host.replaceAll("/$", "") + PUSH_DEFECT_URL;
        }
        return null;
    }
}

