/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.service.report.html;

import com.cat2bug.junit.service.report.AbstractHtmlReport;
import com.cat2bug.junit.service.report.AbstractTableReport;
import com.cat2bug.junit.util.AppUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HtmlReportService
extends AbstractHtmlReport {
    private List<AbstractTableReport> reportList = new ArrayList<AbstractTableReport>();

    public HtmlReportService(AbstractTableReport ... list) {
        this.reportList.addAll(Arrays.stream(list).collect(Collectors.toList()));
    }

    @Override
    public String getTitle() {
        return "\u672c\u5730\u6d4b\u8bd5\u62a5\u544a";
    }

    @Override
    protected String getTemplateName() {
        return "index.ftl";
    }

    @Override
    protected String getOutputFileName() {
        return "index.html";
    }

    @Override
    protected Map getData() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dataModel.put("reportTime", sdf.format(new Date()));
        dataModel.put("cat2bugVersion", AppUtils.getAppVersion());
        dataModel.put("reports", this.reportList.stream().map(r -> {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("title", r.getTitle());
            ret.put("tableHeader", r.getTableHeader());
            ret.put("tableData", r.getTableData());
            return ret;
        }).collect(Collectors.toList()));
        return dataModel;
    }

    @Override
    protected String getReport(String htmlFile) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u8bf7\u8bbf\u95ee\u4ee5\u4e0b\u5730\u5740\u67e5\u770b\u6d4b\u8bd5\u62a5\u544a\n");
        sb.append(String.format("%s", htmlFile));
        return sb.toString();
    }
}

