/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.util;

import com.cat2bug.junit.type.PushReportType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.yaml.snakeyaml.Yaml;

public class AppUtils {
    private static final Logger log = LogManager.getLogger(AppUtils.class);
    private static String appVersion;
    private static final Properties properties;
    private static String tempKey;

    private static void loadProperties(String path) {
        Properties pro = new Properties();
        try {
            pro.load(AppUtils.class.getClassLoader().getResourceAsStream(path));
            if (pro != null) {
                pro.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.put(k, v)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadYml(String path) throws IOException {
        Yaml yaml = new Yaml();
        if (Strings.isBlank((String)path)) {
            return;
        }
        InputStream resourceAsStream = AppUtils.class.getClassLoader().getResourceAsStream(path);
        if (resourceAsStream == null) {
            return;
        }
        Map loadMap = (Map)yaml.load(resourceAsStream);
        if (loadMap == null || loadMap.isEmpty()) {
            resourceAsStream.close();
            return;
        }
        AppUtils.SwitchYmlMapToMap(loadMap);
        resourceAsStream.close();
    }

    private static void SwitchYmlMapToMap(Object map) {
        if (!(map instanceof Map)) {
            String substring = tempKey.substring(0, tempKey.length() - 1);
            if (map != null) {
                properties.put(substring, map);
            }
            return;
        }
        for (String key : ((Map)map).keySet()) {
            tempKey = tempKey + key + ".";
            AppUtils.SwitchYmlMapToMap(((Map)map).get(key));
            tempKey = tempKey.substring(0, tempKey.length() - (key.length() + 1));
        }
    }

    public static String getPushUrl() {
        return properties.getProperty("cat2bug.junit.push-report.host");
    }

    public static String getPushProjectKey() {
        return properties.getProperty("cat2bug.junit.push-report.project-key");
    }

    public static String getPushHandler() {
        return properties.getProperty("cat2bug.junit.push-report.handler");
    }

    public static String getPushVersion() {
        return properties.getProperty("cat2bug.junit.push-report.version");
    }

    public static PushReportType getPushType() {
        String type = properties.getProperty("cat2bug.junit.push-report.type");
        if (Strings.isBlank((String)type)) {
            return PushReportType.DEFAULT;
        }
        switch (type.toLowerCase()) {
            case "all": {
                return PushReportType.All;
            }
            case "defect": {
                return PushReportType.Defect;
            }
        }
        return PushReportType.DEFAULT;
    }

    public static String getAppVersion() {
        return properties.getProperty("cat2bug.junit.version") + "";
    }

    public static String getBanner() {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream inputStream = AppUtils.class.getClassLoader().getResourceAsStream("cat2bug-junit-banner.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String version = AppUtils.getAppVersion();
        return sb.toString().replace("${cat2bug.junit.version}", version);
    }

    static {
        properties = new Properties();
        tempKey = "";
        try {
            AppUtils.loadProperties("./cat2bug.properties");
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        try {
            AppUtils.loadProperties("./application.properties");
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        try {
            AppUtils.loadYml("./application.yml");
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
    }
}

