/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.util;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.yaml.snakeyaml.Yaml;

public class ConfigUtil {
    private static final String SPRINGBOOT_YAML_FILE = "application.yml";
    private static final String CAT2BUG_YAML_FILE = "cat2bug.yml";
    private static final String SPRINGBOOT_PROPERTIES_FILE = "cat2bug.properties";
    private static final String CAT2BUG_PROPERTIES_FILE = "cat2bug.properties";

    public static <T> T getConfig(String key, Class<T> cls) {
        Map<String, Object> map = ConfigUtil.loadConfig();
        Object ret = map.get(key);
        if (ret == null) {
            return null;
        }
        return cls.cast(ret);
    }

    private static Map<String, Object> loadConfig() {
        InputStream inputStream = ConfigUtil.class.getClassLoader().getResourceAsStream(CAT2BUG_YAML_FILE);
        if (inputStream != null) {
            return ConfigUtil.loadYamlConfig(inputStream);
        }
        return ConfigUtil.loadPropertiesConfig();
    }

    private static Map<String, Object> loadYamlConfig(InputStream inputStream) {
        Yaml yaml = new Yaml();
        return (Map)yaml.load(inputStream);
    }

    private static Map<String, Object> loadPropertiesConfig() {
        Properties properties = new Properties();
        try (InputStream inputStream = ConfigUtil.class.getClassLoader().getResourceAsStream("cat2bug.properties");){
            properties.load(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }
}

