/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.util;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpUtils {
    public static String getUrl(Method method) {
        GetMapping annotation;
        ArrayList<String> urls = new ArrayList<String>();
        String headUrl = null;
        String[] getMappingValues = null;
        RequestMapping classAnnotation = method.getDeclaringClass().getAnnotation(RequestMapping.class);
        if (classAnnotation != null) {
            headUrl = classAnnotation.value()[0];
        }
        if ((annotation = method.getAnnotation(GetMapping.class)) != null) {
            getMappingValues = annotation.value();
        }
        if (annotation == null && (annotation = method.getAnnotation(PostMapping.class)) != null) {
            getMappingValues = ((PostMapping)annotation).value();
        }
        if (annotation == null && (annotation = method.getAnnotation(PutMapping.class)) != null) {
            getMappingValues = ((PutMapping)annotation).value();
        }
        if (annotation == null && (annotation = method.getAnnotation(DeleteMapping.class)) != null) {
            getMappingValues = ((DeleteMapping)annotation).value();
        }
        if (annotation == null && (annotation = method.getAnnotation(RequestMapping.class)) != null) {
            RequestMapping rm = (RequestMapping)annotation;
            boolean isHavsGetMapping = false;
            for (RequestMethod r : rm.method()) {
                if (r != RequestMethod.GET) continue;
                isHavsGetMapping = true;
            }
            if (isHavsGetMapping) {
                getMappingValues = ((RequestMapping)annotation).value();
            }
        }
        if (annotation != null) {
            if (getMappingValues != null && getMappingValues.length > 0) {
                int n = 0;
                String[] stringArray = getMappingValues;
                int n2 = stringArray.length;
                if (n < n2) {
                    String shortUrl = stringArray[n];
                    urls.add(headUrl);
                    urls.add(shortUrl);
                    return HttpUtils.getUrl(urls);
                }
            } else {
                urls.add(headUrl);
                return HttpUtils.getUrl(urls);
            }
        }
        return null;
    }

    private static String createStringValue() {
        return UUID.randomUUID().toString();
    }

    private static String createIntegerValue() {
        return String.valueOf(Math.random() * 2.147483647E9);
    }

    public static void testGet(MockMvc mock, String url, Map<?, ?> params, Object body) throws Exception {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.get((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON);
        if (body != null) {
            builder = builder.content(JSON.toJSONString((Object)body));
        }
        if (params != null) {
            for (Map.Entry<?, ?> item : params.entrySet()) {
                if (item.getValue() == null) continue;
                builder = builder.param((String)item.getKey(), new String[]{JSON.toJSONString(item.getValue())});
            }
        }
        mock.perform((RequestBuilder)builder).andExpect(MockMvcResultMatchers.status().isOk()).andReturn().getResponse().getContentAsString();
    }

    public static void testPost(MockMvc mock, String url, Map<?, ?> params, Object body) throws Exception {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON);
        if (body != null) {
            builder = builder.content(JSON.toJSONString((Object)body));
        }
        if (params != null) {
            for (Map.Entry<?, ?> item : params.entrySet()) {
                if (item.getValue() == null) continue;
                builder = builder.param((String)item.getKey(), new String[]{JSON.toJSONString(item.getValue())});
            }
        }
        mock.perform((RequestBuilder)builder).andExpect(MockMvcResultMatchers.status().isOk()).andReturn().getResponse().getContentAsString();
    }

    public static void testPut(MockMvc mock, String url, Map<?, ?> params, Object body) throws Exception {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.put((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON);
        if (body != null) {
            builder = builder.content(JSON.toJSONString((Object)body));
        }
        if (params != null) {
            for (Map.Entry<?, ?> item : params.entrySet()) {
                if (item.getValue() == null) continue;
                builder = builder.param((String)item.getKey(), new String[]{JSON.toJSONString(item.getValue())});
            }
        }
        mock.perform((RequestBuilder)builder).andExpect(MockMvcResultMatchers.status().isOk()).andReturn().getResponse().getContentAsString();
    }

    public static void testDelete(MockMvc mock, String url, Map<?, ?> params, Object body) throws Exception {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.delete((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON);
        if (body != null) {
            builder = builder.content(JSON.toJSONString((Object)body));
        }
        if (params != null) {
            for (Map.Entry<?, ?> item : params.entrySet()) {
                if (item.getValue() == null) continue;
                builder = builder.param((String)item.getKey(), new String[]{JSON.toJSONString(item.getValue())});
            }
        }
        mock.perform((RequestBuilder)builder).andExpect(MockMvcResultMatchers.status().isOk()).andReturn().getResponse().getContentAsString();
    }

    public static String getUrl(List<String> cs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cs.size(); ++i) {
            String s = cs.get(i);
            if (!StringUtils.hasLength((String)s)) continue;
            int len = s.indexOf("/");
            if (len != 0) {
                s = "/" + s;
            }
            if (i < cs.size() - 1 && (len = s.lastIndexOf("/")) == s.length() - 1) {
                s = s.substring(0, s.length() - 1);
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

