/*
 * Decompiled with CFR 0.152.
 */
package com.cat2bug.junit.util;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PathVariable;

public class UrlUtil {
    public static String compileUrl(String url, PathVariable pathVariable, String paramName, String paramMethodName) {
        String urlParamName = pathVariable == null ? null : pathVariable.value();
        String string = urlParamName = Strings.isNullOrEmpty((String)urlParamName) ? paramName : urlParamName;
        if (!Strings.isNullOrEmpty((String)urlParamName)) {
            url = UrlUtil.pathParamHandler(url, urlParamName, String.format("this.%s()", paramMethodName));
        }
        return UrlUtil.handleUrl(url);
    }

    private static String pathParamHandler(String url, String name, String value) {
        return url.replace(" ", "").replace("{" + name + "}", "\n" + value + "\n");
    }

    private static String handleUrl(String url) {
        String newUrl = Arrays.stream(url.split("\n")).map(s -> {
            if (s.matches("^(this\\.)([A-Za-z0-9]*)(\\(\\))$")) {
                return String.format("%s.toString()", s);
            }
            return "\"" + s + "\"";
        }).collect(Collectors.joining(" + "));
        String pattern = "\\{([^{}]*)\\}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(newUrl);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String placeholder = m.group(1);
            m.appendReplacement(sb, placeholder);
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

