/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.http;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.HttpStatusCodeException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class HttpResponse {
    private final int statusCode;
    private final byte[] content;

    @Stability.Internal
    public HttpResponse(int statusCode, byte[] content) {
        this.statusCode = statusCode;
        this.content = Objects.requireNonNull(content);
    }

    HttpResponse(CoreHttpResponse coreResponse) {
        this(coreResponse.httpStatus(), coreResponse.content());
    }

    HttpResponse(HttpStatusCodeException e) {
        this(e.httpStatusCode(), e.content().getBytes(StandardCharsets.UTF_8));
    }

    public int statusCode() {
        return this.statusCode;
    }

    public byte[] content() {
        return this.content;
    }

    public String contentAsString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public boolean success() {
        return this.statusCode >= 200 && this.statusCode <= 299;
    }

    public String toString() {
        return "HttpResponse{statusCode=" + this.statusCode + ", contentAsString=" + this.contentAsString() + '}';
    }
}

