/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.cassio;

import com.dtsx.astra.sdk.cassio.CassandraSimilarityMetric;
import java.util.List;
import java.util.Map;

public class AnnQuery {
    private int recordCount;
    private double threshold = 0.0;
    private List<Float> embeddings;
    private CassandraSimilarityMetric metric = CassandraSimilarityMetric.COSINE;
    private Map<String, String> metaData;

    AnnQuery(int recordCount, double threshold, List<Float> embeddings, CassandraSimilarityMetric metric, Map<String, String> metaData) {
        this.recordCount = recordCount;
        this.threshold = threshold;
        this.embeddings = embeddings;
        this.metric = metric;
        this.metaData = metaData;
    }

    public static AnnQueryBuilder builder() {
        return new AnnQueryBuilder();
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public List<Float> getEmbeddings() {
        return this.embeddings;
    }

    public CassandraSimilarityMetric getMetric() {
        return this.metric;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setEmbeddings(List<Float> embeddings) {
        this.embeddings = embeddings;
    }

    public void setMetric(CassandraSimilarityMetric metric) {
        this.metric = metric;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
    }

    public static class AnnQueryBuilder {
        private int recordCount;
        private double threshold;
        private List<Float> embeddings;
        private CassandraSimilarityMetric metric;
        private Map<String, String> metaData;

        AnnQueryBuilder() {
        }

        public AnnQueryBuilder recordCount(int recordCount) {
            this.recordCount = recordCount;
            return this;
        }

        public AnnQueryBuilder threshold(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public AnnQueryBuilder embeddings(List<Float> embeddings) {
            this.embeddings = embeddings;
            return this;
        }

        public AnnQueryBuilder metric(CassandraSimilarityMetric metric) {
            this.metric = metric;
            return this;
        }

        public AnnQueryBuilder metaData(Map<String, String> metaData) {
            this.metaData = metaData;
            return this;
        }

        public AnnQuery build() {
            return new AnnQuery(this.recordCount, this.threshold, this.embeddings, this.metric, this.metaData);
        }

        public String toString() {
            return "AnnQuery.AnnQueryBuilder(recordCount=" + this.recordCount + ", threshold=" + this.threshold + ", embeddings=" + String.valueOf(this.embeddings) + ", metric=" + String.valueOf((Object)this.metric) + ", metaData=" + String.valueOf(this.metaData) + ")";
        }
    }
}

