/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.odm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.stargate.sdk.data.domain.odm.DocumentSerializer;
import io.stargate.sdk.utils.JsonUtils;

@JsonSerialize(using=DocumentSerializer.class)
public class Document<T> {
    @JsonProperty(value="_id")
    protected String id;
    @JsonProperty(value="$vector")
    protected float[] vector;
    protected T data;

    public Document() {
    }

    public Document(String id, T data, float[] vector) {
        this.id = id;
        this.data = data;
        this.vector = vector;
    }

    public Document<T> id(String id) {
        this.id = id;
        return this;
    }

    public Document<T> vector(float[] vector) {
        this.vector = vector;
        return this;
    }

    public Document<T> data(T data) {
        this.data = data;
        return this;
    }

    public static <R> Document<R> of(String id, float[] vector, R data) {
        return new Document().id(id).vector(vector).data(data);
    }

    public String toString() {
        return JsonUtils.marshallForDataApi((Object)this);
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty(value="_id")
    public void setId(String id) {
        this.id = id;
    }

    public float[] getVector() {
        return this.vector;
    }

    @JsonProperty(value="$vector")
    public void setVector(float[] vector) {
        this.vector = vector;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

