/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.kotlin.BadSemver;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nullable;

public class KtfmtStep {
    private static final String DEFAULT_VERSION = "0.41";
    static final String NAME = "ktfmt";
    static final String PACKAGE = "com.facebook";
    static final String MAVEN_COORDINATE = "com.facebook:ktfmt:";
    static final String FORMATTER_METHOD = "format";

    private KtfmtStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtfmtStep.create(KtfmtStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtfmtStep.create(version, provisioner, null, null);
    }

    public static FormatterStep create(String version, Provisioner provisioner, @Nullable Style style, @Nullable KtfmtFormattingOptions options) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner, style, options), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String version;
        private final String pkg;
        @Nullable
        private final Style style;
        @Nullable
        private final KtfmtFormattingOptions options;
        final JarState jarState;

        State(String version, Provisioner provisioner, @Nullable Style style, @Nullable KtfmtFormattingOptions options) throws IOException {
            this.version = version;
            this.options = options;
            this.pkg = KtfmtStep.PACKAGE;
            this.style = style;
            this.jarState = JarState.from(KtfmtStep.MAVEN_COORDINATE + version, provisioner);
        }

        FormatterFunc createFormat() throws Exception {
            Object ktfmtStyle;
            ClassLoader classLoader = this.jarState.getClassLoader();
            if (BadSemver.version(this.version) < BadSemver.version(0, 32)) {
                if (this.options != null) {
                    throw new IllegalStateException("Ktfmt formatting options supported for version 0.32 and later");
                }
                return this.getFormatterFuncFallback(this.style != null ? this.style : Style.DEFAULT, classLoader);
            }
            Class<?> formatterFuncClass = classLoader.loadClass("com.diffplug.spotless.glue.ktfmt.KtfmtFormatterFunc");
            Class<?> ktfmtStyleClass = classLoader.loadClass("com.diffplug.spotless.glue.ktfmt.KtfmtStyle");
            Class<?> ktfmtFormattingOptionsClass = classLoader.loadClass("com.diffplug.spotless.glue.ktfmt.KtfmtFormattingOptions");
            if (this.style == null && this.options == null) {
                Constructor<?> constructor = formatterFuncClass.getConstructor(new Class[0]);
                return (FormatterFunc)constructor.newInstance(new Object[0]);
            }
            Object v0 = ktfmtStyle = this.style == null ? null : Enum.valueOf(ktfmtStyleClass, this.getKtfmtStyleOption(this.style));
            if (this.options == null) {
                Constructor<?> constructor = formatterFuncClass.getConstructor(ktfmtStyleClass);
                return (FormatterFunc)constructor.newInstance(ktfmtStyle);
            }
            Constructor<?> optionsConstructor = ktfmtFormattingOptionsClass.getConstructor(Integer.class, Integer.class, Integer.class, Boolean.class);
            Object ktfmtFormattingOptions = optionsConstructor.newInstance(this.options.maxWidth, this.options.blockIndent, this.options.continuationIndent, this.options.removeUnusedImport);
            if (this.style == null) {
                Constructor<?> constructor = formatterFuncClass.getConstructor(ktfmtFormattingOptionsClass);
                return (FormatterFunc)constructor.newInstance(ktfmtFormattingOptions);
            }
            Constructor<?> constructor = formatterFuncClass.getConstructor(ktfmtStyleClass, ktfmtFormattingOptionsClass);
            return (FormatterFunc)constructor.newInstance(ktfmtStyle, ktfmtFormattingOptions);
        }

        private String getKtfmtStyleOption(Style style) {
            switch (style) {
                case DEFAULT: {
                    return "DEFAULT";
                }
                case DROPBOX: {
                    return "DROPBOX";
                }
                case GOOGLE: {
                    return "GOOGLE";
                }
                case KOTLINLANG: {
                    return "KOTLIN_LANG";
                }
            }
            throw new IllegalStateException("Unsupported style: " + (Object)((Object)style));
        }

        private FormatterFunc getFormatterFuncFallback(Style style, ClassLoader classLoader) {
            return input -> {
                try {
                    if (style == Style.DEFAULT) {
                        Method formatterMethod = this.getFormatterClazz(classLoader).getMethod(KtfmtStep.FORMATTER_METHOD, String.class);
                        return (String)formatterMethod.invoke(this.getFormatterClazz(classLoader), input);
                    }
                    Method formatterMethod = this.getFormatterClazz(classLoader).getMethod(KtfmtStep.FORMATTER_METHOD, this.getFormattingOptionsClazz(classLoader), String.class);
                    Object formattingOptions = this.getCustomFormattingOptions(classLoader, style);
                    return (String)formatterMethod.invoke(this.getFormatterClazz(classLoader), formattingOptions, input);
                }
                catch (InvocationTargetException e) {
                    throw ThrowingEx.unwrapCause(e);
                }
            };
        }

        private Object getCustomFormattingOptions(ClassLoader classLoader, Style style) throws Exception {
            if (BadSemver.version(this.version) < BadSemver.version(style.since)) {
                throw new IllegalStateException(String.format("The style %s is available from version %s (current version: %s)", style.name(), style.since, this.version));
            }
            try {
                return this.getFormatterClazz(classLoader).getField(style.getFormat()).get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (style == Style.DEFAULT || style == Style.DROPBOX) {
                    Class<?> formattingOptionsCompanionClazz = classLoader.loadClass(this.pkg + ".ktfmt.FormattingOptions$Companion");
                    Object companion = formattingOptionsCompanionClazz.getConstructors()[0].newInstance(new Object[]{null});
                    Method formattingOptionsMethod = formattingOptionsCompanionClazz.getDeclaredMethod("dropboxStyle", new Class[0]);
                    return formattingOptionsMethod.invoke(companion, new Object[0]);
                }
                throw new IllegalStateException("Versions pre-0.19 can only use Default and Dropbox styles");
            }
        }

        private Class<?> getFormatterClazz(ClassLoader classLoader) throws Exception {
            Class<?> formatterClazz = BadSemver.version(this.version) >= BadSemver.version(0, 31) ? classLoader.loadClass(this.pkg + ".ktfmt.format.Formatter") : classLoader.loadClass(this.pkg + ".ktfmt.FormatterKt");
            return formatterClazz;
        }

        private Class<?> getFormattingOptionsClazz(ClassLoader classLoader) throws Exception {
            Class<?> formattingOptionsClazz = BadSemver.version(this.version) >= BadSemver.version(0, 31) ? classLoader.loadClass(this.pkg + ".ktfmt.format.FormattingOptions") : classLoader.loadClass(this.pkg + ".ktfmt.FormattingOptions");
            return formattingOptionsClazz;
        }
    }

    public static class KtfmtFormattingOptions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Nullable
        private Integer maxWidth = null;
        @Nullable
        private Integer blockIndent = null;
        @Nullable
        private Integer continuationIndent = null;
        @Nullable
        private Boolean removeUnusedImport = null;

        public KtfmtFormattingOptions() {
        }

        public KtfmtFormattingOptions(@Nullable Integer maxWidth, @Nullable Integer blockIndent, @Nullable Integer continuationIndent, @Nullable Boolean removeUnusedImport) {
            this.maxWidth = maxWidth;
            this.blockIndent = blockIndent;
            this.continuationIndent = continuationIndent;
            this.removeUnusedImport = removeUnusedImport;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public void setBlockIndent(int blockIndent) {
            this.blockIndent = blockIndent;
        }

        public void setContinuationIndent(int continuationIndent) {
            this.continuationIndent = continuationIndent;
        }

        public void setRemoveUnusedImport(boolean removeUnusedImport) {
            this.removeUnusedImport = removeUnusedImport;
        }
    }

    public static enum Style {
        DEFAULT("DEFAULT_FORMAT", "0.0"),
        DROPBOX("DROPBOX_FORMAT", "0.11"),
        GOOGLE("GOOGLE_FORMAT", "0.21"),
        KOTLINLANG("KOTLINLANG_FORMAT", "0.21");

        private final String format;
        private final String since;

        private Style(String format, String since) {
            this.format = format;
            this.since = since;
        }

        String getFormat() {
            return this.format;
        }

        String getSince() {
            return this.since;
        }
    }
}

