/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.incremental;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.maven.incremental.ObjectDigestOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;

class PluginFingerprint {
    private static final String SPOTLESS_PLUGIN_KEY = "com.diffplug.spotless:spotless-maven-plugin";
    private final String value;

    private PluginFingerprint(String value) {
        this.value = value;
    }

    static PluginFingerprint from(MavenProject project, Iterable<Formatter> formatters) {
        Plugin spotlessPlugin = project.getPlugin(SPOTLESS_PLUGIN_KEY);
        if (spotlessPlugin == null) {
            throw new IllegalArgumentException("Spotless plugin absent from the project: " + project);
        }
        byte[] digest = PluginFingerprint.digest(spotlessPlugin, formatters);
        String value = Base64.getEncoder().encodeToString(digest);
        return new PluginFingerprint(value);
    }

    static PluginFingerprint from(String value) {
        return new PluginFingerprint(value);
    }

    static PluginFingerprint empty() {
        return new PluginFingerprint("");
    }

    String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginFingerprint that = (PluginFingerprint)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "PluginFingerprint[" + this.value + "]";
    }

    private static byte[] digest(Plugin plugin, Iterable<Formatter> formatters) {
        List dependencies = plugin.getDependencies();
        plugin.setDependencies(new ArrayList(dependencies));
        try {
            Object object;
            block12: {
                ObjectDigestOutputStream out = ObjectDigestOutputStream.create();
                try {
                    out.writeObject(plugin);
                    for (Formatter formatter : formatters) {
                        out.writeObject(formatter);
                    }
                    out.flush();
                    object = out.digest();
                    if (out == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Unable to serialize plugin " + plugin, e);
                    }
                }
                out.close();
            }
            return object;
        }
        finally {
            plugin.setDependencies(dependencies);
        }
    }
}

