/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.paypal.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.api.BasePayService;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.bean.CurType;
import com.egzosn.pay.common.bean.DefaultCurType;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpHeader;
import com.egzosn.pay.common.http.HttpStringEntity;
import com.egzosn.pay.common.util.Util;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.paypal.api.PayPalConfigStorage;
import com.egzosn.pay.paypal.bean.PayPalTransactionType;
import com.egzosn.pay.paypal.bean.order.Amount;
import com.egzosn.pay.paypal.bean.order.Links;
import com.egzosn.pay.paypal.bean.order.Payer;
import com.egzosn.pay.paypal.bean.order.Payment;
import com.egzosn.pay.paypal.bean.order.RedirectUrls;
import com.egzosn.pay.paypal.bean.order.Transaction;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;

public class PayPalPayService
extends BasePayService<PayPalConfigStorage> {
    private static final String SANDBOX_REQ_URL = "https://api.sandbox.paypal.com/v1/";
    private static final String REQ_URL = "https://api.paypal.com/v1/";

    public String getReqUrl(TransactionType transactionType) {
        return (((PayPalConfigStorage)this.payConfigStorage).isTest() ? SANDBOX_REQ_URL : REQ_URL) + transactionType.getMethod();
    }

    public PayPalPayService(PayPalConfigStorage payConfigStorage) {
        super((PayConfigStorage)payConfigStorage);
    }

    public String getAccessToken() {
        return this.getAccessToken(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken(boolean forceRefresh) throws PayErrorException {
        block6: {
            Lock lock = ((PayPalConfigStorage)this.payConfigStorage).getAccessTokenLock();
            try {
                lock.lock();
                if (forceRefresh) {
                    ((PayPalConfigStorage)this.payConfigStorage).expireAccessToken();
                }
                if (!((PayPalConfigStorage)this.payConfigStorage).isAccessTokenExpired()) break block6;
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("Authorization", "Basic " + this.authorizationString(((PayPalConfigStorage)this.getPayConfigStorage()).getAppid(), ((PayPalConfigStorage)this.getPayConfigStorage()).getKeyPrivate()));
                header.put("Accept", "application/json");
                header.put("Content-Type", "application/x-www-form-urlencoded");
                try {
                    HttpStringEntity entity = new HttpStringEntity("grant_type=client_credentials", header);
                    JSONObject resp = (JSONObject)this.getHttpRequestTemplate().postForObject(this.getReqUrl(PayPalTransactionType.AUTHORIZE), (Object)entity, JSONObject.class, new Object[0]);
                    ((PayPalConfigStorage)this.payConfigStorage).updateAccessToken(String.format("%s %s", resp.getString("token_type"), resp.getString("access_token")), resp.getIntValue("expires_in"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new PayErrorException((PayError)new PayException("failure", e.getMessage()));
                }
                String string = ((PayPalConfigStorage)this.payConfigStorage).getAccessToken();
                return string;
            }
            finally {
                lock.unlock();
            }
        }
        return ((PayPalConfigStorage)this.payConfigStorage).getAccessToken();
    }

    public boolean verify(Map<String, Object> params) {
        HttpStringEntity httpEntity = new HttpStringEntity("{\"payer_id\":\"" + (String)params.get("PayerID") + "\"}", ContentType.APPLICATION_JSON);
        httpEntity.setHeaders(this.authHeader());
        JSONObject resp = (JSONObject)this.getHttpRequestTemplate().postForObject(this.getReqUrl(PayPalTransactionType.EXECUTE), (Object)httpEntity, JSONObject.class, new Object[]{(String)params.get("paymentId")});
        return "approved".equals(resp.getString("state"));
    }

    public boolean signVerify(Map<String, Object> params, String sign) {
        return true;
    }

    public boolean verifySource(String id) {
        return true;
    }

    private HttpHeader authHeader() {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("Authorization", this.getAccessToken()));
        headers.add(new BasicHeader("PayPal-Request-Id", UUID.randomUUID().toString()));
        return new HttpHeader(headers);
    }

    public Map<String, Object> orderInfo(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)PayPalTransactionType.sale);
        }
        Amount amount = new Amount();
        if (null == order.getCurType()) {
            order.setCurType((CurType)DefaultCurType.USD);
        }
        amount.setCurrency(order.getCurType().getType());
        amount.setTotal(Util.conversionAmount((BigDecimal)order.getPrice()).toString());
        Transaction transaction = new Transaction();
        if (!StringUtils.isEmpty((CharSequence)order.getSubject())) {
            transaction.setDescription(order.getSubject());
        } else {
            transaction.setDescription(order.getBody());
        }
        transaction.setAmount(amount);
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        transactions.add(transaction);
        Payer payer = new Payer();
        payer.setPaymentMethod("paypal");
        Payment payment = new Payment();
        payment.setIntent(order.getTransactionType().getType());
        payment.setPayer(payer);
        payment.setTransactions(transactions);
        RedirectUrls redirectUrls = new RedirectUrls();
        redirectUrls.setCancelUrl(((PayPalConfigStorage)this.payConfigStorage).getNotifyUrl());
        redirectUrls.setReturnUrl(((PayPalConfigStorage)this.payConfigStorage).getReturnUrl());
        payment.setRedirectUrls(redirectUrls);
        HttpStringEntity entity = new HttpStringEntity(JSON.toJSONString((Object)payment), ContentType.APPLICATION_JSON);
        entity.setHeaders(this.authHeader());
        JSONObject resp = (JSONObject)this.getHttpRequestTemplate().postForObject(this.getReqUrl(order.getTransactionType()), (Object)entity, JSONObject.class, new Object[0]);
        if ("created".equals(resp.getString("state")) && StringUtils.isNotEmpty((CharSequence)resp.getString("id"))) {
            order.setOutTradeNo(resp.getString("id"));
        }
        return this.preOrderHandler((Map)resp, order);
    }

    public PayOutMessage getPayOutMessage(String code, String message) {
        return PayOutMessage.TEXT().content(code).build();
    }

    public PayOutMessage successPayOutMessage(PayMessage payMessage) {
        return PayOutMessage.TEXT().content("success").build();
    }

    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        if (orderInfo instanceof JSONObject) {
            Payment payment = (Payment)((JSONObject)orderInfo).toJavaObject(Payment.class);
            for (Links links : payment.getLinks()) {
                if (!links.getRel().equals("approval_url")) continue;
                return String.format("<script type=\"text/javascript\">location.href=\"%s\"</script>", links.getHref());
            }
        }
        return "<script type=\"text/javascript\">location.href=\"/\"</script>";
    }

    public String getQrPay(PayOrder order) {
        return null;
    }

    public Map<String, Object> microPay(PayOrder order) {
        return null;
    }

    public Map<String, Object> query(String tradeNo, String outTradeNo) {
        JSONObject resp = (JSONObject)this.getHttpRequestTemplate().getForObject(this.getReqUrl(PayPalTransactionType.ORDERS), this.authHeader(), JSONObject.class, new Object[]{tradeNo});
        return resp;
    }

    public Map<String, Object> close(String tradeNo, String outTradeNo) {
        return null;
    }

    public Map<String, Object> refund(RefundOrder refundOrder) {
        JSONObject request = new JSONObject();
        if (null != refundOrder.getRefundAmount() && BigDecimal.ZERO.compareTo(refundOrder.getRefundAmount()) == -1) {
            Amount amount = new Amount();
            if (null == refundOrder.getCurType()) {
                refundOrder.setCurType((CurType)DefaultCurType.USD);
            }
            amount.setCurrency(refundOrder.getCurType().getType());
            amount.setTotal(Util.conversionAmount((BigDecimal)refundOrder.getRefundAmount()).toString());
            request.put("amount", (Object)amount);
            request.put("description", (Object)refundOrder.getDescription());
        }
        HttpStringEntity httpEntity = new HttpStringEntity(request.toJSONString(), ContentType.APPLICATION_JSON);
        httpEntity.setHeaders(this.authHeader());
        JSONObject resp = (JSONObject)this.getHttpRequestTemplate().postForObject(this.getReqUrl(PayPalTransactionType.REFUND), (Object)httpEntity, JSONObject.class, new Object[]{refundOrder.getTradeNo()});
        return resp;
    }

    public Map<String, Object> refundquery(RefundOrder refundOrder) {
        JSONObject resp = (JSONObject)this.getHttpRequestTemplate().getForObject(this.getReqUrl(PayPalTransactionType.REFUND_QUERY), this.authHeader(), JSONObject.class, new Object[]{refundOrder.getTradeNo()});
        return resp;
    }

    public Map<String, Object> downloadbill(Date billDate, String billType) {
        return Collections.emptyMap();
    }

    public Map<String, Object> secondaryInterface(Object tradeNoOrBillDate, String outTradeNoBillType, TransactionType transactionType) {
        return Collections.emptyMap();
    }
}

