/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.api;

import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.api.BasePayService;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.common.bean.TransferType;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.util.DateUtils;
import com.egzosn.pay.common.util.Util;
import com.egzosn.pay.common.util.XML;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.sign.encrypt.RSA2;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.api.WxPayConfigStorage;
import com.egzosn.pay.wx.bean.WxPayError;
import com.egzosn.pay.wx.bean.WxPayMessage;
import com.egzosn.pay.wx.bean.WxTransactionType;
import com.egzosn.pay.wx.bean.WxTransferType;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class WxPayService
extends BasePayService<WxPayConfigStorage> {
    public static final String URI = "https://api.mch.weixin.qq.com/";
    public static final String SANDBOXNEW = "sandboxnew/";
    public static final String SUCCESS = "SUCCESS";
    public static final String RETURN_CODE = "return_code";
    public static final String SIGN = "sign";
    public static final String CIPHER_ALGORITHM = "RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING";
    public static final String FAILURE = "failure";
    public static final String APPID = "appid";
    private static final String HMAC_SHA256 = "HMAC-SHA256";
    private static final String HMACSHA256 = "HMACSHA256";
    private static final String RETURN_MSG_CODE = "return_msg";
    private static final String RESULT_CODE = "result_code";
    private static final String MCH_ID = "mch_id";
    private static final String NONCE_STR = "nonce_str";

    public WxPayService(WxPayConfigStorage payConfigStorage) {
        super((PayConfigStorage)payConfigStorage);
    }

    public WxPayService(WxPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super((PayConfigStorage)payConfigStorage, configStorage);
    }

    public BasePayService setPayConfigStorage(WxPayConfigStorage payConfigStorage) {
        String signType = payConfigStorage.getSignType();
        if (HMAC_SHA256.equals(signType)) {
            payConfigStorage.setSignType(HMACSHA256);
        }
        this.payConfigStorage = payConfigStorage;
        return this;
    }

    public String getReqUrl(TransactionType transactionType) {
        return URI + (((WxPayConfigStorage)this.payConfigStorage).isTest() ? SANDBOXNEW : "") + transactionType.getMethod();
    }

    public boolean verify(Map<String, Object> params) {
        if (!SUCCESS.equals(params.get(RETURN_CODE)) || !SUCCESS.equals(params.get(RESULT_CODE))) {
            this.LOG.debug((Object)String.format("\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38\uff1areturn_code=%s,\u53c2\u6570\u96c6=%s", params.get(RETURN_CODE), params));
            return false;
        }
        if (null == params.get(SIGN)) {
            this.LOG.debug((Object)("\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38\uff1a\u7b7e\u540d\u4e3a\u7a7a\uff01out_trade_no=" + params.get("out_trade_no")));
            return false;
        }
        try {
            return this.signVerify(params, (String)params.get(SIGN)) && this.verifySource((String)params.get("out_trade_no"));
        }
        catch (PayErrorException e) {
            this.LOG.error((Object)e);
            return false;
        }
    }

    public boolean verifySource(String id) {
        return true;
    }

    public boolean signVerify(Map<String, Object> params, String sign) {
        return this.signVerify(params, sign, ((WxPayConfigStorage)this.payConfigStorage).isTest());
    }

    private boolean signVerify(Map<String, Object> params, String sign, boolean isTest) {
        SignUtils signUtils = SignUtils.valueOf((String)((WxPayConfigStorage)this.payConfigStorage).getSignType());
        String keyPrivate = ((WxPayConfigStorage)this.payConfigStorage).getKeyPrivate();
        if (isTest) {
            keyPrivate = this.getKeyPrivate();
        }
        String content = SignUtils.parameterText(params, (String)"&", (String[])new String[]{SIGN, "appId"}) + "&key=" + (signUtils == SignUtils.MD5 ? "" : keyPrivate);
        return signUtils.verify(content, sign, keyPrivate, ((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
    }

    private Map<String, Object> getPublicParameters() {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put(APPID, ((WxPayConfigStorage)this.payConfigStorage).getAppid());
        parameters.put(MCH_ID, ((WxPayConfigStorage)this.payConfigStorage).getMchId());
        if (!StringUtils.isEmpty((CharSequence)((WxPayConfigStorage)this.payConfigStorage).getSubMchId())) {
            parameters.put("sub_mch_id", ((WxPayConfigStorage)this.payConfigStorage).getSubMchId());
        }
        if (!StringUtils.isEmpty((CharSequence)((WxPayConfigStorage)this.payConfigStorage).getSubAppid())) {
            parameters.put("sub_appid", ((WxPayConfigStorage)this.payConfigStorage).getSubAppid());
        }
        parameters.put(NONCE_STR, SignUtils.randomStr());
        return parameters;
    }

    public JSONObject unifiedOrder(PayOrder order) {
        JSONObject result;
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("body", order.getSubject());
        parameters.put("out_trade_no", order.getOutTradeNo());
        parameters.put("spbill_create_ip", StringUtils.isEmpty((CharSequence)order.getSpbillCreateIp()) ? "192.168.1.150" : order.getSpbillCreateIp());
        parameters.put("total_fee", Util.conversionCentAmount((BigDecimal)order.getPrice()));
        if (StringUtils.isNotEmpty((CharSequence)order.getAddition())) {
            parameters.put("attach", order.getAddition());
        }
        parameters.put("notify_url", ((WxPayConfigStorage)this.payConfigStorage).getNotifyUrl());
        parameters.put("trade_type", order.getTransactionType().getType());
        if (null != order.getExpirationTime()) {
            parameters.put("time_start", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            parameters.put("time_expire", DateUtils.formatDate((Date)order.getExpirationTime(), (String)"yyyyMMddHHmmss"));
        }
        ((WxTransactionType)order.getTransactionType()).setAttribute(parameters, order);
        this.setSign(parameters);
        String requestXML = XML.getMap2Xml(parameters);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("requestXML\uff1a" + requestXML));
        }
        if (!SUCCESS.equals((result = (JSONObject)this.requestTemplate.postForObject(this.getReqUrl(order.getTransactionType()), (Object)requestXML, JSONObject.class, new Object[0])).get((Object)RETURN_CODE)) || !SUCCESS.equals(result.get((Object)RESULT_CODE))) {
            throw new PayErrorException((PayError)new WxPayError(result.getString(RESULT_CODE), result.getString(RETURN_MSG_CODE), result.toJSONString()));
        }
        return result;
    }

    public Map<String, Object> orderInfo(PayOrder order) {
        JSONObject result = this.unifiedOrder(order);
        if (this.verify((Map<String, Object>)result)) {
            if (((WxTransactionType)order.getTransactionType()).isReturn()) {
                return result;
            }
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            if (WxTransactionType.JSAPI == order.getTransactionType()) {
                params.put("signType", ((WxPayConfigStorage)this.payConfigStorage).getSignType());
                params.put("appId", ((WxPayConfigStorage)this.payConfigStorage).getAppid());
                params.put("timeStamp", System.currentTimeMillis() / 1000L);
                params.put("nonceStr", result.get((Object)NONCE_STR));
                params.put("package", "prepay_id=" + result.get((Object)"prepay_id"));
            } else if (WxTransactionType.APP == order.getTransactionType()) {
                params.put("partnerid", ((WxPayConfigStorage)this.payConfigStorage).getPid());
                params.put(APPID, ((WxPayConfigStorage)this.payConfigStorage).getAppid());
                params.put("prepayid", result.get((Object)"prepay_id"));
                params.put("timestamp", System.currentTimeMillis() / 1000L);
                params.put("noncestr", result.get((Object)NONCE_STR));
                params.put("package", "Sign=WXPay");
            }
            String paySign = this.createSign(SignUtils.parameterText(params), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
            params.put(SIGN, paySign);
            return params;
        }
        throw new PayErrorException((PayError)new WxPayError(result.getString(RETURN_CODE), result.getString(RETURN_MSG_CODE), "Invalid sign value"));
    }

    private Map<String, Object> setSign(Map<String, Object> parameters) {
        String signType = ((WxPayConfigStorage)this.payConfigStorage).getSignType();
        if (HMACSHA256.equals(signType)) {
            signType = HMAC_SHA256;
        }
        parameters.put("sign_type", signType);
        String sign = this.createSign(SignUtils.parameterText(parameters, (String)"&", (String[])new String[]{SIGN, "appId"}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
        parameters.put(SIGN, sign);
        return parameters;
    }

    private String getKeyPrivate() {
        if (!((WxPayConfigStorage)this.payConfigStorage).isTest()) {
            return ((WxPayConfigStorage)this.payConfigStorage).getKeyPrivate();
        }
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put(MCH_ID, ((WxPayConfigStorage)this.payConfigStorage).getMchId());
        parameters.put(NONCE_STR, SignUtils.randomStr());
        String sign = this.createSign(SignUtils.parameterText(parameters, (String)"&", (String[])new String[]{SIGN, "appId"}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset(), false);
        parameters.put(SIGN, sign);
        JSONObject result = (JSONObject)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.GETSIGNKEY), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
        if (SUCCESS.equals(result.get((Object)RETURN_CODE))) {
            return result.getString("sandbox_signkey");
        }
        this.LOG.error((Object)"\u83b7\u53d6sandbox_signkey\u5931\u8d25", (Throwable)new PayErrorException((PayError)new PayException(result.getString(RETURN_CODE), result.getString(RETURN_MSG_CODE), result.toJSONString())));
        return null;
    }

    public String createSign(String content, String characterEncoding) {
        return this.createSign(content, characterEncoding, ((WxPayConfigStorage)this.payConfigStorage).isTest());
    }

    public String createSign(String content, String characterEncoding, boolean test) {
        SignUtils signUtils = SignUtils.valueOf((String)((WxPayConfigStorage)this.payConfigStorage).getSignType().toUpperCase());
        String keyPrivate = ((WxPayConfigStorage)this.payConfigStorage).getKeyPrivate();
        if (test) {
            keyPrivate = this.getKeyPrivate();
        }
        return signUtils.createSign(content + "&key=" + (signUtils == SignUtils.MD5 ? "" : keyPrivate), keyPrivate, characterEncoding).toUpperCase();
    }

    public Map<String, Object> getParameter2Map(Map<String, String[]> parameterMap, InputStream is) {
        TreeMap map = new TreeMap();
        try {
            return XML.inputStream2Map((InputStream)is, map);
        }
        catch (IOException e) {
            throw new PayErrorException((PayError)new PayException("IOException", e.getMessage()));
        }
    }

    public PayOutMessage getPayOutMessage(String code, String message) {
        return PayOutMessage.XML().code(code.toUpperCase()).content(message).build();
    }

    public PayOutMessage successPayOutMessage(PayMessage payMessage) {
        return PayOutMessage.XML().code("Success").content("\u6210\u529f").build();
    }

    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        if (!SUCCESS.equals(orderInfo.get(RETURN_CODE))) {
            throw new PayErrorException((PayError)new WxPayError((String)orderInfo.get(RETURN_CODE), (String)orderInfo.get(RETURN_MSG_CODE)));
        }
        if (WxTransactionType.MWEB.name().equals(orderInfo.get("trade_type"))) {
            return String.format("<script type=\"text/javascript\">location.href=\"%s%s\"</script>", orderInfo.get("mweb_url"), StringUtils.isEmpty((CharSequence)((WxPayConfigStorage)this.payConfigStorage).getReturnUrl()) ? "" : "&redirect_url=" + URLEncoder.encode(((WxPayConfigStorage)this.payConfigStorage).getReturnUrl()));
        }
        throw new UnsupportedOperationException();
    }

    public String getQrPay(PayOrder order) {
        Map<String, Object> orderInfo = this.orderInfo(order);
        if (!SUCCESS.equals(orderInfo.get(RESULT_CODE))) {
            throw new PayErrorException((PayError)new WxPayError((String)orderInfo.get("err_code"), orderInfo.toString()));
        }
        return (String)orderInfo.get("code_url");
    }

    public Map<String, Object> microPay(PayOrder order) {
        return this.orderInfo(order);
    }

    public Map<String, Object> query(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.QUERY);
    }

    public Map<String, Object> close(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.CLOSE);
    }

    public Map<String, Object> cancel(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.REVERSE);
    }

    @Deprecated
    public Map<String, Object> refund(String transactionId, String outTradeNo, BigDecimal refundAmount, BigDecimal totalAmount) {
        return this.refund(new RefundOrder(transactionId, outTradeNo, refundAmount, totalAmount));
    }

    private Map<String, Object> setParameters(Map<String, Object> parameters, String key, String value) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            parameters.put(key, value);
        }
        return parameters;
    }

    public Map<String, Object> refund(RefundOrder refundOrder) {
        Map<String, Object> parameters = this.getPublicParameters();
        this.setParameters(parameters, "transaction_id", refundOrder.getTradeNo());
        this.setParameters(parameters, "out_trade_no", refundOrder.getOutTradeNo());
        this.setParameters(parameters, "out_refund_no", refundOrder.getRefundNo());
        parameters.put("total_fee", Util.conversionCentAmount((BigDecimal)refundOrder.getTotalAmount()));
        parameters.put("refund_fee", Util.conversionCentAmount((BigDecimal)refundOrder.getRefundAmount()));
        parameters.put("op_user_id", ((WxPayConfigStorage)this.payConfigStorage).getPid());
        this.setParameters(parameters, "notify_url", ((WxPayConfigStorage)this.payConfigStorage).getNotifyUrl());
        this.setSign(parameters);
        return (Map)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.REFUND), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> refundquery(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.REFUNDQUERY);
    }

    public Map<String, Object> refundquery(RefundOrder refundOrder) {
        Map<String, Object> parameters = this.getPublicParameters();
        this.setParameters(parameters, "transaction_id", refundOrder.getTradeNo());
        this.setParameters(parameters, "out_trade_no", refundOrder.getOutTradeNo());
        this.setParameters(parameters, "out_refund_no", refundOrder.getRefundNo());
        this.setSign(parameters);
        return (Map)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.REFUNDQUERY), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> downloadbill(Date billDate, String billType) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("bill_type", billType);
        parameters.put("bill_date", DateUtils.formatDate((Date)billDate, (String)"yyyyMMdd"));
        this.setSign(parameters);
        String respStr = (String)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.DOWNLOADBILL), (Object)XML.getMap2Xml(parameters), String.class, new Object[0]);
        if (respStr.indexOf("<") == 0) {
            return XML.toJSONObject((String)respStr);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(3);
        ret.put(RETURN_CODE, SUCCESS);
        ret.put(RETURN_MSG_CODE, "ok");
        ret.put("data", respStr);
        return ret;
    }

    public Map<String, Object> secondaryInterface(Object transactionIdOrBillDate, String outTradeNoBillType, TransactionType transactionType) {
        if (transactionType == WxTransactionType.REFUND) {
            throw new PayErrorException((PayError)new PayException(FAILURE, "\u901a\u7528\u63a5\u53e3\u4e0d\u652f\u6301:" + transactionType));
        }
        if (transactionType == WxTransactionType.DOWNLOADBILL) {
            if (transactionIdOrBillDate instanceof Date) {
                return this.downloadbill((Date)transactionIdOrBillDate, outTradeNoBillType);
            }
            throw new PayErrorException((PayError)new PayException(FAILURE, "\u975e\u6cd5\u7c7b\u578b\u5f02\u5e38:" + transactionIdOrBillDate.getClass()));
        }
        if (null != transactionIdOrBillDate && !(transactionIdOrBillDate instanceof String)) {
            throw new PayErrorException((PayError)new PayException(FAILURE, "\u975e\u6cd5\u7c7b\u578b\u5f02\u5e38:" + transactionIdOrBillDate.getClass()));
        }
        Map<String, Object> parameters = this.getPublicParameters();
        if (StringUtils.isEmpty((CharSequence)((String)transactionIdOrBillDate))) {
            parameters.put("out_trade_no", outTradeNoBillType);
        } else {
            parameters.put("transaction_id", transactionIdOrBillDate);
        }
        this.setSign(parameters);
        return (Map)this.requestTemplate.postForObject(this.getReqUrl(transactionType), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> transfer(TransferOrder order) {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("partner_trade_no", order.getOutNo());
        parameters.put("amount", Util.conversionCentAmount((BigDecimal)order.getAmount()));
        if (!StringUtils.isEmpty((CharSequence)order.getRemark())) {
            parameters.put("desc", order.getRemark());
        }
        parameters.put(NONCE_STR, SignUtils.randomStr());
        if (null != order.getTransferType() && WxTransferType.TRANSFERS == order.getTransferType()) {
            this.transfers(parameters, order);
            parameters.put("mchid", ((WxPayConfigStorage)this.payConfigStorage).getPid());
        } else {
            parameters.put(MCH_ID, ((WxPayConfigStorage)this.payConfigStorage).getPid());
            order.setTransferType((TransferType)WxTransferType.PAY_BANK);
            this.payBank(parameters, order);
        }
        parameters.put(SIGN, this.createSign(SignUtils.parameterText(parameters, (String)"&", (String[])new String[]{SIGN}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset()));
        return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl((TransactionType)order.getTransferType()), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> transfers(Map<String, Object> parameters, TransferOrder order) {
        parameters.put("mch_appid", ((WxPayConfigStorage)this.payConfigStorage).getAppid());
        parameters.put("openid", order.getPayeeAccount());
        parameters.put("spbill_create_ip", StringUtils.isEmpty((CharSequence)order.getIp()) ? "192.168.1.150" : order.getIp());
        parameters.put("check_name", "NO_CHECK");
        if (!StringUtils.isEmpty((CharSequence)order.getPayeeName())) {
            parameters.put("check_name", "FORCE_CHECK");
            parameters.put("re_user_name", order.getPayeeName());
        }
        return parameters;
    }

    public Map<String, Object> payBank(Map<String, Object> parameters, TransferOrder order) {
        parameters.put("enc_bank_no", this.keyPublic(order.getPayeeAccount()));
        parameters.put("enc_true_name", this.keyPublic(order.getPayeeName()));
        parameters.put("bank_code", order.getBank().getCode());
        return parameters;
    }

    public Map<String, Object> transferQuery(String outNo, String wxTransferType) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put(MCH_ID, ((WxPayConfigStorage)this.payConfigStorage).getPid());
        parameters.put("partner_trade_no", outNo);
        parameters.put(NONCE_STR, SignUtils.randomStr());
        parameters.put(SIGN, this.createSign(SignUtils.parameterText(parameters, (String)"&", (String[])new String[]{SIGN}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset()));
        if (StringUtils.isEmpty((CharSequence)wxTransferType)) {
            throw new PayErrorException((PayError)new WxPayError(FAILURE, "\u5fae\u4fe1\u8f6c\u8d26\u7c7b\u578b #transferQuery(String outNo, String wxTransferType) \u5fc5\u586b\uff0c\u8be6\u60c5com.egzosn.pay.wx.bean.WxTransferType"));
        }
        if (WxTransferType.TRANSFERS.getType().equals(wxTransferType) || WxTransferType.GETTRANSFERINFO.getType().equals(wxTransferType)) {
            return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl((TransactionType)WxTransferType.GETTRANSFERINFO), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
        }
        return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl((TransactionType)WxTransferType.QUERY_BANK), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    public String keyPublic(String content) {
        try {
            return RSA2.encrypt((String)content, (String)((WxPayConfigStorage)this.payConfigStorage).getKeyPublic(), (String)CIPHER_ALGORITHM, (String)((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
        }
        catch (Exception e) {
            throw new PayErrorException((PayError)new WxPayError(FAILURE, e.getLocalizedMessage()));
        }
    }

    public PayMessage createMessage(Map<String, Object> message) {
        return WxPayMessage.create(message);
    }
}

