/*
 * Decompiled with CFR 0.152.
 */
package com.els.cxf.interceptor;

import com.els.annotation.Permission;
import com.els.service.AccountResourceService;
import com.els.service.I18nService;
import com.els.util.SpringContextHelper;
import com.els.vo.AccountAgentVO;
import com.els.vo.I18nVO;
import com.els.vo.SubAccountVO;
import com.els.web.filter.ContextFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class PermissionInterceptor
extends AbstractPhaseInterceptor<Message> {
    public PermissionInterceptor() {
        super("pre-invoke");
    }

    public PermissionInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message arg0) throws Fault {
        Permission permission;
        List content;
        String elsSubAccount;
        String elsAccount;
        OperationResourceInfo resourceInfo = (OperationResourceInfo)arg0.getExchange().get((Object)"org.apache.cxf.jaxrs.model.OperationResourceInfo");
        Method annotatedMethod = resourceInfo.getAnnotatedMethod();
        String operation = annotatedMethod.getName();
        if ("findMyChatMessage".equals(operation) || "findMyFriendsRequestMsg".equals(operation) || "findMyUnreadChatMessage".equals(operation) || "findMyFriendsRequestNotice".equals(operation) || "getMsg".equals(operation) || "handleMsg".equals(operation)) {
            return;
        }
        HttpServletRequest request = ContextFilter.context.get();
        if ("findSubaccount".equals(operation)) {
            elsAccount = request.getSession().getAttribute("elsAccount").toString();
            elsSubAccount = request.getSession().getAttribute("elsSubAccount").toString();
            content = (List)arg0.getContent(List.class);
            if (elsAccount.equals(content.get(0)) && elsSubAccount.equals(content.get(1))) {
                return;
            }
        }
        if ("updateSubaccount".equals(operation)) {
            elsAccount = request.getSession().getAttribute("elsAccount").toString();
            elsSubAccount = request.getSession().getAttribute("elsSubAccount").toString();
            content = (List)arg0.getContent(List.class);
            SubAccountVO subAccountVO = (SubAccountVO)content.get(0);
            if (elsAccount.equals(subAccountVO.getElsAccount()) && elsSubAccount.equals(subAccountVO.getElsSubAccount())) {
                return;
            }
        }
        if ((permission = annotatedMethod.getAnnotation(Permission.class)) != null) {
            String elsAccount2 = request.getSession().getAttribute("elsAccount").toString();
            String elsSubAccount2 = request.getSession().getAttribute("elsSubAccount").toString();
            AccountResourceService accountResourceService = (AccountResourceService)SpringContextHelper.getBean((String)"accountResourceServiceImpl");
            AccountAgentVO agentVo = new AccountAgentVO();
            List isAgent = new ArrayList();
            if (!StringUtils.isEmpty((String)elsSubAccount2)) {
                agentVo.setElsAccount(elsAccount2);
                agentVo.setAgentSubAccount(elsSubAccount2);
                isAgent = accountResourceService.isAgent(agentVo);
            }
            boolean isAgentFlag = false;
            for (AccountAgentVO vo : isAgent) {
                List lstAgentPermission = accountResourceService.getAccountResource(elsAccount2, vo.getElsSubAccount());
                if (!"1001".equals(vo.getElsSubAccount()) && !lstAgentPermission.contains(String.valueOf(permission.module().split(":")[0]) + "-" + permission.privilege())) continue;
                isAgentFlag = true;
                break;
            }
            List lstPermission = accountResourceService.getAccountResource(elsAccount2, elsSubAccount2);
            String isAdmin = request.getSession().getAttribute("isAdmin").toString();
            if (!(isAdmin.equals("Y") || "1001".equals(elsSubAccount2) || lstPermission.contains(String.valueOf(permission.module().split(":")[0]) + "-" + permission.privilege()) || isAgentFlag)) {
                throw new Fault((Throwable)new IllegalArgumentException(String.valueOf(this.getI18n("i18n_msg_nothave", "\u60a8\u6ca1\u6709")) + this.getI18n("i18n_res_" + permission.module().split(":")[0] + "_" + permission.privilege(), "(" + permission.module().split(":")[1] + "-" + permission.description() + ")\u6b64\u64cd\u4f5c") + this.getI18n("i18n_msg_nothaveend", "\u7684\u6743\u9650\uff0c\u8bf7\u4e0e1001\u8d26\u53f7\u7ba1\u7406\u5458\u8054\u7cfb\uff01")));
            }
        }
    }

    private String getI18n(String key, String defaultValue) {
        I18nVO i18nVO;
        I18nService i18nService = (I18nService)SpringContextHelper.getBean((String)"i18nServiceImpl");
        String error = defaultValue;
        Response response = i18nService.getResourceByKey(key);
        if (response.getEntity() instanceof I18nVO && StringUtils.isNotBlank((String)(i18nVO = (I18nVO)response.getEntity()).getValue())) {
            error = i18nVO.getValue();
        }
        return error;
    }
}

