/*
 * Decompiled with CFR 0.152.
 */
package com.els.cxf.interceptor;

import com.els.annotation.Permission;
import com.els.service.BaseService;
import com.els.util.IpUtil;
import com.els.util.SpringContextHelper;
import com.els.vo.SystemLogVO;
import com.els.web.filter.ContextFilter;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class SystemLogInterceptor
extends AbstractPhaseInterceptor<Message> {
    public SystemLogInterceptor() {
        super("invoke");
    }

    public SystemLogInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message arg0) throws Fault {
        OperationResourceInfo resourceInfo = (OperationResourceInfo)arg0.getExchange().get((Object)"org.apache.cxf.jaxrs.model.OperationResourceInfo");
        HttpServletRequest request = ContextFilter.context.get();
        if (resourceInfo == null) {
            return;
        }
        if (request.getSession().getAttribute("elsAccount") == null) {
            return;
        }
        Method annotatedMethod = resourceInfo.getAnnotatedMethod();
        Permission permission = annotatedMethod.getAnnotation(Permission.class);
        String elsAccount = request.getSession().getAttribute("elsAccount").toString();
        String elsSubAccount = request.getSession().getAttribute("elsSubAccount") + "_" + request.getSession().getAttribute("username");
        String operation = annotatedMethod.getName();
        if ("getMsg".equals(operation) || "findEnquiryChatMessage".equals(operation) || "findOrderChatMessage".equals(operation) || "findMyChatMessage".equals(operation) || "findMyFriendsRequestMsg".equals(operation) || "findMyUnreadChatMessage".equals(operation) || "findMyFriendsRequestNotice".equals(operation)) {
            return;
        }
        if ("login".equals(operation)) {
            return;
        }
        if ("findMyFriendsGroup".equals(operation) || "findMyFriendsGroupBbyGroupA".equals(operation) || "findMyFriends".equals(operation) || "getAllResource".equals(operation)) {
            return;
        }
        if (permission != null) {
            String clientIP = IpUtil.getIpAddr((HttpServletRequest)request);
            String requestURL = request.getRequestURI();
            SystemLogVO logVO = new SystemLogVO();
            logVO.setElsAccount(elsAccount);
            logVO.setElsSubAccount(elsSubAccount);
            logVO.setOperation(operation);
            logVO.setClientIP(clientIP);
            logVO.setRequestURL(requestURL);
            logVO.setLogtime(new Date());
            logVO.setModule(permission.appCode());
            logVO.setDescription(permission.description());
            BaseService baseService = (BaseService)SpringContextHelper.getBean((String)"baseServiceImpl");
            try {
                baseService.log(logVO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

