/*
 * Decompiled with CFR 0.152.
 */
package com.els.cxf.interceptor;

import com.els.web.filter.ContextFilter;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class TimeoutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private long expireTime = 60000L;

    public TimeoutInterceptor() {
        super("pre-invoke");
    }

    public TimeoutInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message arg0) throws Fault {
        String url;
        HttpServletRequest request = ContextFilter.context.get();
        long userExpireTime = 0L;
        if (request.getSession().getAttribute("expireTime") != null) {
            userExpireTime = (Long)request.getSession().getAttribute("expireTime");
        }
        Date curr = new Date();
        if (userExpireTime != 0L && userExpireTime < curr.getTime()) {
            request.getSession().invalidate();
        }
        if ((url = request.getRequestURL().toString()).indexOf("AuditService/getTodoList") > 0) {
            return;
        }
        if (url.indexOf("MsgService/findModuleMsg") > 0) {
            return;
        }
        request.getSession().setAttribute("expireTime", (Object)(curr.getTime() + this.expireTime));
    }
}

