/*
 * Decompiled with CFR 0.152.
 */
package com.els.util;

import com.els.cxf.exception.BusinessException;
import com.els.enumerate.ResponseCodeEnum;
import com.els.util.RSAEnCoderTools;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElsLicense {
    private static Logger logger = LoggerFactory.getLogger(ElsLicense.class);
    private static Map<String, String> licenseCheckMap = new ConcurrentHashMap<String, String>(256, 0.75f);

    public static void staticcheckLicense() {
        String currentDateStr = LocalDate.now().toString();
        String licenseReuslt = null;
        if (licenseCheckMap.containsKey(currentDateStr)) {
            licenseReuslt = licenseCheckMap.get(currentDateStr);
        } else {
            try {
                String path = ElsLicense.class.getClassLoader().getResource("/") + "ElsServer.lic";
                if (path.startsWith("file")) {
                    path = path.substring(5);
                }
                RSAEnCoderTools.checkLicenseFile(path, "", new Date());
                licenseReuslt = ResponseCodeEnum.SUCCESS.getValue();
                licenseCheckMap.put(currentDateStr, licenseReuslt);
            }
            catch (Exception e) {
                licenseReuslt = e.getMessage();
                licenseCheckMap.put(currentDateStr, licenseReuslt);
            }
        }
        if (!ResponseCodeEnum.SUCCESS.getValue().equals(licenseReuslt)) {
            throw new BusinessException(licenseReuslt);
        }
    }
}

