/*
 * Decompiled with CFR 0.152.
 */
package com.els.util;

import com.els.common.SysProperties;
import com.els.cxf.exception.BusinessException;
import com.els.util.Base64;
import com.els.util.RSADeCoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class RSAEnCoderTools {
    private static Properties properties = SysProperties.INSTANCE.getPublicKeysProperties();

    public static boolean checkLicenseFile(String licenseFilePath, String machCode, Date currentDate) throws Exception {
        String expireDay;
        SimpleDateFormat df;
        Date expireDate;
        String module = properties.getProperty("modulus");
        String publicExponent = properties.getProperty("public_exponent");
        String projectName = properties.getProperty("projectName");
        String projectDetial = properties.getProperty("projectDetial");
        PublicKey publicKey = RSADeCoder.getPublicKey(module, publicExponent);
        File licenseFile = new File(licenseFilePath);
        if (!licenseFile.exists()) {
            throw new Exception("\u6ca1\u6709\u83b7\u53d6License\u6587\u4ef6");
        }
        Throwable throwable = null;
        Object var10_11 = null;
        try (FileInputStream fis = FileUtils.openInputStream((File)licenseFile);){
            if (fis.available() == 0) {
                throw new FileNotFoundException("License\u52a0\u5bc6\u6587\u4ef6\u4e3a\u7a7a");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        byte[] encoderData = FileUtils.readFileToByteArray((File)licenseFile);
        byte[] sbytes = RSADeCoder.decryptRSA(encoderData, publicKey);
        byte[] firstEncoderData = null;
        byte[] secondSignData = null;
        int index = 0;
        int len = sbytes.length;
        while (index < len) {
            if (sbytes[index] == 10) {
                firstEncoderData = new byte[index];
                secondSignData = new byte[len - index - 1];
                System.arraycopy(sbytes, 0, firstEncoderData, 0, firstEncoderData.length);
                System.arraycopy(sbytes, index + 1, secondSignData, 0, secondSignData.length);
                if (RSAEnCoderTools.isArrayByteBase64(secondSignData)) break;
            }
            ++index;
        }
        String sign = new String(secondSignData);
        boolean verify = RSADeCoder.verify(firstEncoderData, sign, publicKey);
        if (!verify) {
            throw new BusinessException("License\u7b7e\u540d\u6821\u9a8c\u65e0\u6548,\u8bf7\u786e\u8ba4\u8fd9\u8bc1\u4e66\u7684\u6709\u6548\u6027.");
        }
        byte[] textBytes = RSADeCoder.decryptRSA(firstEncoderData, publicKey);
        HashMap<String, String> prop = RSAEnCoderTools.genDataFromArrayByte(textBytes);
        String licenseType = prop.get("LICENSETYPE");
        if (StringUtils.isEmpty((String)licenseType)) {
            throw new BusinessException("License\u6821\u9a8c\u65e0\u6548,\u65e0\u6cd5\u83b7\u53d6\u8bc1\u4e66\u7c7b\u578b.");
        }
        String licenseKey = prop.get("LICENSEID");
        if (!licenseKey.toUpperCase().startsWith(projectName)) {
            throw new BusinessException("License\u6821\u9a8c\u65e0\u6548,\u8bf7\u786e\u8ba4\u8fd9\u8bc1\u4e66\u7684\u6709\u6548\u6027.");
        }
        String machineCode = prop.get("MACHINECODE");
        String needCheckMachineCode = prop.get("CHECKMACHINECODE");
        if (!"NO".equalsIgnoreCase(needCheckMachineCode) && (StringUtils.isEmpty((String)machineCode) || ("," + machineCode + ",").indexOf("," + machCode + ",") < 0)) {
            throw new BusinessException("License\u6821\u9a8c,\u673a\u5668\u7801\u4e0e\u5f53\u524d\u673a\u5668\u7801\u4e0d\u540c");
        }
        if ("2".equals(licenseType) && currentDate.after(expireDate = (df = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH)).parse(expireDay = prop.get("EXPIREDAY")))) {
            String msg = Base64.getFromBase64((String)projectDetial);
            throw new BusinessException(msg);
        }
        String printClientCount = prop.get("PRINTCLIENTCOUNT");
        if (StringUtils.isEmpty((String)printClientCount)) {
            throw new BusinessException("\u6388\u6743\u6253\u5370\u7ec8\u7aef\u6570\u91cf\u5fc5\u987b\u586b\u5199");
        }
        if (!StringUtils.isNumeric((String)printClientCount.trim())) {
            throw new BusinessException("\u6388\u6743\u6253\u5370\u7ec8\u7aef\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
        }
        return true;
    }

    private static HashMap<String, String> genDataFromArrayByte(byte[] b) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(b)));
        HashMap<String, String> data = new HashMap<String, String>();
        String str = null;
        while ((str = br.readLine()) != null) {
            int pos;
            if (!StringUtils.isNotEmpty((String)str) || (pos = (str = str.trim()).indexOf("=")) <= 0) continue;
            if (str.length() > pos + 1) {
                data.put(str.substring(0, pos).trim().toUpperCase(), str.substring(pos + 1).trim());
                continue;
            }
            data.put(str.substring(0, pos).trim().toUpperCase(), "");
        }
        return data;
    }

    private static boolean isArrayByteBase64(byte[] b) {
        try {
            return org.apache.commons.codec.binary.Base64.isArrayByteBase64((byte[])b);
        }
        catch (Exception e) {
            return false;
        }
    }
}

