/*
 * Decompiled with CFR 0.152.
 */
package com.els.web.filter;

import com.els.common.SysProperties;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(urlPatterns={"/rest/*", "/uflo/*", "/ureport/*"})
public class ContextFilter
implements Filter {
    Logger logger = LoggerFactory.getLogger(ContextFilter.class);
    public static ThreadLocal<HttpServletRequest> context = new ThreadLocal();
    public static ThreadLocal<HttpServletResponse> responseContext = new ThreadLocal();
    public static ThreadLocal<String> sessionId = new ThreadLocal();
    private static Properties properties = SysProperties.INSTANCE.getProperties("enhance.properties");

    public void destroy() {
        context.remove();
        responseContext.remove();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.logger.info("========\u653e\u5165request==========");
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        context.set(req);
        responseContext.set(res);
        if (properties == null) {
            chain.doFilter(request, response);
            return;
        }
        try {
            String uri = req.getRequestURI().toString();
            if (StringUtils.isNotEmpty((CharSequence)uri) && uri.length() > 15 && uri.contains("/rest/")) {
                String[] url = uri.split("/rest/");
                String requestPath = url[1];
                String key = requestPath.substring(0, requestPath.indexOf("Service/") + 7);
                String targetPath = properties.getProperty(key);
                if (StringUtils.isNotEmpty((CharSequence)targetPath)) {
                    requestPath = requestPath.replaceAll(key, targetPath);
                    request.getRequestDispatcher("/rest/" + requestPath).forward(request, response);
                } else {
                    chain.doFilter(request, response);
                }
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Exception e) {
            this.logger.error("RequestDispatcher failed:", (Throwable)e);
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

