/*
 * Decompiled with CFR 0.152.
 */
package com.els.web.filter;

import cn.hutool.core.util.ReUtil;
import com.els.web.filter.XSSSecurityCon;
import com.els.web.filter.XSSSecurityConfig;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSSSecurityManager {
    private static Logger logger = LoggerFactory.getLogger(XSSSecurityManager.class);
    public static String REGEX;
    private static Pattern XSS_PATTERN;

    private XSSSecurityManager() {
    }

    public static void init(String xssPath) {
        logger.info("XSSSecurityManager init(FilterConfig config) begin");
        try {
            if (XSSSecurityManager.initConfig(xssPath)) {
                XSS_PATTERN = Pattern.compile(REGEX);
            }
        }
        catch (DocumentException e) {
            logger.error("\u5b89\u5168\u8fc7\u6ee4\u914d\u7f6e\u6587\u4ef6xss_security_config.xml\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
        }
        logger.info("XSSSecurityManager init(FilterConfig config) end");
    }

    public static boolean initConfig(String path) throws DocumentException {
        StringBuffer tempStr;
        logger.info("XSSSecurityManager.initConfig(String path) begin");
        Element superElement = new SAXReader().read(path).getRootElement();
        XSSSecurityConfig.IS_CHECK_HEADER = new Boolean(XSSSecurityManager.getEleValue(superElement, XSSSecurityCon.IS_CHECK_HEADER));
        XSSSecurityConfig.IS_CHECK_PARAMETER = new Boolean(XSSSecurityManager.getEleValue(superElement, XSSSecurityCon.IS_CHECK_PARAMETER));
        XSSSecurityConfig.IS_LOG = new Boolean(XSSSecurityManager.getEleValue(superElement, XSSSecurityCon.IS_LOG));
        XSSSecurityConfig.IS_CHAIN = new Boolean(XSSSecurityManager.getEleValue(superElement, XSSSecurityCon.IS_CHAIN));
        XSSSecurityConfig.REPLACE = new Boolean(XSSSecurityManager.getEleValue(superElement, XSSSecurityCon.REPLACE));
        Element regexEle = superElement.element(XSSSecurityCon.REGEX_LIST);
        if (regexEle != null) {
            Iterator regexIt = regexEle.elementIterator();
            tempStr = new StringBuffer("^");
            while (regexIt.hasNext()) {
                Element regex = (Element)regexIt.next();
                String tmp = regex.getText();
                tmp = tmp.replaceAll("\\\\\\\\", "\\\\");
                tempStr.append(tmp);
                tempStr.append("|");
            }
            if (tempStr.charAt(tempStr.length() - 1) != '|') {
                logger.error("\u5b89\u5168\u8fc7\u6ee4\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25:\u6b63\u5219\u8868\u8fbe\u5f0f\u5f02\u5e38 " + tempStr.toString());
                return false;
            }
        } else {
            logger.error("\u5b89\u5168\u8fc7\u6ee4\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ca1\u6709 " + XSSSecurityCon.REGEX_LIST + " \u5c5e\u6027");
            return false;
        }
        REGEX = String.valueOf(tempStr.substring(0, tempStr.length() - 1)) + "$";
        logger.info("\u5b89\u5168\u5339\u914d\u89c4\u5219" + REGEX);
        logger.info("XSSSecurityManager.initConfig(String path) end");
        return true;
    }

    private static String getEleValue(Element element, String tagName) {
        if (XSSSecurityManager.isNullStr(element.elementText(tagName))) {
            logger.error("\u5b89\u5168\u8fc7\u6ee4\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ca1\u6709 " + XSSSecurityCon.REGEX_LIST + " \u5c5e\u6027");
        }
        return element.elementText(tagName);
    }

    public static String securityReplace(String text) {
        if (XSSSecurityManager.isNullStr(text)) {
            return text;
        }
        if (ReUtil.isMatch((Pattern)XSS_PATTERN, (String)text)) {
            return ReUtil.replaceAll((String)text, (Pattern)XSS_PATTERN, (String)XSSSecurityCon.REPLACEMENT);
        }
        return text;
    }

    public static boolean matches(String text) {
        if (text == null) {
            return false;
        }
        return XSS_PATTERN.matcher(text).matches();
    }

    public static void destroy() {
        logger.info("XSSSecurityManager.destroy() begin");
        XSS_PATTERN = null;
        REGEX = null;
        logger.info("XSSSecurityManager.destroy() end");
    }

    public static boolean isNullStr(String value) {
        return value == null || value.trim().equals("");
    }
}

