/*
 * Decompiled with CFR 0.152.
 */
package com.els.web.filter;

import com.els.web.filter.XSSSecurityConfig;
import com.els.web.filter.XSSSecurityManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    HttpServletRequest orgRequest = null;
    boolean isUpData = false;

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.orgRequest = request;
        String contentType = request.getContentType();
        if (contentType != null) {
            this.isUpData = contentType.startsWith("multipart");
        }
    }

    public String getQueryString() {
        return XssHttpServletRequestWrapper.xssEncode(super.getQueryString());
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (value != null && value instanceof String) {
            value = XssHttpServletRequestWrapper.xssEncode((String)value);
        }
        return value;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.isUpData) {
            return super.getInputStream();
        }
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.inputHandlers(super.getInputStream()).getBytes("utf-8"));
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values != null) {
            int length = values.length;
            String[] escapseValues = new String[length];
            int i = 0;
            while (i < length) {
                escapseValues[i] = XssHttpServletRequestWrapper.xssEncode(values[i]);
                ++i;
            }
            return escapseValues;
        }
        return super.getParameterValues(name);
    }

    public String inputHandlers(ServletInputStream servletInputStream) {
        StringBuilder sb;
        block24: {
            sb = new StringBuilder();
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)servletInputStream, Charset.forName("UTF-8")));
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (servletInputStream != null) {
                        try {
                            servletInputStream.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (servletInputStream != null) {
                    try {
                        servletInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (servletInputStream != null) {
                try {
                    servletInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return XssHttpServletRequestWrapper.xssEncode(sb.toString());
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value != null) {
            value = XssHttpServletRequestWrapper.xssEncode(value);
        }
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(XssHttpServletRequestWrapper.xssEncode(name));
        if (value != null) {
            value = XssHttpServletRequestWrapper.xssEncode(value);
        }
        return value;
    }

    private static String xssEncode(String s) {
        if (XSSSecurityConfig.REPLACE) {
            s = XSSSecurityManager.securityReplace(s);
        }
        return s;
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getOrgRequest();
        }
        return req;
    }

    public static void main(String[] args) {
        String reg = "^.*[A|a][L|l][E|e][R|r][T|t]\\s*\\(.*\\).*|.*[W|w][I|i][N|n][D|d][O|o][W|w]\\.[L|l][O|o][C|c][A|a][T|t][I|i][O|o][N|n]\\s*=.*|.*[S|s][T|t][Y|y][L|l][E|e]\\s*=.*[X|x]:[E|e][X|x].*[P|p][R|r][E|e][S|s]{1,2}[I|i][O|o][N|n]\\s*\\(.*\\).*|.*[D|d][O|o][C|c][U|u][M|m][E|e][N|n][T|t]\\.[C|c][O|o]{2}[K|k][I|i][E|e].*|.*[E|e][V|v][A|a][L|l]\\s*\\(.*\\).*|.*[U|u][N|n][E|e][S|s][C|c][A|a][P|p][E|e]\\s*\\(.*\\).*|.*[E|e][X|x][E|e][C|c][S|s][C|c][R|r][I|i][P|p][T|t]\\s*\\(.*\\).*|.*[M|m][S|s][G|g][B|b][O|o][X|x]\\s*\\(.*\\).*|.*[C|c][O|o][N|n][F|f][I|i][R|r][M|m]\\s*\\(.*\\).*|.*[P|p][R|r][O|o][M|m][P|p][T|t]\\s*\\(.*\\).*|.*<[S|s][C|c][R|r][I|i][P|p][T|t]>.*</[S|s][C|c][R|r][I|i][P|p][T|t]>.*|[[.&[^a]]|[|a|\\n|\\r\\n|\\r|\\u0085|\\u2028|\\u2029]]*<[S|s][C|c][R|r][I|i][P|p][T|t]>.*</[S|s][C|c][R|r][I|i][P|p][T|t]>[[.&[^a]]|[|a|\\n|\\r\\n|\\r|\\u0085|\\u2028|\\u2029]]*$";
        String s = "[{\"a\":\"<div>111</div>\"}]";
        System.out.println(s.replaceAll(reg, ""));
    }
}

