/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.organization.utils;

import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.service.OrganizationService;
import com.els.liby.organization.utils.OrganizationTypeEnum;
import java.util.List;

public abstract class UserOrganizationUtils {
    private static OrganizationService service;

    public static List<String> getUserCompanyCode(String userId) {
        if (service == null) {
            service = (OrganizationService)SpringContextHolder.getOneBean(OrganizationService.class);
        }
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andOrganizationTypeEqualTo(OrganizationTypeEnum.COMPANY.getValue());
        return service.queryCodeByUser(userId, example);
    }

    public static List<String> getUserFactoryCode(String userId) {
        if (service == null) {
            service = (OrganizationService)SpringContextHolder.getOneBean(OrganizationService.class);
        }
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andOrganizationTypeEqualTo(OrganizationTypeEnum.FACTORY.getValue());
        return service.queryCodeByUser(userId, example);
    }

    public static List<String> getUserAuthedCode(String userId, String organizationType) {
        if (service == null) {
            service = (OrganizationService)SpringContextHolder.getOneBean(OrganizationService.class);
        }
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andOrganizationTypeEqualTo(organizationType);
        return service.queryCodeByUser(userId, example);
    }

    public static List<Organization> getUserAuthedData(String userId, String organizationType) {
        if (service == null) {
            service = (OrganizationService)SpringContextHolder.getOneBean(OrganizationService.class);
        }
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andOrganizationTypeEqualTo(organizationType);
        return service.queryByUser(userId, example);
    }
}

