/*
 * Decompiled with CFR 0.152.
 */
package com.els.huayang.utils;

import com.els.base.core.exception.CommonException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;

public class DateXUtils {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static Date parse(String dateString) {
        LocalDateTime localDate = LocalDateTime.parse(dateString, DATE_TIME_FORMATTER);
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = localDate.atZone(zoneId).toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static String format(Date target) {
        Instant instant = target.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime.format(DATE_TIME_FORMATTER);
    }

    public static Date parse(String dateString, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDate = LocalDateTime.parse(dateString, dateTimeFormatter);
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = localDate.atZone(zoneId).toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static String format(Date target, DateTimeFormatter dateTimeFormatter) {
        Instant instant = target.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime.format(dateTimeFormatter);
    }

    public static Date getCurrentMonthLastday() {
        LocalDate today = LocalDate.now();
        LocalDate lastDayOfCurrentDate = today.with(TemporalAdjusters.lastDayOfMonth());
        return Date.from(lastDayOfCurrentDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getNextMonthLastDay(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(2, calendar.get(2) + 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        Date now = simpleDateFormat.parse("20221201");
        System.out.println(simpleDateFormat.format(DateXUtils.getNextMonthLastDay(now)));
        now = simpleDateFormat.parse("20230101");
        System.out.println(simpleDateFormat.format(DateXUtils.getNextMonthLastDay(now)));
    }

    public static List<String> getBetweenDate(Date start, Date end, DateTimeFormatter DATE_TIME_FORMATTER) {
        if (start.after(end)) {
            throw new CommonException("\u83b7\u53d6\u4e24\u4e2a\u65e5\u671f\u4e4b\u95f4\u7684\u6240\u6709\u65e5\u671f\u5931\u8d25,\u5f00\u59cb\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
        }
        ArrayList<String> dateList = new ArrayList<String>();
        String startStr = DateXUtils.format(start, DATE_TIME_FORMATTER);
        String endStr = DateXUtils.format(end, DATE_TIME_FORMATTER);
        while (startStr.compareTo(endStr) <= 0) {
            dateList.add(startStr);
            start = DateUtils.addDays((Date)start, (int)1);
            startStr = DateXUtils.format(start, DATE_TIME_FORMATTER);
        }
        return dateList;
    }
}

