/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SrmPageDTO;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.CompanyPermissionDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PermissionDataDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.dto.RolePermissionDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.ThirdAccountService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AccountBeanServiceImpl
implements AccountRpcService {
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RoleService roleService;
    @Resource
    private PermissionService permissionService;
    @Resource
    private ISysBaseAPI sysBaseAPI;
    @Resource
    private PermissionDataService permissionDataService;
    @Resource
    private ThirdAccountService thirdAccountService;
    @Resource
    private PersonalSettingService personalSettingService;
    @Resource
    private RolePermissionService rolePermissionService;

    public List<ThirdAccountDTO> getThirdAccount(String accountId, String thirdType) {
        List list = this.thirdAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)accountId)).eq((Object)"third_type", (Object)thirdType));
        ArrayList<ThirdAccountDTO> resultList = new ArrayList<ThirdAccountDTO>();
        for (ThirdAccount account : list) {
            ThirdAccountDTO accountDTO = new ThirdAccountDTO();
            BeanUtils.copyProperties((Object)account, (Object)accountDTO);
            resultList.add(accountDTO);
        }
        return resultList;
    }

    public List<PersonalSettingDTO> getPersonalSetting(String elsAccount, String subAccount) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(PersonalSetting::getElsAccount, (Object)elsAccount);
        query.eq(PersonalSetting::getSubAccount, (Object)subAccount);
        query.eq(PersonalSetting::getIsReceive, (Object)"0");
        List personalSettings = this.personalSettingService.list((Wrapper)query);
        ArrayList<PersonalSettingDTO> resultList = new ArrayList<PersonalSettingDTO>();
        for (PersonalSetting setting : personalSettings) {
            PersonalSettingDTO settingDTO = new PersonalSettingDTO();
            BeanUtils.copyProperties((Object)setting, (Object)settingDTO);
            resultList.add(settingDTO);
        }
        return resultList;
    }

    public ElsSubAccountDTO getAccount(String elsAccount, String subAccount) {
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        ElsSubAccountDTO accountDTO = new ElsSubAccountDTO();
        BeanUtils.copyProperties((Object)elsSubAccount, (Object)accountDTO);
        return accountDTO;
    }

    public ElsSubAccountDTO getAccountById(String id) {
        ElsSubAccount elsSubAccount = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)id));
        ElsSubAccountDTO accountDTO = new ElsSubAccountDTO();
        BeanUtils.copyProperties((Object)elsSubAccount, (Object)accountDTO);
        return accountDTO;
    }

    public LoginUserDTO getLoginUser(String account) {
        LoginUser loginUser = this.sysBaseAPI.getUserByAccount(account);
        LoginUserDTO loginUserDTO = new LoginUserDTO();
        BeanUtils.copyProperties((Object)loginUser, (Object)loginUserDTO);
        return loginUserDTO;
    }

    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        Set roleSet = this.elsSubAccountService.getUserRolesSet(elsAccount, subAccount);
        return roleSet;
    }

    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        Set permissionSet = this.elsSubAccountService.getUserPermissionsSet(elsAccount, subAccount);
        return permissionSet;
    }

    public Set<String> getAllOptPermission() {
        Set permissionSet = this.permissionService.getAllOptPermission();
        return permissionSet;
    }

    public List<PermissionDataDTO> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        List dataList = this.permissionDataService.getPermissionDataList(elsAccount, subAccount, businessType);
        ArrayList<PermissionDataDTO> resultList = new ArrayList<PermissionDataDTO>();
        for (PermissionData data : dataList) {
            PermissionDataDTO dataDTO = new PermissionDataDTO();
            BeanUtils.copyProperties((Object)data, (Object)dataDTO);
            resultList.add(dataDTO);
        }
        return resultList;
    }

    public List<ElsSubAccountDTO> getAccountList(String elsAccount, List<String> subAccounts) {
        List subAccountList = this.elsSubAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).in((Object)"sub_account", subAccounts));
        return SysUtil.copyProperties((List)subAccountList, ElsSubAccountDTO.class);
    }

    public List<ElsSubAccountDTO> getAllByAccount(String account) {
        List subAccountList = this.elsSubAccountService.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)account));
        return SysUtil.copyProperties((List)subAccountList, ElsSubAccountDTO.class);
    }

    public ElsSubAccountDTO addUserWithRole(ElsSubAccountDTO user, String roles) {
        ElsSubAccount account = (ElsSubAccount)SysUtil.copyProperties((Object)user, ElsSubAccount.class);
        this.elsSubAccountService.addUserWithRole(account, roles);
        return (ElsSubAccountDTO)SysUtil.copyProperties((Object)account, ElsSubAccountDTO.class);
    }

    public ElsSubAccountDTO save(ElsSubAccountDTO accountDTO) {
        ElsSubAccount account = (ElsSubAccount)SysUtil.copyProperties((Object)accountDTO, ElsSubAccount.class);
        this.elsSubAccountService.save((Object)account);
        return (ElsSubAccountDTO)SysUtil.copyProperties((Object)account, ElsSubAccountDTO.class);
    }

    public RoleDTO saveRole(RoleDTO roleDTO) {
        Role role = (Role)SysUtil.copyProperties((Object)roleDTO, Role.class);
        this.roleService.save((Object)role);
        return (RoleDTO)SysUtil.copyProperties((Object)role, RoleDTO.class);
    }

    public List<PermissionDTO> selectDefault() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_default_menu", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List list = this.permissionService.list((Wrapper)queryWrapper);
        if (list != null) {
            return SysUtil.copyProperties((List)list, PermissionDTO.class);
        }
        return null;
    }

    public List<CompanyPermissionDTO> insertCompanyMenuBatch(List<CompanyPermissionDTO> companyPermissionDTOs) {
        ArrayList companyPermissions = SysUtil.copyProperties(companyPermissionDTOs, CompanyPermission.class);
        this.permissionService.insertCompanyMeunBatch((List)companyPermissions);
        return SysUtil.copyProperties((List)companyPermissions, CompanyPermissionDTO.class);
    }

    public RolePermissionDTO saveRolePermission(RolePermissionDTO permissionDTO) {
        RolePermission entity = (RolePermission)SysUtil.copyProperties((Object)permissionDTO, RolePermission.class);
        this.rolePermissionService.save((Object)entity);
        return (RolePermissionDTO)SysUtil.copyProperties((Object)entity, RolePermissionDTO.class);
    }

    public List<PersonalSettingDTO> savePersonalSetting(List<PersonalSettingDTO> personalSettings) {
        ArrayList entityList = SysUtil.copyProperties(personalSettings, PersonalSetting.class);
        this.personalSettingService.saveBatch((Collection)entityList);
        return SysUtil.copyProperties((List)entityList, PersonalSettingDTO.class);
    }

    public SrmPageDTO<ElsSubAccountDTO> getSubAccountPage(int pageIndex, int pageSize, String elsAccount) {
        Page page = new Page((long)pageIndex, (long)pageSize);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)wrapper);
        ArrayList recordList = SysUtil.copyProperties((List)pageList.getRecords(), ElsSubAccountDTO.class);
        return new SrmPageDTO(pageList.getTotal(), (List)recordList);
    }

    public ElsSubAccountDTO getAccountByPhone(String phone) {
        ElsSubAccount userByPhone = this.elsSubAccountService.getUserByPhone(phone);
        return (ElsSubAccountDTO)Convert.convert(ElsSubAccountDTO.class, (Object)userByPhone);
    }

    public List<ElsSubAccountDTO> queryByElsAccountList(List<String> accountList) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname});
        List list = this.elsSubAccountService.list((Wrapper)wrapper);
        return Convert.toList(ElsSubAccountDTO.class, (Object)list);
    }
}

