/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SrmPageDTO;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.service.UserRoleRpcService;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class UserRoleBeanServiceImpl
implements UserRoleRpcService {
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RoleService roleService;

    public List<ElsSubAccountDTO> getAccountListByRoles(String roles) {
        Object[] roleArray = roles.split(",");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"role_id", roleArray);
        List roleList = this.userRoleService.list((Wrapper)queryWrapper);
        List idList = roleList.stream().map(UserRole::getUserId).distinct().collect(Collectors.toList());
        List accountList = this.elsSubAccountService.listByIds(idList);
        return SysUtil.copyProperties((List)accountList, ElsSubAccountDTO.class);
    }

    public void insertRole(RoleDTO roleDTO) {
        Role role = new Role();
        BeanUtils.copyProperties((Object)roleDTO, (Object)role);
        this.roleService.save((Object)role);
    }

    public SrmPageDTO<RoleDTO> getRolePage(int pageIndex, int pageSize, String elsAccount) {
        Page page = new Page((long)pageIndex, (long)pageSize);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Role::getElsAccount, (Object)elsAccount);
        IPage pageList = this.roleService.page((IPage)page, (Wrapper)queryWrapper);
        ArrayList recordList = SysUtil.copyProperties((List)pageList.getRecords(), RoleDTO.class);
        return new SrmPageDTO(pageList.getTotal(), (List)recordList);
    }
}

