/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SrmPageDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.CompanyPermissionDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PermissionDataDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.dto.RolePermissionDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.ThirdAccountService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AccountBeanServiceImpl
implements AccountRpcService {
    private static final Logger log = LoggerFactory.getLogger(AccountBeanServiceImpl.class);
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RoleService roleService;
    @Resource
    private PermissionService permissionService;
    @Resource
    private ISysBaseAPI sysBaseAPI;
    @Resource
    private PermissionDataService permissionDataService;
    @Resource
    private ThirdAccountService thirdAccountService;
    @Resource
    private PersonalSettingService personalSettingService;
    @Resource
    private RolePermissionService rolePermissionService;
    @Resource
    private ElsTenantService elsTenantService;

    public List<ThirdAccountDTO> getThirdAccount(String accountId, String thirdType) {
        List list = this.thirdAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)accountId)).eq((Object)"third_type", (Object)thirdType));
        ArrayList<ThirdAccountDTO> resultList = new ArrayList<ThirdAccountDTO>();
        for (ThirdAccount account : list) {
            ThirdAccountDTO accountDTO = new ThirdAccountDTO();
            BeanUtils.copyProperties((Object)account, (Object)accountDTO);
            resultList.add(accountDTO);
        }
        return resultList;
    }

    public List<PersonalSettingDTO> getPersonalSetting(String elsAccount, String subAccount) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(PersonalSetting::getElsAccount, (Object)elsAccount);
        query.eq(PersonalSetting::getSubAccount, (Object)subAccount);
        query.eq(PersonalSetting::getIsReceive, (Object)"0");
        List personalSettings = this.personalSettingService.list((Wrapper)query);
        ArrayList<PersonalSettingDTO> resultList = new ArrayList<PersonalSettingDTO>();
        for (PersonalSetting setting : personalSettings) {
            PersonalSettingDTO settingDTO = new PersonalSettingDTO();
            BeanUtils.copyProperties((Object)setting, (Object)settingDTO);
            resultList.add(settingDTO);
        }
        return resultList;
    }

    public ElsSubAccountDTO getAccount(String elsAccount, String subAccount) {
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        ElsSubAccountDTO accountDTO = new ElsSubAccountDTO();
        BeanUtils.copyProperties((Object)elsSubAccount, (Object)accountDTO);
        return accountDTO;
    }

    public ElsSubAccountDTO getAccountById(String id) {
        ElsSubAccount elsSubAccount = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)id));
        ElsSubAccountDTO accountDTO = new ElsSubAccountDTO();
        BeanUtils.copyProperties((Object)elsSubAccount, (Object)accountDTO);
        return accountDTO;
    }

    public LoginUserDTO getLoginUser(String account) {
        LoginUser loginUser = this.sysBaseAPI.getUserByAccount(account);
        LoginUserDTO loginUserDTO = new LoginUserDTO();
        BeanUtils.copyProperties((Object)loginUser, (Object)loginUserDTO);
        return loginUserDTO;
    }

    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        Set roleSet = this.elsSubAccountService.getUserRolesSet(elsAccount, subAccount);
        return roleSet;
    }

    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        Set permissionSet = this.elsSubAccountService.getUserPermissionsSet(elsAccount, subAccount);
        return permissionSet;
    }

    public Set<String> getAllOptPermission() {
        Set permissionSet = this.permissionService.getAllOptPermission();
        return permissionSet;
    }

    public List<PermissionDataDTO> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        List dataList = this.permissionDataService.getPermissionDataList(elsAccount, subAccount, businessType);
        ArrayList<PermissionDataDTO> resultList = new ArrayList<PermissionDataDTO>();
        for (PermissionData data : dataList) {
            PermissionDataDTO dataDTO = new PermissionDataDTO();
            BeanUtils.copyProperties((Object)data, (Object)dataDTO);
            resultList.add(dataDTO);
        }
        return resultList;
    }

    public List<ElsSubAccountDTO> getAccountList(String elsAccount, List<String> subAccounts) {
        List subAccountList = this.elsSubAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).in((Object)"sub_account", subAccounts));
        return SysUtil.copyProperties((List)subAccountList, ElsSubAccountDTO.class);
    }

    public List<ElsSubAccountDTO> getAccountListByElsSubAccountWithoutUser(List<String> elsSubAccountList) {
        List subAccountList = this.elsSubAccountService.getAccountListByElsSubAccountWithoutUser(elsSubAccountList);
        return Convert.toList(ElsSubAccountDTO.class, (Object)subAccountList);
    }

    public List<ElsSubAccountDTO> getAllByAccount(String account) {
        List subAccountList = this.elsSubAccountService.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)account));
        return SysUtil.copyProperties((List)subAccountList, ElsSubAccountDTO.class);
    }

    public ElsSubAccountDTO addUserWithRole(ElsSubAccountDTO user, String roles) {
        ElsSubAccount account = (ElsSubAccount)SysUtil.copyProperties((Object)user, ElsSubAccount.class);
        this.elsSubAccountService.addUserWithRole(account, roles);
        return (ElsSubAccountDTO)SysUtil.copyProperties((Object)account, ElsSubAccountDTO.class);
    }

    public ElsSubAccountDTO save(ElsSubAccountDTO accountDTO) {
        ElsSubAccount account = (ElsSubAccount)SysUtil.copyProperties((Object)accountDTO, ElsSubAccount.class);
        this.elsSubAccountService.save((Object)account);
        return (ElsSubAccountDTO)SysUtil.copyProperties((Object)account, ElsSubAccountDTO.class);
    }

    public RoleDTO saveRole(RoleDTO roleDTO) {
        Role role = (Role)SysUtil.copyProperties((Object)roleDTO, Role.class);
        this.roleService.save((Object)role);
        return (RoleDTO)SysUtil.copyProperties((Object)role, RoleDTO.class);
    }

    public List<PermissionDTO> selectDefault() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_default_menu", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List list = this.permissionService.list((Wrapper)queryWrapper);
        if (list != null) {
            return SysUtil.copyProperties((List)list, PermissionDTO.class);
        }
        return null;
    }

    public List<CompanyPermissionDTO> insertCompanyMenuBatch(List<CompanyPermissionDTO> companyPermissionDTOs) {
        ArrayList companyPermissions = SysUtil.copyProperties(companyPermissionDTOs, CompanyPermission.class);
        this.permissionService.insertCompanyMeunBatch((List)companyPermissions);
        return SysUtil.copyProperties((List)companyPermissions, CompanyPermissionDTO.class);
    }

    public RolePermissionDTO saveRolePermission(RolePermissionDTO permissionDTO) {
        RolePermission entity = (RolePermission)SysUtil.copyProperties((Object)permissionDTO, RolePermission.class);
        this.rolePermissionService.save((Object)entity);
        return (RolePermissionDTO)SysUtil.copyProperties((Object)entity, RolePermissionDTO.class);
    }

    public List<PersonalSettingDTO> savePersonalSetting(List<PersonalSettingDTO> personalSettings) {
        ArrayList entityList = SysUtil.copyProperties(personalSettings, PersonalSetting.class);
        this.personalSettingService.saveBatch((Collection)entityList);
        return SysUtil.copyProperties((List)entityList, PersonalSettingDTO.class);
    }

    public SrmPageDTO<ElsSubAccountDTO> getSubAccountPage(int pageIndex, int pageSize, String elsAccount) {
        Page page = new Page((long)pageIndex, (long)pageSize);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)wrapper);
        ArrayList recordList = SysUtil.copyProperties((List)pageList.getRecords(), ElsSubAccountDTO.class);
        return new SrmPageDTO(pageList.getTotal(), (List)recordList);
    }

    public ElsSubAccountDTO getAccountByPhone(String phone) {
        ElsSubAccount userByPhone = this.elsSubAccountService.getUserByPhone(phone);
        return (ElsSubAccountDTO)Convert.convert(ElsSubAccountDTO.class, (Object)userByPhone);
    }

    public List<ElsSubAccountDTO> queryByElsAccountList(List<String> accountList) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname});
        List list = this.elsSubAccountService.list((Wrapper)wrapper);
        return Convert.toList(ElsSubAccountDTO.class, (Object)list);
    }

    public List<RoleDTO> getAllRole() {
        List roles = this.roleService.list();
        if (!roles.isEmpty()) {
            return SysUtil.copyProperties((List)roles, RoleDTO.class);
        }
        return null;
    }

    public ElsSubAccountDTO getUserBySubAccount(String subAccount) {
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getUserBySubAccount(subAccount);
        return elsSubAccount == null ? new ElsSubAccountDTO() : (ElsSubAccountDTO)Convert.convert(ElsSubAccountDTO.class, (Object)elsSubAccount);
    }

    public void batchSaveRolePermission(List<RolePermissionDTO> companyPermissionList) {
        List rolePermissionList = Convert.toList(RolePermission.class, companyPermissionList);
        this.rolePermissionService.saveBatch((Collection)rolePermissionList);
    }

    private List<PersonalSetting> buildPersonalSetting(String elsAccount, String subaccount) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSetting> personalSettings = new ArrayList<PersonalSetting>();
        for (String str : list) {
            PersonalSetting personalSetting = new PersonalSetting();
            personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
            personalSetting.setElsAccount(elsAccount);
            personalSetting.setSubAccount(subaccount);
            personalSetting.setCreateBy("1001");
            personalSetting.setCreateTime(new Date());
            personalSetting.setUpdateBy("1001");
            personalSetting.setUpdateTime(new Date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(Integer.valueOf(0));
            personalSettings.add(personalSetting);
        }
        return personalSettings;
    }

    public ElsSubAccountDTO initSupplierAccountInfo(String elsAccount, ElsSubAccountDTO user, String companyName, String sourceType) {
        log.info("::: AccountDubboServiceImpl#initSupplierAccountInfo start initSupplierAccountInfo...{}", (Object)companyName);
        Role role = new Role();
        role.setElsAccount(elsAccount);
        role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
        role.setRoleCode("companyAdmin");
        this.roleService.save((Object)role);
        ElsSubAccount account = (ElsSubAccount)SysUtil.copyProperties((Object)user, ElsSubAccount.class);
        this.elsSubAccountService.addUserWithRole(account, role.getId());
        List<PersonalSetting> personalSettingList = this.buildPersonalSetting(elsAccount, account.getSubAccount());
        this.personalSettingService.saveBatch(personalSettingList);
        ElsTenant elsTenant = new ElsTenant();
        elsTenant.setAccountStatus("1");
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setCompanyName(companyName);
        elsTenant.setSourceType(sourceType);
        try {
            elsTenant.setExpiryDate(new SimpleDateFormat("yyyy-MM-dd").parse("2029-12-31"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.elsTenantService.save((Object)elsTenant);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_default_menu", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List list = this.permissionService.list((Wrapper)queryWrapper);
        ArrayList<CompanyPermission> companyPermissions = new ArrayList<CompanyPermission>();
        for (Permission permission : list) {
            CompanyPermission companyPermission = new CompanyPermission();
            companyPermission.setId(IdWorker.getIdStr());
            companyPermission.setElsAccount(elsAccount);
            companyPermission.setPermissionId(permission.getId());
            companyPermission.setName(permission.getName());
            companyPermission.setSortNo(permission.getSortNo());
            companyPermission.setIcon(permission.getIcon());
            companyPermission.setIconColor(permission.getIconColor());
            companyPermission.setRuleFlag(permission.getRuleFlag());
            companyPermission.setStatus(permission.getStatus());
            companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
            companyPermission.setUpdateTime(new Date());
            companyPermissions.add(companyPermission);
        }
        if (!companyPermissions.isEmpty()) {
            this.permissionService.insertCompanyMeunBatch(companyPermissions);
            ArrayList companyPermissionList = Lists.newArrayList();
            for (CompanyPermission companyPermission : companyPermissions) {
                RolePermission rolePermission = new RolePermission();
                rolePermission.setElsAccount(elsAccount);
                rolePermission.setRoleId(role.getId());
                rolePermission.setPermissionId(companyPermission.getPermissionId());
                companyPermissionList.add(rolePermission);
            }
            if (CollUtil.isNotEmpty((Collection)companyPermissionList)) {
                this.rolePermissionService.saveBatch((Collection)companyPermissionList);
            }
        }
        user.setId(account.getId());
        log.info("::: AccountDubboServiceImpl#initSupplierAccountInfo end initSupplierAccountInfo...{}", (Object)companyName);
        return user;
    }

    public List<RoleDTO> selectWithoutElsAccountOfAllRole(List<String> accountList) {
        return this.roleService.selectWithoutElsAccountOfAllRole(accountList);
    }

    public List<ElsSubAccountDTO> getAccountListByUserIds(String userIds) {
        String[] userIdArray = userIds.split(",");
        List accountList = this.elsSubAccountService.listByIds(Arrays.asList(userIdArray));
        return SysUtil.copyProperties((List)accountList, ElsSubAccountDTO.class);
    }

    public SrmPageDTO<ElsSubAccountDTO> getSubAccountPageByCondition(int currentPage, int pageSize, String elsAccount, String fullName, String account, String photo) {
        Page page = new Page((long)currentPage, (long)pageSize);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        wrapper.eq(ElsSubAccount::getStatus, (Object)1);
        if (StringUtils.isNotBlank((CharSequence)fullName)) {
            wrapper.like(ElsSubAccount::getRealname, (Object)fullName);
        }
        if (StringUtils.isNotBlank((CharSequence)account)) {
            wrapper.like(ElsSubAccount::getSubAccount, (Object)account);
        }
        if (StringUtils.isNotBlank((CharSequence)photo)) {
            wrapper.likeRight(ElsSubAccount::getPhone, (Object)photo);
        }
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)wrapper);
        ArrayList recordList = SysUtil.copyProperties((List)pageList.getRecords(), ElsSubAccountDTO.class);
        return new SrmPageDTO(pageList.getTotal(), pageList.getPages(), (List)recordList);
    }

    public List<ElsSubAccountDTO> getSubAccountByOrgCodeIds(String orgIds) {
        Object[] orgIdArray = orgIds.split(",");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"org_code", orgIdArray);
        List subAccounts = this.elsSubAccountService.list((Wrapper)queryWrapper);
        if (subAccounts != null) {
            return SysUtil.copyProperties((List)subAccounts, ElsSubAccountDTO.class);
        }
        return Collections.emptyList();
    }
}

